/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCRefinementChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.MemberWithBaseScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00112\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0003\u000f\u0010\u0011B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "Regular", "ForExpectClass", "Companion", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$Regular;", "checkers.native"})
public abstract class FirNativeObjCRefinementOverridesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private FirNativeObjCRefinementOverridesChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirTypeScope baseScope = FirHelpersKt.unsubstitutedScope(declaration, context);
        FirContainingNamesAwareScopeKt.processAllFunctions(baseScope, arg_0 -> FirNativeObjCRefinementOverridesChecker.check$lambda$0(baseScope, declaration, context, reporter, arg_0));
        FirContainingNamesAwareScopeKt.processAllProperties(baseScope, arg_0 -> FirNativeObjCRefinementOverridesChecker.check$lambda$1(baseScope, declaration, context, reporter, arg_0));
    }

    private static final Unit check$lambda$0(FirTypeScope $baseScope, FirClass $declaration, CheckerContext $context, DiagnosticReporter $reporter, FirNamedFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        if (!ClassMembersKt.isIntersectionOverride(symbol)) {
            return Unit.INSTANCE;
        }
        Companion.check($baseScope, symbol, $declaration, $context, $reporter, CollectionsKt.emptyList(), CollectionsKt.emptyList());
        return Unit.INSTANCE;
    }

    private static final Unit check$lambda$1(FirTypeScope $baseScope, FirClass $declaration, CheckerContext $context, DiagnosticReporter $reporter, FirVariableSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        if (!ClassMembersKt.isIntersectionOverride(symbol)) {
            return Unit.INSTANCE;
        }
        Companion.check($baseScope, symbol, $declaration, $context, $reporter, CollectionsKt.emptyList(), CollectionsKt.emptyList());
        return Unit.INSTANCE;
    }

    public /* synthetic */ FirNativeObjCRefinementOverridesChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JU\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014J3\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ+\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJC\u0010 \u001a\u00020\u0012*\u00020\f2\u0006\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000e2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b \u0010!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "baseScope", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "memberSymbol", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declarationToReport", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "objCAnnotations", "swiftAnnotations", "", "check", "(Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/List;Ljava/util/List;)V", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lkotlin/Pair;", "", "inheritsRefinedAnnotations", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;)Lkotlin/Pair;", "hasRefinedAnnotations", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/FirSession;)Lkotlin/Pair;", "declaration", "annotations", "notRefinedSupers", "reportIncompatibleOverride", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V"})
    public static final class Companion {
        private Companion() {
        }

        public final void check(@NotNull FirTypeScope baseScope, @NotNull FirCallableSymbol<?> memberSymbol, @NotNull FirDeclaration declarationToReport, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull List<? extends FirAnnotation> objCAnnotations, @NotNull List<? extends FirAnnotation> swiftAnnotations) {
            Intrinsics.checkNotNullParameter(baseScope, "baseScope");
            Intrinsics.checkNotNullParameter(memberSymbol, "memberSymbol");
            Intrinsics.checkNotNullParameter(declarationToReport, "declarationToReport");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(objCAnnotations, "objCAnnotations");
            Intrinsics.checkNotNullParameter(swiftAnnotations, "swiftAnnotations");
            List<MemberWithBaseScope<FirCallableSymbol<?>>> overriddenMemberSymbols = FirTypeScopeKt.getDirectOverriddenMembersWithBaseScope(baseScope, memberSymbol);
            if (overriddenMemberSymbols.isEmpty()) {
                return;
            }
            boolean isHiddenFromObjC = !((Collection)objCAnnotations).isEmpty();
            boolean isRefinedInSwift = !((Collection)swiftAnnotations).isEmpty();
            List supersNotHiddenFromObjC = new ArrayList();
            List supersNotRefinedInSwift = new ArrayList();
            for (MemberWithBaseScope<FirCallableSymbol<?>> memberWithBaseScope : overriddenMemberSymbols) {
                FirCallableSymbol<?> symbol = memberWithBaseScope.component1();
                FirTypeScope scope2 = memberWithBaseScope.component2();
                Pair<Boolean, Boolean> pair = this.inheritsRefinedAnnotations(symbol, context.getSession(), scope2);
                boolean superIsHiddenFromObjC = pair.component1();
                boolean superIsRefinedInSwift = pair.component2();
                if (superIsHiddenFromObjC) {
                    isHiddenFromObjC = true;
                } else {
                    supersNotHiddenFromObjC.add(symbol);
                }
                if (superIsRefinedInSwift) {
                    isRefinedInSwift = true;
                    continue;
                }
                supersNotRefinedInSwift.add(symbol);
            }
            if (isHiddenFromObjC && !((Collection)supersNotHiddenFromObjC).isEmpty()) {
                this.reportIncompatibleOverride(reporter, declarationToReport, objCAnnotations, supersNotHiddenFromObjC, context);
            }
            if (isRefinedInSwift && !((Collection)supersNotRefinedInSwift).isEmpty()) {
                this.reportIncompatibleOverride(reporter, declarationToReport, swiftAnnotations, supersNotRefinedInSwift, context);
            }
        }

        private final Pair<Boolean, Boolean> inheritsRefinedAnnotations(FirCallableSymbol<?> $this$inheritsRefinedAnnotations, FirSession session, FirTypeScope baseScope) {
            Pair<Boolean, Boolean> pair = this.hasRefinedAnnotations($this$inheritsRefinedAnnotations, session);
            boolean hasObjC = pair.component1();
            boolean hasSwift = pair.component2();
            if (hasObjC && hasSwift) {
                return TuplesKt.to(true, true);
            }
            MemberWithBaseScope<FirCallableSymbol<?>> memberWithBaseScope = CollectionsKt.firstOrNull(FirTypeScopeKt.getDirectOverriddenMembersWithBaseScope(baseScope, $this$inheritsRefinedAnnotations));
            if (memberWithBaseScope == null) {
                return TuplesKt.to(hasObjC, hasSwift);
            }
            MemberWithBaseScope<FirCallableSymbol<?>> memberWithBaseScope2 = memberWithBaseScope;
            FirCallableSymbol<?> overriddenMemberSymbol = memberWithBaseScope2.component1();
            FirTypeScope scope2 = memberWithBaseScope2.component2();
            Pair<Boolean, Boolean> pair2 = this.inheritsRefinedAnnotations(overriddenMemberSymbol, session, scope2);
            boolean inheritsObjC = pair2.component1();
            boolean inheritsSwift = pair2.component2();
            return TuplesKt.to(hasObjC || inheritsObjC, hasSwift || inheritsSwift);
        }

        private final Pair<Boolean, Boolean> hasRefinedAnnotations(FirCallableSymbol<?> $this$hasRefinedAnnotations, FirSession session) {
            boolean hasObjC = false;
            boolean hasSwift = false;
            for (FirAnnotation annotation : $this$hasRefinedAnnotations.getResolvedAnnotationsWithClassIds()) {
                FirClassLikeSymbol<?> firClassLikeSymbol = FirAnnotationUtilsKt.toAnnotationClassLikeSymbol(annotation, session);
                List<FirAnnotation> list = firClassLikeSymbol != null ? firClassLikeSymbol.getResolvedAnnotationsWithClassIds() : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List<FirAnnotation> metaAnnotations = list;
                for (FirAnnotation metaAnnotation : metaAnnotations) {
                    ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId(metaAnnotation, session);
                    if (Intrinsics.areEqual(classId, FirNativeObjCRefinementChecker.INSTANCE.getHidesFromObjCClassId())) {
                        hasObjC = true;
                        break;
                    }
                    if (!Intrinsics.areEqual(classId, FirNativeObjCRefinementChecker.INSTANCE.getRefinesInSwiftClassId())) continue;
                    hasSwift = true;
                    break;
                }
                if (!hasObjC || !hasSwift) continue;
                return TuplesKt.to(true, true);
            }
            return TuplesKt.to(hasObjC, hasSwift);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportIncompatibleOverride(DiagnosticReporter $this$reportIncompatibleOverride, FirDeclaration declaration, List<? extends FirAnnotation> annotations2, List<? extends FirCallableSymbol<?>> notRefinedSupers, CheckerContext context) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = notRefinedSupers;
            boolean bl = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirRegularClassSymbol it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
                boolean bl22 = false;
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(it);
                if ((coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneClassLikeLookupTag, context.getSession()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List containingDeclarations = (List)destination$iv$iv;
            if (annotations2.isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default($this$reportIncompatibleOverride, (AbstractKtSourceElement)declaration.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_OBJC_REFINEMENT_OVERRIDE(), declaration.getSymbol(), (Object)containingDeclarations, (DiagnosticContext)context, null, 32, null);
            } else {
                for (FirAnnotation firAnnotation : annotations2) {
                    KtDiagnosticReportHelpersKt.reportOn$default($this$reportIncompatibleOverride, (AbstractKtSourceElement)firAnnotation.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_OBJC_REFINEMENT_OVERRIDE(), declaration.getSymbol(), (Object)containingDeclarations, (DiagnosticContext)context, null, 32, null);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "declaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "check", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V"})
    public static final class ForExpectClass
    extends FirNativeObjCRefinementOverridesChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration, context, reporter);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "declaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "check", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V"})
    public static final class Regular
    extends FirNativeObjCRefinementOverridesChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirMemberDeclaration $this$isExpect$iv = declaration;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(declaration, context, reporter);
        }
    }
}

