/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.MemberWithBaseScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.annotations.ThrowUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 #2\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0004!\"#$B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0019\u001a\u00020\u0010*\u0004\u0018\u00010\u001aH\u0002J\u001a\u0010\u001b\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u0082\u0001\u0002%&\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInheritance", "", "throwsAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "getInheritedThrows", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ThrowsFilter;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "hasUnresolvedArgument", "Lorg/jetbrains/kotlin/fir/FirElement;", "decodeThrowsFilter", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getClassIds", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Regular", "ForExpectClass", "Companion", "ThrowsFilter", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Regular;", "checkers.native"})
public abstract class FirNativeThrowsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ClassId throwsClassId = ClassId.Companion.topLevel(ThrowUtilKt.getKOTLIN_THROWS_ANNOTATION_FQ_NAME());
    @NotNull
    private static final FqName cancellationExceptionFqName = new FqName("kotlin.coroutines.cancellation.CancellationException");
    @NotNull
    private static final Set<ClassId> cancellationExceptionAndSupersClassIds;

    private FirNativeThrowsChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirAnnotation throwsAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, throwsClassId, context.getSession());
        if (!this.checkInheritance(declaration, throwsAnnotation, context, reporter)) {
            return;
        }
        if (this.hasUnresolvedArgument(throwsAnnotation)) {
            return;
        }
        Object object = throwsAnnotation;
        if (object == null || (object = this.getClassIds((FirAnnotation)object, context.getSession())) == null) {
            return;
        }
        Object classIds = object;
        if (classIds.isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getTHROWS_LIST_EMPTY(), (DiagnosticContext)context, null, 8, null);
            return;
        }
        FirElement firElement = declaration;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "SUSPEND_KEYWORD");
        if (FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
            boolean bl;
            block9: {
                Iterable $this$none$iv = (Iterable)classIds;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ClassId it = (ClassId)element$iv;
                        boolean bl2 = false;
                        if (!cancellationExceptionAndSupersClassIds.contains(it)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getMISSING_EXCEPTION_IN_THROWS_ON_SUSPEND(), (Object)cancellationExceptionFqName, (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkInheritance(FirDeclaration declaration, FirAnnotation throwsAnnotation, CheckerContext context, DiagnosticReporter reporter) {
        if (!(declaration instanceof FirSimpleFunction)) {
            return true;
        }
        Iterable $this$distinctBy$iv = this.getInheritedThrows((FirSimpleFunction)declaration, throwsAnnotation, context).entrySet();
        boolean $i$f$distinctBy = false;
        HashSet<ThrowsFilter> set$iv = new HashSet<ThrowsFilter>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Map.Entry it = (Map.Entry)e$iv;
            boolean bl = false;
            ThrowsFilter key$iv = (ThrowsFilter)it.getValue();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List inherited = list$iv;
        if (inherited.size() >= 2) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            $this$distinctBy$iv = inherited;
            KtDiagnosticFactory1<Collection<FirRegularClassSymbol>> ktDiagnosticFactory1 = FirNativeErrors.INSTANCE.getINCOMPATIBLE_THROWS_INHERITED();
            AbstractKtSourceElement abstractKtSourceElement = ((FirSimpleFunction)declaration).getSource();
            DiagnosticReporter diagnosticReporter = reporter;
            boolean $i$f$mapNotNull = false;
            set$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirRegularClassSymbol it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)it.getKey());
                if ((coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneClassLikeLookupTag, context.getSession()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)list, (DiagnosticContext)context, null, 16, null);
            return false;
        }
        Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull(inherited);
        if (entry == null) {
            return true;
        }
        Map.Entry entry2 = entry;
        FirNamedFunctionSymbol overriddenMember = (FirNamedFunctionSymbol)entry2.getKey();
        ThrowsFilter overriddenThrows = (ThrowsFilter)entry2.getValue();
        FirAnnotation firAnnotation = throwsAnnotation;
        if ((firAnnotation != null ? firAnnotation.getSource() : null) != null && !Intrinsics.areEqual(this.decodeThrowsFilter(throwsAnnotation, context.getSession()), overriddenThrows)) {
            FirRegularClassSymbol containingClassSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(overriddenMember);
            FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneClassLikeLookupTag, context.getSession()) : null;
            if (containingClassSymbol != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)throwsAnnotation.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_THROWS_OVERRIDE(), (Object)containingClassSymbol, (DiagnosticContext)context, null, 16, null);
            }
            return false;
        }
        return true;
    }

    private final Map<FirNamedFunctionSymbol, ThrowsFilter> getInheritedThrows(FirSimpleFunction function2, FirAnnotation throwsAnnotation, CheckerContext context) {
        FirTypeScope currentScope;
        Set visited2 = new LinkedHashSet();
        Map result2 = new LinkedHashMap();
        Object object = ClassMembersKt.containingClassLookupTag(function2.getSymbol());
        FirTypeScope firTypeScope = object != null && (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, context.getSession())) != null ? FirHelpersKt.unsubstitutedScope((FirClassSymbol)object, context) : (currentScope = null);
        if (currentScope != null) {
            FirNativeThrowsChecker.getInheritedThrows$getInheritedThrows(visited2, function2, result2, this, context, throwsAnnotation, new MemberWithBaseScope<FirCallableSymbol>(function2.getSymbol(), currentScope));
        }
        return result2;
    }

    private final boolean hasUnresolvedArgument(FirElement $this$hasUnresolvedArgument) {
        if ($this$hasUnresolvedArgument instanceof FirWrappedArgumentExpression) {
            return this.hasUnresolvedArgument(((FirWrappedArgumentExpression)$this$hasUnresolvedArgument).getExpression());
        }
        if ($this$hasUnresolvedArgument instanceof FirResolvable && FirReferenceUtilsKt.isError(((FirResolvable)$this$hasUnresolvedArgument).getCalleeReference())) {
            return true;
        }
        if ($this$hasUnresolvedArgument instanceof FirVarargArgumentsExpression) {
            for (FirExpression argument : ((FirVarargArgumentsExpression)$this$hasUnresolvedArgument).getArguments()) {
                if (!this.hasUnresolvedArgument(argument)) continue;
                return true;
            }
        }
        if ($this$hasUnresolvedArgument instanceof FirCall) {
            for (FirExpression argument : ((FirCall)$this$hasUnresolvedArgument).getArgumentList().getArguments()) {
                if (!this.hasUnresolvedArgument(argument)) continue;
                return true;
            }
        }
        if ($this$hasUnresolvedArgument instanceof FirResolvedQualifier) {
            FirClassLikeSymbol<?> firClassLikeSymbol = ((FirResolvedQualifier)$this$hasUnresolvedArgument).getSymbol();
            if (firClassLikeSymbol != null) {
                FirClassLikeSymbol<?> symbol = firClassLikeSymbol;
                boolean bl = false;
                if (symbol instanceof FirTypeAliasSymbol && ConeTypeUtilsKt.hasError(((FirTypeAliasSymbol)symbol).getResolvedExpandedTypeRef().getConeType())) {
                    return true;
                }
            }
        }
        return false;
    }

    private final ThrowsFilter decodeThrowsFilter(FirAnnotation throwsAnnotation, FirSession session) {
        Object object = throwsAnnotation;
        return new ThrowsFilter(object != null && (object = this.getClassIds((FirAnnotation)object, session)) != null ? CollectionsKt.toSet((Iterable)object) : null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassId> getClassIds(FirAnnotation $this$getClassIds, FirSession session) {
        void $this$mapNotNullTo$iv$iv;
        Object object = (FirExpression)CollectionsKt.firstOrNull((Iterable)$this$getClassIds.getArgumentMapping().getMapping().values());
        if (object == null || (object = FirAnnotationUtilsKt.unwrapVarargValue((FirExpression)object)) == null) {
            return CollectionsKt.emptyList();
        }
        Object unwrappedArgs = object;
        Iterable $this$mapNotNull$iv = (Iterable)unwrappedArgs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            FirRegularClassSymbol firRegularClassSymbol = FirAnnotationHelpersKt.extractClassFromArgument(it, session);
            if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void getInheritedThrows$getInheritedThrows(Set<FirNamedFunctionSymbol> visited2, FirSimpleFunction $function, Map<FirNamedFunctionSymbol, ThrowsFilter> result2, FirNativeThrowsChecker this$0, CheckerContext $context, FirAnnotation localThrowsAnnotation, MemberWithBaseScope<? extends FirNamedFunctionSymbol> functionWithScope) {
        FirNamedFunctionSymbol localFunctionSymbol = functionWithScope.getMember();
        if (!visited2.add(localFunctionSymbol)) {
            return;
        }
        List<MemberWithBaseScope<FirNamedFunctionSymbol>> directOverriddenFunctionsWithScopes = FirTypeScopeKt.getDirectOverriddenFunctionsWithBaseScope(functionWithScope.getBaseScope(), localFunctionSymbol);
        if (Intrinsics.areEqual(localFunctionSymbol, $function.getSymbol()) || localThrowsAnnotation == null && !((Collection)directOverriddenFunctionsWithScopes).isEmpty()) {
            for (MemberWithBaseScope<FirNamedFunctionSymbol> directOverriddenFunctionWithScope : directOverriddenFunctionsWithScopes) {
                FirAnnotation firAnnotation;
                FirNamedFunctionSymbol overriddenFunction = directOverriddenFunctionWithScope.getMember();
                boolean condition$iv = ClassMembersKt.isSubstitutionOrIntersectionOverride(overriddenFunction);
                boolean $i$f$runUnless = false;
                if (condition$iv) {
                    firAnnotation = null;
                } else {
                    boolean bl = false;
                    firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(overriddenFunction, throwsClassId, $context.getSession());
                }
                FirAnnotation annotation = firAnnotation;
                FirNativeThrowsChecker.getInheritedThrows$getInheritedThrows(visited2, $function, result2, this$0, $context, annotation, directOverriddenFunctionWithScope);
            }
        } else {
            result2.put(localFunctionSymbol, this$0.decodeThrowsFilter(localThrowsAnnotation, $context.getSession()));
        }
    }

    public /* synthetic */ FirNativeThrowsChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    static {
        ClassId[] classIdArray = new ClassId[]{ClassId.Companion.topLevel(StandardNames.FqNames.throwable), ClassId.Companion.topLevel(new FqName("kotlin.Exception")), ClassId.Companion.topLevel(new FqName("kotlin.RuntimeException")), ClassId.Companion.topLevel(new FqName("kotlin.IllegalStateException")), ClassId.Companion.topLevel(cancellationExceptionFqName)};
        cancellationExceptionAndSupersClassIds = SetsKt.setOf(classIdArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/name/ClassId;", "throwsClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/name/FqName;", "cancellationExceptionFqName", "Lorg/jetbrains/kotlin/name/FqName;", "", "cancellationExceptionAndSupersClassIds", "Ljava/util/Set;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "check", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V"})
    public static final class ForExpectClass
    extends FirNativeThrowsChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            boolean bl;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirMemberDeclaration firMemberDeclaration = declaration instanceof FirMemberDeclaration ? (FirMemberDeclaration)declaration : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (!bl) {
                return;
            }
            super.check(declaration, context, reporter);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "check", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V"})
    public static final class Regular
    extends FirNativeThrowsChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            boolean bl;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirMemberDeclaration firMemberDeclaration = declaration instanceof FirMemberDeclaration ? (FirMemberDeclaration)declaration : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
            super.check(declaration, context, reporter);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\t\u001a\u00020\u00002\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u00c7\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d7\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ThrowsFilter;", "", "", "Lorg/jetbrains/kotlin/name/ClassId;", "classes", "<init>", "(Ljava/util/Set;)V", "component1", "()Ljava/util/Set;", "copy", "(Ljava/util/Set;)Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeThrowsChecker$ThrowsFilter;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/Set;", "getClasses"})
    private static final class ThrowsFilter {
        @Nullable
        private final Set<ClassId> classes;

        public ThrowsFilter(@Nullable Set<ClassId> classes2) {
            this.classes = classes2;
        }

        @Nullable
        public final Set<ClassId> getClasses() {
            return this.classes;
        }

        @Nullable
        public final Set<ClassId> component1() {
            return this.classes;
        }

        @NotNull
        public final ThrowsFilter copy(@Nullable Set<ClassId> classes2) {
            return new ThrowsFilter(classes2);
        }

        public static /* synthetic */ ThrowsFilter copy$default(ThrowsFilter throwsFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = throwsFilter.classes;
            }
            return throwsFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "ThrowsFilter(classes=" + this.classes + ')';
        }

        public int hashCode() {
            return this.classes == null ? 0 : ((Object)this.classes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowsFilter)) {
                return false;
            }
            ThrowsFilter throwsFilter = (ThrowsFilter)other;
            return Intrinsics.areEqual(this.classes, throwsFilter.classes);
        }
    }
}

