/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0005\u001a\u0013\u0010\u0007\u001a\u00020\u0001*\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0013\u0010\n\u001a\u00020\u0001*\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "", "hasValidJsCodeBody", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "isValidJsCodeBody", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;)Z", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isJsCodeCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z"})
public final class FirWasmJsCodeHelpersKt {
    public static final boolean hasValidJsCodeBody(@NotNull FirSimpleFunction $this$hasValidJsCodeBody) {
        Intrinsics.checkNotNullParameter($this$hasValidJsCodeBody, "<this>");
        FirBlock firBlock = $this$hasValidJsCodeBody.getBody();
        return firBlock != null ? FirWasmJsCodeHelpersKt.isValidJsCodeBody(firBlock) : false;
    }

    public static final boolean hasValidJsCodeBody(@NotNull FirProperty $this$hasValidJsCodeBody) {
        Intrinsics.checkNotNullParameter($this$hasValidJsCodeBody, "<this>");
        FirExpression firExpression = $this$hasValidJsCodeBody.getInitializer();
        return firExpression != null ? FirWasmJsCodeHelpersKt.isJsCodeCall(firExpression) : false;
    }

    private static final boolean isValidJsCodeBody(FirBlock $this$isValidJsCodeBody) {
        FirStatement firStatement = CollectionsKt.singleOrNull($this$isValidJsCodeBody.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement singleStatement = firStatement;
        return singleStatement instanceof FirFunctionCall ? FirWasmJsCodeHelpersKt.isJsCodeCall((FirExpression)singleStatement) : (singleStatement instanceof FirReturnExpression && $this$isValidJsCodeBody instanceof FirSingleExpressionBlock ? FirWasmJsCodeHelpersKt.isJsCodeCall(((FirReturnExpression)singleStatement).getResult()) : false);
    }

    private static final boolean isJsCodeCall(FirExpression $this$isJsCodeCall) {
        if (!($this$isJsCodeCall instanceof FirFunctionCall)) {
            return false;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirFunctionCall)$this$isJsCodeCall).getCalleeReference(), false, 1, null);
        if (firCallableSymbol == null) {
            return false;
        }
        FirCallableSymbol symbol = firCallableSymbol;
        return Intrinsics.areEqual(symbol.getCallableId(), WebCommonStandardClassIds.Callables.Js);
    }
}

