/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.name.WebCommonStandardClassIds;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001d\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "isJsExportedDeclaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/FirSession;)Z"})
public final class FirWasmJsExportHelpersKt {
    public static final boolean isJsExportedDeclaration(@NotNull FirDeclaration declaration, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(session, "session");
        if (!(declaration instanceof FirSimpleFunction)) {
            return false;
        }
        FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$getVisibility = false;
        if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Public.INSTANCE)) {
            return false;
        }
        if (FirAnnotationUtilsKt.hasAnnotation(declaration, WebCommonStandardClassIds.Annotations.JsExport, session)) {
            return true;
        }
        FirFile containerFile = FirProviderKt.getFirProvider(session).getFirCallableContainerFile(((FirSimpleFunction)declaration).getSymbol());
        return containerFile != null && FirAnnotationUtilsKt.hasAnnotation(containerFile, WebCommonStandardClassIds.Annotations.JsExport, session);
    }
}

