/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.FirAbstractWebCheckerUtils;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/FirWasmWebCheckerUtils;", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/FirAbstractWebCheckerUtils;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "symbol", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "isNativeOrExternalInterface", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/FirSession;)Z"})
public final class FirWasmWebCheckerUtils
extends FirAbstractWebCheckerUtils {
    @NotNull
    public static final FirWasmWebCheckerUtils INSTANCE = new FirWasmWebCheckerUtils();

    private FirWasmWebCheckerUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNativeOrExternalInterface(@NotNull FirBasedSymbol<?> symbol, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(session, "session");
        if (!FirWebCommonHelpersKt.isEffectivelyExternal(symbol, session)) return false;
        if (!(symbol instanceof FirClassSymbol)) return false;
        FirClassSymbol firClassSymbol = (FirClassSymbol)symbol;
        if (firClassSymbol == null) return false;
        FirClassSymbol $this$isInterface$iv = firClassSymbol;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        if ($this$isInterface$iv$iv != ClassKind.INTERFACE) return false;
        return true;
    }
}

