/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmSignatureSerializer;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.java.JavaUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.serialization.FirAdditionalMetadataProvider;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.fir.serialization.FirSerializerExtension;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRawType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmFlags;
import org.jetbrains.kotlin.metadata.serialization.MutableVersionRequirementTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u0089\u00012\u00020\u0001:\u0002\u0089\u0001B\u0089\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\f\u0012\u0006\u0010\u0013\u001a\u00020\f\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0017\u001a\u00020\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\fH\u0016\u00a2\u0006\u0004\b \u0010!J/\u0010+\u001a\u00020*2\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$2\u0006\u0010'\u001a\u00020&2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b+\u0010,J/\u0010/\u001a\u00020*2\u0006\u0010.\u001a\u00020-2\u0006\u0010%\u001a\u00020$2\u0006\u0010'\u001a\u00020&2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b/\u00100J'\u00102\u001a\u00020*2\u0006\u0010#\u001a\u00020\"2\u0006\u00101\u001a\u00020$2\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b2\u00103J1\u00107\u001a\u00020*2\u0006\u00105\u001a\u0002042\u0006\u0010%\u001a\u0002062\b\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b7\u00108J'\u0010>\u001a\u00020*2\u0006\u0010:\u001a\u0002092\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020;H\u0016\u00a2\u0006\u0004\b>\u0010?J%\u0010B\u001a\u00020*2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020@0\u00062\u0006\u0010%\u001a\u00020;H\u0016\u00a2\u0006\u0004\bB\u0010CJ\u001f\u0010G\u001a\u00020*2\u0006\u0010E\u001a\u00020D2\u0006\u0010%\u001a\u00020FH\u0016\u00a2\u0006\u0004\bG\u0010HJ'\u0010L\u001a\u00020*2\u0006\u0010J\u001a\u00020I2\u0006\u0010%\u001a\u00020K2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\bL\u0010MJ1\u0010Q\u001a\u00020*2\u0006\u0010O\u001a\u00020N2\u0006\u0010%\u001a\u00020P2\b\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\bQ\u0010RJ'\u0010V\u001a\u00020**\u00020&2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u00020*0SH\u0002\u00a2\u0006\u0004\bV\u0010WJ\u0013\u0010X\u001a\u00020\f*\u00020NH\u0002\u00a2\u0006\u0004\bX\u0010YJ1\u0010\\\u001a\u00020*2\u0006\u0010Z\u001a\u00020\u00072\u0006\u0010%\u001a\u00020[2\b\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b\\\u0010]J\u0013\u0010^\u001a\u00020\f*\u00020\u0007H\u0002\u00a2\u0006\u0004\b^\u0010_J\u001d\u0010a\u001a\b\u0012\u0004\u0012\u00020`0\u00062\u0006\u0010#\u001a\u00020\"H\u0017\u00a2\u0006\u0004\ba\u0010bJ\u001f\u0010d\u001a\u00020*2\u0006\u0010:\u001a\u00020c2\u0006\u00101\u001a\u00020;H\u0016\u00a2\u0006\u0004\bd\u0010eJA\u0010l\u001a\u0004\u0018\u00018\u0001\"\b\b\u0000\u0010g*\u00020f\"\b\b\u0001\u0010h*\u00020f2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010i2\u0006\u0010k\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\bl\u0010mR\u001a\u0010\u0003\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010n\u001a\u0004\bo\u0010pR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010qR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010rR\u001a\u0010\n\u001a\u00020\t8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\n\u0010s\u001a\u0004\bt\u0010uR\u0014\u0010\u000b\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010qR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010vR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010wR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010xR\u0014\u0010\u0012\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010vR\u0014\u0010\u0013\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010vR\u001a\u0010\u0015\u001a\u00020\u00148\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010y\u001a\u0004\bz\u0010{R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010|R\u001a\u0010\u0019\u001a\u00020\u00188\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010}\u001a\u0004\b~\u0010\u007fR\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0017X\u0097\u0004\u00a2\u0006\u000f\n\u0005\b\u001b\u0010\u0080\u0001\u001a\u0006\b\u0081\u0001\u0010\u0082\u0001R\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u001c8\u0017X\u0097\u0004\u00a2\u0006\u000f\n\u0005\b\u001d\u0010\u0083\u0001\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R\u0018\u0010\u0087\u0001\u001a\u00030\u0086\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0006\b\u0087\u0001\u0010\u0088\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSerializerExtension;", "Lorg/jetbrains/kotlin/fir/serialization/FirSerializerExtension;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;", "bindings", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "localDelegatedProperties", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "globalBindings", "", "useTypeTable", "", "moduleName", "Lorg/jetbrains/kotlin/codegen/ClassBuilderMode;", "classBuilderMode", "isParamAssertionsDisabled", "unifiedNullChecks", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "metadataVersion", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "jvmDefaultMode", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "stringTable", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "additionalMetadataProvider", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;ZLjava/lang/String;Lorg/jetbrains/kotlin/codegen/ClassBuilderMode;ZZLorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/config/JvmDefaultMode;Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;)V", "shouldUseTypeTable", "()Z", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "klass", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;", "proto", "Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;", "versionRequirementTable", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "childSerializer", "", "serializeClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "script", "serializeScript", "(Lorg/jetbrains/kotlin/fir/declarations/FirScript;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;)V", "builder", "writeVersionRequirementForJvmDefaultIfNeeded", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;)V", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package$Builder;", "serializePackage", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package$Builder;Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;)V", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "type", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "lowerProto", "upperProto", "serializeFlexibleType", "(Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "annotations", "serializeTypeAnnotations", "(Ljava/util/List;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "typeParameter", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Builder;", "serializeTypeParameter", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Builder;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor$Builder;", "serializeConstructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor$Builder;Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "function", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "serializeFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;)V", "Lkotlin/Function1;", "", "add", "writeInlineParameterNullCheckRequirement", "(Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;Lkotlin/jvm/functions/Function1;)V", "needsInlineParameterNullCheckRequirement", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)Z", "property", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;", "serializeProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;)V", "isJvmFieldPropertyInInterfaceCompanion", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getClassSupertypes", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/types/ConeErrorType;", "serializeErrorType", "(Lorg/jetbrains/kotlin/fir/types/ConeErrorType;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;)V", "", "K", "V", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;", "slice", "key", "getBinding", "(Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;Ljava/lang/Object;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;", "Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "Z", "Ljava/lang/String;", "Lorg/jetbrains/kotlin/codegen/ClassBuilderMode;", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "getStringTable", "()Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "getConstValueProvider", "()Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "getAdditionalMetadataProvider", "()Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSignatureSerializer;", "signatureSerializer", "Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSignatureSerializer;", "Companion"})
public class FirJvmSerializerExtension
extends FirSerializerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final JvmSerializationBindings bindings;
    @NotNull
    private final List<FirProperty> localDelegatedProperties;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final JvmSerializationBindings globalBindings;
    private final boolean useTypeTable;
    @NotNull
    private final String moduleName;
    @NotNull
    private final ClassBuilderMode classBuilderMode;
    private final boolean isParamAssertionsDisabled;
    private final boolean unifiedNullChecks;
    @NotNull
    private final BinaryVersion metadataVersion;
    @NotNull
    private final JvmDefaultMode jvmDefaultMode;
    @NotNull
    private final FirElementAwareStringTable stringTable;
    @Nullable
    private final ConstValueProvider constValueProvider;
    @Nullable
    private final FirAdditionalMetadataProvider additionalMetadataProvider;
    @NotNull
    private final FirJvmSignatureSerializer signatureSerializer;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirFunction, Method> METHOD_FOR_FIR_FUNCTION;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirProperty, Pair<Type, String>> FIELD_FOR_PROPERTY;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> SYNTHETIC_METHOD_FOR_FIR_VARIABLE;
    @NotNull
    public static final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> DELEGATE_METHOD_FOR_FIR_VARIABLE;
    @NotNull
    private static final FqName JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME;
    @NotNull
    private static final FqName JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME;
    @NotNull
    private static final ClassId JVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID;
    @NotNull
    private static final ClassId JVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID;

    public FirJvmSerializerExtension(@NotNull FirSession session, @NotNull JvmSerializationBindings bindings, @NotNull List<? extends FirProperty> localDelegatedProperties, @NotNull ScopeSession scopeSession, @NotNull JvmSerializationBindings globalBindings, boolean useTypeTable, @NotNull String moduleName, @NotNull ClassBuilderMode classBuilderMode, boolean isParamAssertionsDisabled, boolean unifiedNullChecks, @NotNull BinaryVersion metadataVersion, @NotNull JvmDefaultMode jvmDefaultMode, @NotNull FirElementAwareStringTable stringTable, @Nullable ConstValueProvider constValueProvider, @Nullable FirAdditionalMetadataProvider additionalMetadataProvider) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(bindings, "bindings");
        Intrinsics.checkNotNullParameter(localDelegatedProperties, "localDelegatedProperties");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(globalBindings, "globalBindings");
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Intrinsics.checkNotNullParameter(classBuilderMode, "classBuilderMode");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        Intrinsics.checkNotNullParameter((Object)jvmDefaultMode, "jvmDefaultMode");
        Intrinsics.checkNotNullParameter(stringTable, "stringTable");
        this.session = session;
        this.bindings = bindings;
        this.localDelegatedProperties = localDelegatedProperties;
        this.scopeSession = scopeSession;
        this.globalBindings = globalBindings;
        this.useTypeTable = useTypeTable;
        this.moduleName = moduleName;
        this.classBuilderMode = classBuilderMode;
        this.isParamAssertionsDisabled = isParamAssertionsDisabled;
        this.unifiedNullChecks = unifiedNullChecks;
        this.metadataVersion = metadataVersion;
        this.jvmDefaultMode = jvmDefaultMode;
        this.stringTable = stringTable;
        this.constValueProvider = constValueProvider;
        this.additionalMetadataProvider = additionalMetadataProvider;
        this.signatureSerializer = new FirJvmSignatureSerializer(this.stringTable);
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @Override
    @NotNull
    public BinaryVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    @NotNull
    public final FirElementAwareStringTable getStringTable() {
        return this.stringTable;
    }

    @Override
    @Nullable
    public ConstValueProvider getConstValueProvider() {
        return this.constValueProvider;
    }

    @Override
    @Nullable
    public FirAdditionalMetadataProvider getAdditionalMetadataProvider() {
        return this.additionalMetadataProvider;
    }

    @Override
    public boolean shouldUseTypeTable() {
        return this.useTypeTable;
    }

    @Override
    public void serializeClass(@NotNull FirClass klass, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        if (!Intrinsics.areEqual(this.moduleName, "main")) {
            proto.setExtension(JvmProtoBuf.classModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
        for (FirProperty localVariable : this.localDelegatedProperties) {
            ProtoBuf.PropertyOrBuilder propertyOrBuilder = childSerializer.propertyProto(localVariable);
            if (propertyOrBuilder == null || (propertyOrBuilder = propertyOrBuilder.build()) == null) continue;
            proto.addExtension(JvmProtoBuf.classLocalVariable, propertyOrBuilder);
        }
        this.writeVersionRequirementForJvmDefaultIfNeeded(klass, proto, versionRequirementTable);
        if (this.jvmDefaultMode.isEnabled() && klass instanceof FirRegularClass && ((FirRegularClass)klass).getClassKind() == ClassKind.INTERFACE) {
            proto.setExtension(JvmProtoBuf.jvmClassFlags, JvmFlags.INSTANCE.getClassFlags(true, JvmDefaultMode.ALL_COMPATIBILITY == this.jvmDefaultMode && !FirAnnotationUtilsKt.hasAnnotation(klass, JVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID, this.getSession()) || JvmDefaultMode.ALL == this.jvmDefaultMode && FirAnnotationUtilsKt.hasAnnotation(klass, JVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID, this.getSession())));
        }
    }

    @Override
    public void serializeScript(@NotNull FirScript script, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(script, "script");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        if (!Intrinsics.areEqual(this.moduleName, "main")) {
            proto.setExtension(JvmProtoBuf.classModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
        for (FirProperty localVariable : this.localDelegatedProperties) {
            ProtoBuf.PropertyOrBuilder propertyOrBuilder = childSerializer.propertyProto(localVariable);
            if (propertyOrBuilder == null || (propertyOrBuilder = propertyOrBuilder.build()) == null) continue;
            proto.addExtension(JvmProtoBuf.classLocalVariable, propertyOrBuilder);
        }
    }

    private final void writeVersionRequirementForJvmDefaultIfNeeded(FirClass klass, ProtoBuf.Class.Builder builder2, MutableVersionRequirementTable versionRequirementTable) {
        if (klass instanceof FirRegularClass && ((FirRegularClass)klass).getClassKind() == ClassKind.INTERFACE && this.jvmDefaultMode == JvmDefaultMode.ALL) {
            builder2.addVersionRequirement(DescriptorSerializer.Companion.writeVersionRequirement(1, 4, 0, ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION, versionRequirementTable));
        }
    }

    @Override
    public void serializePackage(@NotNull FqName packageFqName, @NotNull ProtoBuf.Package.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        if (!Intrinsics.areEqual(this.moduleName, "main")) {
            proto.setExtension(JvmProtoBuf.packageModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
        for (FirProperty localVariable : this.localDelegatedProperties) {
            ProtoBuf.PropertyOrBuilder propertyOrBuilder = childSerializer.propertyProto(localVariable);
            if (propertyOrBuilder == null || (propertyOrBuilder = propertyOrBuilder.build()) == null) continue;
            proto.addExtension(JvmProtoBuf.packageLocalVariable, propertyOrBuilder);
        }
    }

    @Override
    public void serializeFlexibleType(@NotNull ConeFlexibleType type2, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(lowerProto, "lowerProto");
        Intrinsics.checkNotNullParameter(upperProto, "upperProto");
        lowerProto.setFlexibleTypeCapabilitiesId(this.stringTable.getStringIndex("kotlin.jvm.PlatformType"));
        if (type2 instanceof ConeRawType) {
            lowerProto.setExtension(JvmProtoBuf.isRaw, true);
            upperProto.setExtension(JvmProtoBuf.isRaw, true);
        }
    }

    @Override
    public void serializeTypeAnnotations(@NotNull List<? extends FirAnnotation> annotations2, @NotNull ProtoBuf.Type.Builder proto) {
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(proto, "proto");
        for (FirAnnotation firAnnotation : annotations2) {
            proto.addExtension(JvmProtoBuf.typeAnnotation, this.getAnnotationSerializer().serializeAnnotation(firAnnotation));
        }
    }

    @Override
    public void serializeTypeParameter(@NotNull FirTypeParameter typeParameter, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        Intrinsics.checkNotNullParameter(proto, "proto");
        for (FirAnnotation annotation : FirAnnotationUtilsKt.nonSourceAnnotations(typeParameter, this.getSession())) {
            proto.addExtension(JvmProtoBuf.typeParameterAnnotation, this.getAnnotationSerializer().serializeAnnotation(annotation));
        }
    }

    @Override
    public void serializeConstructor(@NotNull FirConstructor constructor, @NotNull ProtoBuf.Constructor.Builder proto, @NotNull FirElementSerializer childSerializer) {
        JvmProtoBuf.JvmMethodSignature signature2;
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        Method method = this.getBinding(METHOD_FOR_FIR_FUNCTION, constructor);
        if (method != null && (signature2 = this.signatureSerializer.methodSignature(constructor, null, method)) != null) {
            proto.setExtension(JvmProtoBuf.constructorSignature, signature2);
        }
    }

    @Override
    public void serializeFunction(@NotNull FirFunction function2, @NotNull ProtoBuf.Function.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        block3: {
            Intrinsics.checkNotNullParameter(function2, "function");
            Intrinsics.checkNotNullParameter(proto, "proto");
            Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
            Method method = this.getBinding(METHOD_FOR_FIR_FUNCTION, function2);
            if (method != null) {
                FirSimpleFunction firSimpleFunction = function2 instanceof FirSimpleFunction ? (FirSimpleFunction)function2 : null;
                JvmProtoBuf.JvmMethodSignature signature2 = this.signatureSerializer.methodSignature(function2, firSimpleFunction != null ? firSimpleFunction.getName() : null, method);
                if (signature2 != null) {
                    proto.setExtension(JvmProtoBuf.methodSignature, signature2);
                }
            }
            if (!this.needsInlineParameterNullCheckRequirement(function2)) break block3;
            MutableVersionRequirementTable mutableVersionRequirementTable = versionRequirementTable;
            if (mutableVersionRequirementTable != null) {
                this.writeInlineParameterNullCheckRequirement(mutableVersionRequirementTable, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>((Object)proto){

                    public final void invoke(int p0) {
                        ((ProtoBuf.Function.Builder)this.receiver).addVersionRequirement(p0);
                    }
                });
            }
        }
    }

    private final void writeInlineParameterNullCheckRequirement(MutableVersionRequirementTable $this$writeInlineParameterNullCheckRequirement, Function1<? super Integer, Unit> add2) {
        if (this.unifiedNullChecks) {
            add2.invoke((Integer)DescriptorSerializer.Companion.writeVersionRequirement(1, 3, 50, ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION, $this$writeInlineParameterNullCheckRequirement));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needsInlineParameterNullCheckRequirement(FirFunction $this$needsInlineParameterNullCheckRequirement) {
        boolean bl;
        if (!($this$needsInlineParameterNullCheckRequirement instanceof FirSimpleFunction)) return false;
        FirMemberDeclaration $this$isInline$iv = $this$needsInlineParameterNullCheckRequirement;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getStatus().isInline()) return false;
        FirMemberDeclaration $this$isSuspend$iv = $this$needsInlineParameterNullCheckRequirement;
        boolean $i$f$isSuspend = false;
        if ($this$isSuspend$iv.getStatus().isSuspend()) return false;
        if (this.isParamAssertionsDisabled) return false;
        FirMemberDeclaration $this$visibility$iv = $this$needsInlineParameterNullCheckRequirement;
        boolean $i$f$getVisibility = false;
        if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) return false;
        Iterable $this$any$iv = ((FirSimpleFunction)$this$needsInlineParameterNullCheckRequirement).getValueParameters();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                FirValueParameter it = (FirValueParameter)element$iv;
                boolean bl2 = false;
                if (!FunctionalTypeUtilsKt.isSomeFunctionType(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), this.getSession())) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        FirReceiverParameter firReceiverParameter = ((FirSimpleFunction)$this$needsInlineParameterNullCheckRequirement).getReceiverParameter();
        Object object = firReceiverParameter;
        if (firReceiverParameter == null) return false;
        FirTypeRef firTypeRef = ((FirReceiverParameter)object).getTypeRef();
        object = firTypeRef;
        if (firTypeRef == null) return false;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)object);
        object = coneKotlinType;
        if (coneKotlinType == null) return false;
        if (!FunctionalTypeUtilsKt.isSomeFunctionType((ConeKotlinType)object, this.getSession())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serializeProperty(@NotNull FirProperty property, @NotNull ProtoBuf.Property.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        block7: {
            block6: {
                boolean bl;
                boolean bl2;
                Intrinsics.checkNotNullParameter(property, "property");
                Intrinsics.checkNotNullParameter(proto, "proto");
                Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
                FirPropertyAccessor getter = property.getGetter();
                FirPropertyAccessor setter = property.getSetter();
                Method getterMethod = getter == null ? null : this.getBinding(METHOD_FOR_FIR_FUNCTION, getter);
                Method setterMethod = setter == null ? null : this.getBinding(METHOD_FOR_FIR_FUNCTION, setter);
                Pair<Type, String> field = this.getBinding(FIELD_FOR_PROPERTY, property);
                Method syntheticMethod = this.getBinding(SYNTHETIC_METHOD_FOR_FIR_VARIABLE, property);
                Method delegateMethod = this.getBinding(DELEGATE_METHOD_FOR_FIR_VARIABLE, property);
                boolean bl3 = bl2 = property.getDelegate() != null || delegateMethod == null;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string2 = "non-delegated property " + UtilsKt.render(property) + " has delegate method";
                    throw new AssertionError((Object)string2);
                }
                FirJvmSignatureSerializer firJvmSignatureSerializer = this.signatureSerializer;
                Name name = property.getName();
                Pair<Type, String> pair = field;
                String string3 = pair != null ? pair.getSecond() : null;
                Pair<Type, String> pair2 = field;
                String string4 = pair2 != null && (pair2 = pair2.getFirst()) != null ? ((Type)((Object)pair2)).getDescriptor() : null;
                JvmProtoBuf.JvmMethodSignature jvmMethodSignature = syntheticMethod != null ? this.signatureSerializer.methodSignature(null, null, syntheticMethod) : null;
                JvmProtoBuf.JvmMethodSignature jvmMethodSignature2 = delegateMethod != null ? this.signatureSerializer.methodSignature(null, null, delegateMethod) : null;
                JvmProtoBuf.JvmMethodSignature jvmMethodSignature3 = getterMethod != null ? this.signatureSerializer.methodSignature(null, null, getterMethod) : null;
                JvmProtoBuf.JvmMethodSignature jvmMethodSignature4 = setterMethod != null ? this.signatureSerializer.methodSignature(null, null, setterMethod) : null;
                Pair<Type, String> pair3 = field;
                if (pair3 != null && (pair3 = pair3.getFirst()) != null && (pair3 = ((Type)((Object)pair3)).getDescriptor()) != null) {
                    void it;
                    Pair<Type, String> pair4 = pair3;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature5 = jvmMethodSignature4;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature6 = jvmMethodSignature3;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature7 = jvmMethodSignature2;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature8 = jvmMethodSignature;
                    String string5 = string4;
                    String string6 = string3;
                    Name name2 = name;
                    FirJvmSignatureSerializer firJvmSignatureSerializer2 = firJvmSignatureSerializer;
                    boolean bl5 = false;
                    boolean bl6 = this.signatureSerializer.requiresPropertySignature(property, (String)it);
                    firJvmSignatureSerializer = firJvmSignatureSerializer2;
                    name = name2;
                    string3 = string6;
                    string4 = string5;
                    jvmMethodSignature = jvmMethodSignature8;
                    jvmMethodSignature2 = jvmMethodSignature7;
                    jvmMethodSignature3 = jvmMethodSignature6;
                    jvmMethodSignature4 = jvmMethodSignature5;
                    bl = bl6;
                } else {
                    bl = false;
                }
                JvmProtoBuf.JvmPropertySignature signature2 = firJvmSignatureSerializer.propertySignature(name, string3, string4, jvmMethodSignature, jvmMethodSignature2, jvmMethodSignature3, jvmMethodSignature4, bl);
                if (signature2 != null) {
                    proto.setExtension(JvmProtoBuf.propertySignature, signature2);
                }
                if (this.isJvmFieldPropertyInInterfaceCompanion(property) && versionRequirementTable != null) {
                    proto.setExtension(JvmProtoBuf.flags, JvmFlags.INSTANCE.getPropertyFlags(true));
                }
                FirPropertyAccessor firPropertyAccessor = getter;
                if (firPropertyAccessor != null ? this.needsInlineParameterNullCheckRequirement(firPropertyAccessor) : false) break block6;
                FirPropertyAccessor firPropertyAccessor2 = setter;
                boolean bl7 = firPropertyAccessor2 != null ? this.needsInlineParameterNullCheckRequirement(firPropertyAccessor2) : false;
                if (!bl7) break block7;
            }
            MutableVersionRequirementTable mutableVersionRequirementTable = versionRequirementTable;
            if (mutableVersionRequirementTable != null) {
                this.writeInlineParameterNullCheckRequirement(mutableVersionRequirementTable, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>((Object)proto){

                    public final void invoke(int p0) {
                        ((ProtoBuf.Property.Builder)this.receiver).addVersionRequirement(p0);
                    }
                });
            }
        }
    }

    private final boolean isJvmFieldPropertyInInterfaceCompanion(FirProperty $this$isJvmFieldPropertyInInterfaceCompanion) {
        FirRegularClass firRegularClass;
        FirRegularClassSymbol containerSymbol;
        block7: {
            block6: {
                if (!JavaUtilsKt.hasJvmFieldAnnotation($this$isJvmFieldPropertyInInterfaceCompanion, this.getSession())) {
                    return false;
                }
                Object object = $this$isJvmFieldPropertyInInterfaceCompanion.getDispatchReceiverType();
                FirRegularClassSymbol firRegularClassSymbol = object != null && (object = ConeTypeUtilsKt.getClassLikeLookupTagIfAny((ConeKotlinType)object)) != null ? ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, this.getSession()) : (containerSymbol = null);
                if (containerSymbol == null) break block6;
                FirClassLikeSymbol $this$isCompanion$iv = containerSymbol;
                boolean $i$f$isCompanion = false;
                if (!$this$isCompanion$iv.getRawStatus().isCompanion()) break block6;
                FirClassLikeSymbol $this$isLocal$iv = containerSymbol;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getClassId().isLocal()) break block7;
            }
            return false;
        }
        ClassId classId = containerSymbol.getClassId().getOuterClassId();
        if (classId != null) {
            ClassId it = classId;
            boolean bl = false;
            FirRegularClassSymbol firRegularClassSymbol = FirSymbolProviderKt.getRegularClassSymbolByClassId(this.getSession(), it);
            firRegularClass = firRegularClassSymbol != null ? (FirRegularClass)firRegularClassSymbol.getFir() : null;
        } else {
            firRegularClass = null;
        }
        FirRegularClass grandParent = firRegularClass;
        return grandParent != null && (grandParent.getClassKind() == ClassKind.INTERFACE || grandParent.getClassKind() == ClassKind.ANNOTATION_CLASS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirTypeRef> getClassSupertypes(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (Intrinsics.areEqual(this.classBuilderMode, ClassBuilderMode.KAPT3)) {
            List<FirImplicitBuiltinTypeRef> list;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = super.getClassSupertypes(klass);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                FirTypeRef it = (FirTypeRef)element$iv$iv;
                boolean bl = false;
                if (FirTypeUtilsKt.getConeType(it) instanceof ConeErrorType) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<FirImplicitBuiltinTypeRef> list2 = (List)destination$iv$iv;
            if (list2.isEmpty()) {
                boolean bl = false;
                list = CollectionsKt.listOf(this.getSession().getBuiltinTypes().getAnyType());
            } else {
                list = list2;
            }
            return list;
        }
        return super.getClassSupertypes(klass);
    }

    @Override
    public void serializeErrorType(@NotNull ConeErrorType type2, @NotNull ProtoBuf.Type.Builder builder2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        if (this.classBuilderMode == ClassBuilderMode.KAPT3) {
            builder2.setClassName(this.stringTable.getStringIndex("error/NonExistentClass"));
            return;
        }
        super.serializeErrorType(type2, builder2);
    }

    private final <K, V> V getBinding(JvmSerializationBindings.SerializationMappingSlice<K, V> slice, K key) {
        V v = this.bindings.get(slice, key);
        if (v == null) {
            v = this.globalBindings.get(slice, key);
        }
        return v;
    }

    static {
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice, "create(...)");
        METHOD_FOR_FIR_FUNCTION = serializationMappingSlice;
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice2 = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice2, "create(...)");
        FIELD_FOR_PROPERTY = serializationMappingSlice2;
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice3 = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice3, "create(...)");
        SYNTHETIC_METHOD_FOR_FIR_VARIABLE = serializationMappingSlice3;
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice4 = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice4, "create(...)");
        DELEGATE_METHOD_FOR_FIR_VARIABLE = serializationMappingSlice4;
        JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME = new FqName("kotlin.jvm.JvmDefaultWithoutCompatibility");
        JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME = new FqName("kotlin.jvm.JvmDefaultWithCompatibility");
        JVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID = ClassId.Companion.topLevel(JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME);
        JVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID = ClassId.Companion.topLevel(JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR2\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\nR&\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00060\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0013\u0010\nR \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\bR\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSerializerExtension$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "METHOD_FOR_FIR_FUNCTION", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;", "getMETHOD_FOR_FIR_FUNCTION", "()Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lkotlin/Pair;", "Lorg/jetbrains/org/objectweb/asm/Type;", "", "FIELD_FOR_PROPERTY", "getFIELD_FOR_PROPERTY", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "SYNTHETIC_METHOD_FOR_FIR_VARIABLE", "getSYNTHETIC_METHOD_FOR_FIR_VARIABLE", "DELEGATE_METHOD_FOR_FIR_VARIABLE", "Lorg/jetbrains/kotlin/name/FqName;", "JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "JVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME", "Lorg/jetbrains/kotlin/name/ClassId;", "JVM_DEFAULT_NO_COMPATIBILITY_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "JVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirFunction, Method> getMETHOD_FOR_FIR_FUNCTION() {
            return METHOD_FOR_FIR_FUNCTION;
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirProperty, Pair<Type, String>> getFIELD_FOR_PROPERTY() {
            return FIELD_FOR_PROPERTY;
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> getSYNTHETIC_METHOD_FOR_FIR_VARIABLE() {
            return SYNTHETIC_METHOD_FOR_FIR_VARIABLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

