/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.serialization.JvmSignatureSerializer;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ClassMapperLite;
import org.jetbrains.kotlin.name.ClassId;

public final class FirJvmSignatureSerializer
extends JvmSignatureSerializer<FirFunction, FirProperty> {
    public FirJvmSignatureSerializer(@NotNull FirElementAwareStringTable stringTable) {
        Intrinsics.checkNotNullParameter(stringTable, "stringTable");
        super(stringTable);
    }

    @Override
    protected boolean requiresFunctionSignature(@NotNull FirFunction descriptor2, @NotNull String desc) {
        FirTypeRef receiverTypeRef;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(desc, "desc");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        FirReceiverParameter firReceiverParameter = descriptor2.getReceiverParameter();
        FirTypeRef firTypeRef = receiverTypeRef = firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null;
        if (receiverTypeRef != null) {
            String string2 = this.mapTypeDefault(receiverTypeRef);
            if (string2 == null) {
                return true;
            }
            String receiverDesc = string2;
            sb.append(receiverDesc);
        }
        for (FirValueParameter valueParameter2 : descriptor2.getValueParameters()) {
            String paramDesc;
            if (this.mapTypeDefault(valueParameter2.getReturnTypeRef()) == null) {
                return true;
            }
            sb.append(paramDesc);
        }
        sb.append(")");
        FirTypeRef returnTypeRef = descriptor2.getReturnTypeRef();
        String string3 = this.mapTypeDefault(returnTypeRef);
        if (string3 == null) {
            return true;
        }
        String returnTypeDesc = string3;
        sb.append(returnTypeDesc);
        return !Intrinsics.areEqual(sb.toString(), desc);
    }

    public boolean requiresPropertySignature(@NotNull FirProperty descriptor2, @NotNull String desc) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(desc, "desc");
        return !Intrinsics.areEqual(desc, this.mapTypeDefault(descriptor2.getReturnTypeRef()));
    }

    private final String mapTypeDefault(FirTypeRef typeRef) {
        ClassId classId;
        ClassId classId2 = classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(typeRef));
        return classId2 == null ? null : ClassMapperLite.mapClass(classId2.asString());
    }
}

