/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.Check;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002 !B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JK\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0018\b\u0002\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010JK\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0018\b\u0002\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\nH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u000e8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000e8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\u00020\u000e8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015R\u001a\u0010\u001a\u001a\u00020\u000e8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0013\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u000e8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0013\u001a\u0004\b\u001f\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks;", "", "<init>", "()V", "", "message", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "requiredResolvePhase", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/FirSession;", "", "predicate", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "simple", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/fir/declarations/Check;", "full", "memberOrExtension", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "getMemberOrExtension", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "member", "getMember", "nonSuspend", "getNonSuspend", "noDefaultAndVarargs", "getNoDefaultAndVarargs", "Lorg/jetbrains/kotlin/fir/types/impl/ConeClassLikeTypeImpl;", "kPropertyType", "Lorg/jetbrains/kotlin/fir/types/impl/ConeClassLikeTypeImpl;", "isKProperty", "ValueParametersCount", "Returns"})
final class Checks {
    @NotNull
    public static final Checks INSTANCE = new Checks();
    @NotNull
    private static final Check memberOrExtension = Checks.simple$default(INSTANCE, "must be a member or an extension function", null, Checks::memberOrExtension$lambda$0, 2, null);
    @NotNull
    private static final Check member = Checks.simple$default(INSTANCE, "must be a member function", null, Checks::member$lambda$1, 2, null);
    @NotNull
    private static final Check nonSuspend = INSTANCE.simple("must not be suspend", Checks::nonSuspend$lambda$2, Checks::nonSuspend$lambda$3);
    @NotNull
    private static final Check noDefaultAndVarargs = INSTANCE.simple("should not have varargs or parameters with default values", Checks::noDefaultAndVarargs$lambda$4, Checks::noDefaultAndVarargs$lambda$6);
    @NotNull
    private static final ConeClassLikeTypeImpl kPropertyType;
    @NotNull
    private static final Check isKProperty;

    private Checks() {
    }

    @NotNull
    public final Check simple(@NotNull String message, @Nullable Function1<? super FirSimpleFunction, ? extends FirResolvePhase> requiredResolvePhase, @NotNull Function2<? super FirSimpleFunction, ? super FirSession, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return new Check(message, requiredResolvePhase, predicate){
            final /* synthetic */ String $message;
            final /* synthetic */ Function1<FirSimpleFunction, FirResolvePhase> $requiredResolvePhase;
            final /* synthetic */ Function2<FirSimpleFunction, FirSession, Boolean> $predicate;
            {
                this.$message = $message;
                this.$requiredResolvePhase = $requiredResolvePhase;
                this.$predicate = $predicate;
            }

            public String check(FirSimpleFunction function2, FirSession session, ScopeSession scopeSession) {
                Function2<FirSimpleFunction, FirSession, Boolean> function22;
                String string2;
                block0: {
                    Intrinsics.checkNotNullParameter(function2, "function");
                    Intrinsics.checkNotNullParameter(session, "session");
                    string2 = this.$message;
                    Function1<FirSimpleFunction, FirResolvePhase> function1 = this.$requiredResolvePhase;
                    function22 = this.$predicate;
                    String it = string2;
                    boolean bl = false;
                    Object object = function1;
                    if (object == null || (object = object.invoke(function2)) == null) break block0;
                    Object it2 = object;
                    boolean bl2 = false;
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(function2, it2);
                }
                return function22.invoke(function2, session) == false ? string2 : null;
            }
        };
    }

    public static /* synthetic */ Check simple$default(Checks checks2, String string2, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return checks2.simple(string2, function1, function2);
    }

    @NotNull
    public final Check full(@NotNull String message, @Nullable Function1<? super FirSimpleFunction, ? extends FirResolvePhase> requiredResolvePhase, @NotNull Function2<? super FirSession, ? super FirSimpleFunction, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return new Check(message, requiredResolvePhase, predicate){
            final /* synthetic */ String $message;
            final /* synthetic */ Function1<FirSimpleFunction, FirResolvePhase> $requiredResolvePhase;
            final /* synthetic */ Function2<FirSession, FirSimpleFunction, Boolean> $predicate;
            {
                this.$message = $message;
                this.$requiredResolvePhase = $requiredResolvePhase;
                this.$predicate = $predicate;
            }

            public String check(FirSimpleFunction function2, FirSession session, ScopeSession scopeSession) {
                Function2<FirSession, FirSimpleFunction, Boolean> function22;
                String string2;
                block0: {
                    Intrinsics.checkNotNullParameter(function2, "function");
                    Intrinsics.checkNotNullParameter(session, "session");
                    string2 = this.$message;
                    Function1<FirSimpleFunction, FirResolvePhase> function1 = this.$requiredResolvePhase;
                    function22 = this.$predicate;
                    String it = string2;
                    boolean bl = false;
                    Object object = function1;
                    if (object == null || (object = object.invoke(function2)) == null) break block0;
                    Object it2 = object;
                    boolean bl2 = false;
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(function2, it2);
                }
                return function22.invoke(session, function2) == false ? string2 : null;
            }
        };
    }

    public static /* synthetic */ Check full$default(Checks checks2, String string2, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return checks2.full(string2, function1, function2);
    }

    @NotNull
    public final Check getMemberOrExtension() {
        return memberOrExtension;
    }

    @NotNull
    public final Check getMember() {
        return member;
    }

    @NotNull
    public final Check getNonSuspend() {
        return nonSuspend;
    }

    @NotNull
    public final Check getNoDefaultAndVarargs() {
        return noDefaultAndVarargs;
    }

    @NotNull
    public final Check isKProperty() {
        return isKProperty;
    }

    private static final boolean memberOrExtension$lambda$0(FirSimpleFunction it, FirSession firSession) {
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNullParameter(firSession, "<unused var>");
        return it.getDispatchReceiverType() != null || it.getReceiverParameter() != null;
    }

    private static final boolean member$lambda$1(FirSimpleFunction it, FirSession firSession) {
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNullParameter(firSession, "<unused var>");
        return it.getDispatchReceiverType() != null;
    }

    private static final FirResolvePhase nonSuspend$lambda$2(FirSimpleFunction firSimpleFunction) {
        Intrinsics.checkNotNullParameter(firSimpleFunction, "<unused var>");
        return FirResolvePhase.STATUS;
    }

    private static final boolean nonSuspend$lambda$3(FirSimpleFunction it, FirSession firSession) {
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNullParameter(firSession, "<unused var>");
        FirMemberDeclaration $this$isSuspend$iv = it;
        boolean $i$f$isSuspend = false;
        return !$this$isSuspend$iv.getStatus().isSuspend();
    }

    private static final FirResolvePhase noDefaultAndVarargs$lambda$4(FirSimpleFunction firSimpleFunction) {
        Intrinsics.checkNotNullParameter(firSimpleFunction, "<unused var>");
        return FirResolvePhase.BODY_RESOLVE;
    }

    private static final boolean noDefaultAndVarargs$lambda$6(FirSimpleFunction it, FirSession firSession) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(it, "it");
            Intrinsics.checkNotNullParameter(firSession, "<unused var>");
            Iterable $this$all$iv = it.getValueParameters();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirValueParameter param = (FirValueParameter)element$iv;
                    boolean bl2 = false;
                    if (param.getDefaultValue() == null && !param.isVararg()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final FirResolvePhase isKProperty$lambda$7(FirSimpleFunction firSimpleFunction) {
        Intrinsics.checkNotNullParameter(firSimpleFunction, "<unused var>");
        return FirResolvePhase.TYPES;
    }

    private static final boolean isKProperty$lambda$8(FirSession session, FirSimpleFunction function2) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(function2, "function");
        Object object = CollectionsKt.getOrNull(function2.getValueParameters(), 1);
        if (object == null || (object = ((FirValueParameter)object).getReturnTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
            return false;
        }
        Object paramType = object;
        return TypeUtilsKt.isSubtypeOf(kPropertyType, (ConeKotlinType)paramType, session, true);
    }

    static {
        ConeStarProjection[] coneStarProjectionArray = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
        kPropertyType = new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(StandardClassIds.INSTANCE.getKProperty()), coneStarProjectionArray, false, null, 8, null);
        isKProperty = INSTANCE.full("second parameter must be of type KProperty<*> or its supertype", Checks::isKProperty$lambda$7, Checks::isKProperty$lambda$8);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\u00020\u000b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks$Returns;", "", "<init>", "()V", "", "message", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/FirSession;", "", "predicate", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "returnsCheck", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/fir/declarations/Check;", "boolean", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "getBoolean", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "int", "getInt", "unit", "getUnit"})
    public static final class Returns {
        @NotNull
        public static final Returns INSTANCE = new Returns();
        @NotNull
        private static final Check boolean = INSTANCE.returnsCheck("must return 'Boolean'", Returns::boolean$lambda$1);
        @NotNull
        private static final Check int = INSTANCE.returnsCheck("must return 'Int'", Returns::int$lambda$2);
        @NotNull
        private static final Check unit = INSTANCE.returnsCheck("must return 'Unit'", Returns::unit$lambda$3);

        private Returns() {
        }

        @NotNull
        public final Check returnsCheck(@NotNull String message, @NotNull Function2<? super FirSimpleFunction, ? super FirSession, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(message, "message");
            Intrinsics.checkNotNullParameter(predicate, "predicate");
            return INSTANCE.simple(message, Returns::returnsCheck$lambda$0, predicate);
        }

        @NotNull
        public final Check getBoolean() {
            return boolean;
        }

        @NotNull
        public final Check getInt() {
            return int;
        }

        @NotNull
        public final Check getUnit() {
            return unit;
        }

        private static final FirResolvePhase returnsCheck$lambda$0(FirSimpleFunction fn) {
            Intrinsics.checkNotNullParameter(fn, "fn");
            FirTypeRef firTypeRef = fn.getReturnTypeRef();
            return firTypeRef instanceof FirResolvedTypeRef ? null : (firTypeRef instanceof FirImplicitTypeRef ? FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE : FirResolvePhase.TYPES);
        }

        private static final boolean boolean$lambda$1(FirSimpleFunction it, FirSession session) {
            Intrinsics.checkNotNullParameter(it, "it");
            Intrinsics.checkNotNullParameter(session, "session");
            return ConeBuiltinTypeUtilsKt.isBoolean(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), session, null, 2, null));
        }

        private static final boolean int$lambda$2(FirSimpleFunction it, FirSession session) {
            Intrinsics.checkNotNullParameter(it, "it");
            Intrinsics.checkNotNullParameter(session, "session");
            return ConeBuiltinTypeUtilsKt.isInt(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), session, null, 2, null));
        }

        private static final boolean unit$lambda$3(FirSimpleFunction it, FirSession session) {
            Intrinsics.checkNotNullParameter(it, "it");
            Intrinsics.checkNotNullParameter(session, "session");
            return ConeBuiltinTypeUtilsKt.isUnit(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), session, null, 2, null));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\bR\u001a\u0010\n\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\u000f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks$ValueParametersCount;", "", "<init>", "()V", "", "n", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "atLeast", "(I)Lorg/jetbrains/kotlin/fir/declarations/Check;", "exactly", "single", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "getSingle", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "none", "getNone"})
    public static final class ValueParametersCount {
        @NotNull
        public static final ValueParametersCount INSTANCE = new ValueParametersCount();
        @NotNull
        private static final Check single = Checks.simple$default(INSTANCE, "must have a single value parameter", null, ValueParametersCount::single$lambda$2, 2, null);
        @NotNull
        private static final Check none = Checks.simple$default(INSTANCE, "must have no value parameters", null, ValueParametersCount::none$lambda$3, 2, null);

        private ValueParametersCount() {
        }

        @NotNull
        public final Check atLeast(int n) {
            return Checks.simple$default(INSTANCE, "must have at least " + n + " value parameter" + (n > 1 ? "s" : ""), null, (arg_0, arg_1) -> ValueParametersCount.atLeast$lambda$0(n, arg_0, arg_1), 2, null);
        }

        @NotNull
        public final Check exactly(int n) {
            return Checks.simple$default(INSTANCE, "must have exactly " + n + " value parameters", null, (arg_0, arg_1) -> ValueParametersCount.exactly$lambda$1(n, arg_0, arg_1), 2, null);
        }

        @NotNull
        public final Check getSingle() {
            return single;
        }

        @NotNull
        public final Check getNone() {
            return none;
        }

        private static final boolean atLeast$lambda$0(int $n, FirSimpleFunction it, FirSession firSession) {
            Intrinsics.checkNotNullParameter(it, "it");
            Intrinsics.checkNotNullParameter(firSession, "<unused var>");
            return it.getValueParameters().size() >= $n;
        }

        private static final boolean exactly$lambda$1(int $n, FirSimpleFunction it, FirSession firSession) {
            Intrinsics.checkNotNullParameter(it, "it");
            Intrinsics.checkNotNullParameter(firSession, "<unused var>");
            return it.getValueParameters().size() == $n;
        }

        private static final boolean single$lambda$2(FirSimpleFunction it, FirSession firSession) {
            Intrinsics.checkNotNullParameter(it, "it");
            Intrinsics.checkNotNullParameter(firSession, "<unused var>");
            return it.getValueParameters().size() == 1;
        }

        private static final boolean none$lambda$3(FirSimpleFunction it, FirSession firSession) {
            Intrinsics.checkNotNullParameter(it, "it");
            Intrinsics.checkNotNullParameter(firSession, "<unused var>");
            return it.getValueParameters().isEmpty();
        }
    }
}

