/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.declarations.DeprecationInfoProvider;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.declarations.RequireKotlinDeprecationInfo;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.CommonDeprecationUtilsKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/RequireKotlinProvider;", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationInfoProvider;", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;", "versionRequirement", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;)V", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;", "computeDeprecationInfo", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)Lorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;"})
public final class RequireKotlinProvider
extends DeprecationInfoProvider {
    @NotNull
    private final VersionRequirement versionRequirement;

    public RequireKotlinProvider(@NotNull VersionRequirement versionRequirement) {
        Intrinsics.checkNotNullParameter(versionRequirement, "versionRequirement");
        this.versionRequirement = versionRequirement;
    }

    @Override
    @Nullable
    public FirDeprecationInfo computeDeprecationInfo(@NotNull LanguageVersionSettings languageVersionSettings) {
        RequireKotlinDeprecationInfo requireKotlinDeprecationInfo;
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        boolean condition$iv = CommonDeprecationUtilsKt.isFulfilled(this.versionRequirement, languageVersionSettings);
        boolean $i$f$runUnless = false;
        if (condition$iv) {
            requireKotlinDeprecationInfo = null;
        } else {
            DeprecationLevelValue deprecationLevelValue;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.versionRequirement.getLevel().ordinal()]) {
                case 1: {
                    deprecationLevelValue = DeprecationLevelValue.WARNING;
                    break;
                }
                case 2: {
                    deprecationLevelValue = DeprecationLevelValue.ERROR;
                    break;
                }
                case 3: {
                    deprecationLevelValue = DeprecationLevelValue.HIDDEN;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            requireKotlinDeprecationInfo = new RequireKotlinDeprecationInfo(deprecationLevelValue, this.versionRequirement);
        }
        return requireKotlinDeprecationInfo;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeprecationLevel.values().length];
            try {
                nArray[DeprecationLevel.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevel.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevel.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

