/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0003\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/SimpleFirDeprecationInfo;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "deprecationLevel", "", "propagatesToOverrides", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "annotation", "<init>", "(Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;ZLorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)V", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "getMessage", "(Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "getDeprecationLevel", "()Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "Z", "getPropagatesToOverrides", "()Z", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;"})
public final class SimpleFirDeprecationInfo
extends FirDeprecationInfo {
    @NotNull
    private final DeprecationLevelValue deprecationLevel;
    private final boolean propagatesToOverrides;
    @NotNull
    private final FirAnnotation annotation;

    public SimpleFirDeprecationInfo(@NotNull DeprecationLevelValue deprecationLevel, boolean propagatesToOverrides, @NotNull FirAnnotation annotation) {
        Intrinsics.checkNotNullParameter((Object)deprecationLevel, "deprecationLevel");
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        this.deprecationLevel = deprecationLevel;
        this.propagatesToOverrides = propagatesToOverrides;
        this.annotation = annotation;
    }

    @Override
    @NotNull
    public DeprecationLevelValue getDeprecationLevel() {
        return this.deprecationLevel;
    }

    @Override
    public boolean getPropagatesToOverrides() {
        return this.propagatesToOverrides;
    }

    @Override
    @Nullable
    public String getMessage(@NotNull FirSession session) {
        block0: {
            Intrinsics.checkNotNullParameter(session, "session");
            FirAnnotation firAnnotation = this.annotation;
            Object object = firAnnotation instanceof FirAnnotationCall ? (FirAnnotationCall)firAnnotation : null;
            if (object == null || (object = ((FirAnnotationCall)object).getContainingDeclarationSymbol()) == null) break block0;
            FirLazyDeclarationResolverKt.lazyResolveToPhase(object, FirResolvePhase.ANNOTATION_ARGUMENTS);
        }
        return FirAnnotationUtilsKt.getStringArgument(this.annotation, StandardClassIds.Annotations.ParameterNames.INSTANCE.getDeprecatedMessage(), session);
    }
}

