/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.declarations.DeprecationInfoProvider;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.declarations.FutureApiDeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/SinceKotlinProvider;", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationInfoProvider;", "Lorg/jetbrains/kotlin/config/ApiVersion;", "sinceVersion", "<init>", "(Lorg/jetbrains/kotlin/config/ApiVersion;)V", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;", "computeDeprecationInfo", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)Lorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;", "Lorg/jetbrains/kotlin/config/ApiVersion;"})
public final class SinceKotlinProvider
extends DeprecationInfoProvider {
    @NotNull
    private final ApiVersion sinceVersion;

    public SinceKotlinProvider(@NotNull ApiVersion sinceVersion) {
        Intrinsics.checkNotNullParameter(sinceVersion, "sinceVersion");
        this.sinceVersion = sinceVersion;
    }

    @Override
    @Nullable
    public FirDeprecationInfo computeDeprecationInfo(@NotNull LanguageVersionSettings languageVersionSettings) {
        FutureApiDeprecationInfo futureApiDeprecationInfo;
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        boolean condition$iv = this.sinceVersion.compareTo(languageVersionSettings.getApiVersion()) <= 0;
        boolean $i$f$runUnless = false;
        if (condition$iv) {
            futureApiDeprecationInfo = null;
        } else {
            boolean bl = false;
            futureApiDeprecationInfo = new FutureApiDeprecationInfo(DeprecationLevelValue.HIDDEN, true, this.sinceVersion);
        }
        return futureApiDeprecationInfo;
    }
}

