/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.comparators;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirValueParameterComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/Comparator;", "<init>", "()V", "a", "b", "", "compare", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)I"})
public final class FirValueParameterComparator
implements Comparator<FirValueParameter> {
    @NotNull
    public static final FirValueParameterComparator INSTANCE = new FirValueParameterComparator();

    private FirValueParameterComparator() {
    }

    @Override
    public int compare(@NotNull FirValueParameter a, @NotNull FirValueParameter b) {
        int bHasDefaultValue;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        int valueParameterNameDiff = a.getName().compareTo(b.getName());
        if (valueParameterNameDiff != 0) {
            return valueParameterNameDiff;
        }
        int valueParameterTypeDiff = FirTypeRefComparator.INSTANCE.compare(a.getReturnTypeRef(), b.getReturnTypeRef());
        if (valueParameterTypeDiff != 0) {
            return valueParameterTypeDiff;
        }
        int aHasDefaultValue = a.getDefaultValue() != null ? 1 : 0;
        int defaultValueDiff = aHasDefaultValue - (bHasDefaultValue = b.getDefaultValue() != null ? 1 : 0);
        if (defaultValueDiff != 0) {
            return defaultValueDiff;
        }
        int aIsVararg = a.isVararg() ? 1 : 0;
        int bIsVararg = b.isVararg() ? 1 : 0;
        return aIsVararg - bIsVararg;
    }
}

