/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.ConstantArgumentKind;
import org.jetbrains.kotlin.fir.expressions.FirConstCheckVisitor;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a/\u0010\n\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u001a)\u0010\r\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "", "canBeUsedForConstVal", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "expression", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "allowErrors", "calledOnCheckerStage", "canBeEvaluatedAtCompileTime", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/FirSession;ZZ)Z", "Lorg/jetbrains/kotlin/fir/expressions/ConstantArgumentKind;", "computeConstantExpressionKind", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/FirSession;Z)Lorg/jetbrains/kotlin/fir/expressions/ConstantArgumentKind;"})
public final class FirConstChecksKt {
    public static final boolean canBeUsedForConstVal(@NotNull ConeKotlinType $this$canBeUsedForConstVal) {
        Intrinsics.checkNotNullParameter($this$canBeUsedForConstVal, "<this>");
        ConeRigidType $this$canBeUsedForConstVal_u24lambda_u240 = ConeTypeUtilsKt.lowerBoundIfFlexible($this$canBeUsedForConstVal);
        boolean bl = false;
        return ConeBuiltinTypeUtilsKt.isPrimitive($this$canBeUsedForConstVal_u24lambda_u240) || ConeBuiltinTypeUtilsKt.isString($this$canBeUsedForConstVal_u24lambda_u240) || ConeBuiltinTypeUtilsKt.isUnsignedType($this$canBeUsedForConstVal_u24lambda_u240);
    }

    public static final boolean canBeEvaluatedAtCompileTime(@Nullable FirExpression expression, @NotNull FirSession session, boolean allowErrors, boolean calledOnCheckerStage) {
        Intrinsics.checkNotNullParameter(session, "session");
        ConstantArgumentKind result2 = FirConstChecksKt.computeConstantExpressionKind(expression, session, calledOnCheckerStage);
        return result2 == ConstantArgumentKind.VALID_CONST || allowErrors && result2 == ConstantArgumentKind.RESOLUTION_ERROR;
    }

    @NotNull
    public static final ConstantArgumentKind computeConstantExpressionKind(@Nullable FirExpression expression, @NotNull FirSession session, boolean calledOnCheckerStage) {
        Intrinsics.checkNotNullParameter(session, "session");
        if (expression == null) {
            return ConstantArgumentKind.RESOLUTION_ERROR;
        }
        return (ConstantArgumentKind)((Object)expression.accept(new FirConstCheckVisitor(session, calledOnCheckerStage), null));
    }
}

