/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.expressions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirDesugaredAssignmentValueReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirEnumEntryDeserializedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirErrorNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedSymbolError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u0003*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0007\u001a\u0015\u0010\b\u001a\u0004\u0018\u00010\u0003*\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001f\u0010\n\u001a\u0004\u0018\u00010\u0003*\u00020\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b\n\u0010\u0007\u001a\u001b\u0010\u0004\u001a\u00020\u0003*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0004\u0010\f\u001a\u001d\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0015\u0010\u000e\u001a\u0004\u0018\u00010\r*\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0011\u001a\u0015\u0010\u0012\u001a\u0004\u0018\u00010\r*\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001f\u0010\u0014\u001a\u0004\u0018\u00010\r*\u00020\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u000f\u001a!\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0019\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015*\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0018\u001a\u0019\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015*\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001a\"\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u0003*\u00020\u001b8G\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "toReference", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/references/FirReference;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/references/FirReference;", "toReferenceUnsafe", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/references/FirReference;", "toReferenceImpl", "Lorg/jetbrains/kotlin/fir/expressions/FirEnumEntryDeserializedAccessExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirEnumEntryDeserializedAccessExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/references/FirReference;", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "toResolvedCallableReference", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;)Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "toResolvedCallableReferenceUnsafe", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "toResolvedCallableReferenceImpl", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "toResolvedCallableSymbol", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "toResolvedCallableSymbolUnsafe", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "getCalleeReference", "(Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;)Lorg/jetbrains/kotlin/fir/references/FirReference;", "calleeReference"})
public final class ReferenceUtilsKt {
    @Nullable
    public static final FirReference toReference(@NotNull FirElement $this$toReference, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$toReference, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirElement firElement = $this$toReference;
        return firElement instanceof FirExpression ? ReferenceUtilsKt.toReferenceImpl((FirExpression)$this$toReference, session) : (firElement instanceof FirVariableAssignment ? ReferenceUtilsKt.getCalleeReference((FirVariableAssignment)$this$toReference) : (firElement instanceof FirResolvable ? ((FirResolvable)$this$toReference).getCalleeReference() : null));
    }

    @Nullable
    public static final FirReference toReference(@NotNull FirExpression $this$toReference, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$toReference, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return ReferenceUtilsKt.toReferenceImpl($this$toReference, session);
    }

    @Nullable
    public static final FirReference toReferenceUnsafe(@NotNull FirExpression $this$toReferenceUnsafe) {
        Intrinsics.checkNotNullParameter($this$toReferenceUnsafe, "<this>");
        return ReferenceUtilsKt.toReferenceImpl($this$toReferenceUnsafe, null);
    }

    private static final FirReference toReferenceImpl(FirExpression $this$toReferenceImpl, FirSession session) {
        FirReference firReference;
        FirExpression firExpression = $this$toReferenceImpl;
        if (firExpression instanceof FirEnumEntryDeserializedAccessExpression) {
            if (session == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            firReference = ReferenceUtilsKt.toReference((FirEnumEntryDeserializedAccessExpression)$this$toReferenceImpl, session);
        } else {
            firReference = firExpression instanceof FirWrappedArgumentExpression ? (FirReference)ReferenceUtilsKt.toResolvedCallableReferenceImpl(((FirWrappedArgumentExpression)$this$toReferenceImpl).getExpression(), session) : (firExpression instanceof FirSmartCastExpression ? ReferenceUtilsKt.toReferenceImpl(((FirSmartCastExpression)$this$toReferenceImpl).getOriginalExpression(), session) : (firExpression instanceof FirDesugaredAssignmentValueReferenceExpression ? ReferenceUtilsKt.toReferenceImpl(((FirDesugaredAssignmentValueReferenceExpression)$this$toReferenceImpl).getExpressionRef().getValue(), session) : (firExpression instanceof FirResolvable ? ((FirResolvable)((Object)$this$toReferenceImpl)).getCalleeReference() : null)));
        }
        return firReference;
    }

    @NotNull
    public static final FirReference toReference(@NotNull FirEnumEntryDeserializedAccessExpression $this$toReference, @NotNull FirSession session) {
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        Object v2;
        block3: {
            Intrinsics.checkNotNullParameter($this$toReference, "<this>");
            Intrinsics.checkNotNullParameter(session, "session");
            FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getResolvedType($this$toReference), session);
            if (firRegularClassSymbol == null) {
                ClassId classId = ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getResolvedType($this$toReference));
                Intrinsics.checkNotNull(classId);
                return ReferenceUtilsKt.toReference$createErrorReference(new ConeUnresolvedSymbolError(classId));
            }
            FirRegularClassSymbol enumSymbol = firRegularClassSymbol;
            Iterable $this$firstOrNull$iv = DeclarationUtilsKt.collectEnumEntries(enumSymbol);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), $this$toReference.getEnumEntryName())) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        FirEnumEntrySymbol firEnumEntrySymbol = v2;
        if (firEnumEntrySymbol == null) {
            return ReferenceUtilsKt.toReference$createErrorReference(new ConeUnresolvedNameError($this$toReference.getEnumEntryName(), null, 2, null));
        }
        FirEnumEntrySymbol enumEntrySymbol = firEnumEntrySymbol;
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder $this$toReference_u24lambda_u242 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        boolean bl = false;
        $this$toReference_u24lambda_u242.setName($this$toReference.getEnumEntryName());
        $this$toReference_u24lambda_u242.setResolvedSymbol(enumEntrySymbol);
        return firResolvedNamedReferenceBuilder.build();
    }

    @Nullable
    public static final FirReference getCalleeReference(@NotNull FirVariableAssignment $this$calleeReference) {
        Intrinsics.checkNotNullParameter($this$calleeReference, "<this>");
        return ReferenceUtilsKt.toReferenceImpl($this$calleeReference.getLValue(), null);
    }

    @Nullable
    public static final FirResolvedNamedReference toResolvedCallableReference(@NotNull FirExpression $this$toResolvedCallableReference, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableReference, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        return ReferenceUtilsKt.toResolvedCallableReferenceImpl($this$toResolvedCallableReference, session);
    }

    @Nullable
    public static final FirResolvedNamedReference toResolvedCallableReference(@NotNull FirResolvable $this$toResolvedCallableReference) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableReference, "<this>");
        return FirReferenceUtilsKt.getResolved($this$toResolvedCallableReference.getCalleeReference());
    }

    @Nullable
    public static final FirResolvedNamedReference toResolvedCallableReferenceUnsafe(@NotNull FirExpression $this$toResolvedCallableReferenceUnsafe) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableReferenceUnsafe, "<this>");
        return ReferenceUtilsKt.toResolvedCallableReferenceImpl($this$toResolvedCallableReferenceUnsafe, null);
    }

    @Nullable
    public static final FirResolvedNamedReference toResolvedCallableReferenceImpl(@NotNull FirExpression $this$toResolvedCallableReferenceImpl, @Nullable FirSession session) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableReferenceImpl, "<this>");
        FirReference firReference = ReferenceUtilsKt.toReferenceImpl($this$toResolvedCallableReferenceImpl, session);
        return firReference != null ? FirReferenceUtilsKt.getResolved(firReference) : null;
    }

    @Nullable
    public static final FirCallableSymbol<?> toResolvedCallableSymbol(@NotNull FirExpression $this$toResolvedCallableSymbol, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableSymbol, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReference($this$toResolvedCallableSymbol, session);
        FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
        return firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
    }

    @Nullable
    public static final FirCallableSymbol<?> toResolvedCallableSymbol(@NotNull FirResolvable $this$toResolvedCallableSymbol) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableSymbol, "<this>");
        FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReference($this$toResolvedCallableSymbol);
        FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
        return firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
    }

    @Nullable
    public static final FirCallableSymbol<?> toResolvedCallableSymbolUnsafe(@NotNull FirExpression $this$toResolvedCallableSymbolUnsafe) {
        Intrinsics.checkNotNullParameter($this$toResolvedCallableSymbolUnsafe, "<this>");
        FirResolvedNamedReference firResolvedNamedReference = ReferenceUtilsKt.toResolvedCallableReferenceUnsafe($this$toResolvedCallableSymbolUnsafe);
        FirBasedSymbol<?> firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
        return firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
    }

    private static final FirErrorNamedReference toReference$createErrorReference(ConeDiagnostic diagnostic) {
        FirErrorNamedReferenceBuilder firErrorNamedReferenceBuilder;
        boolean $i$f$buildErrorNamedReference = false;
        FirErrorNamedReferenceBuilder $this$toReference_u24createErrorReference_u24lambda_u240 = firErrorNamedReferenceBuilder = new FirErrorNamedReferenceBuilder();
        boolean bl = false;
        $this$toReference_u24createErrorReference_u24lambda_u240.setDiagnostic(diagnostic);
        return firErrorNamedReferenceBuilder.build();
    }
}

