/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.java.FirJavaAwareSymbolProvider;
import org.jetbrains.kotlin.fir.java.FirJavaFacade;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProviderWithoutCallables;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001/B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0004\b\f\u0010\u0010J1\u0010\u0019\u001a\u00020\u00182\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ-\u0010\u001c\u001a\u00020\u00182\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001aJ-\u0010\u001e\u001a\u00020\u00182\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001aJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b!\u0010\"R\u001a\u0010\u0006\u001a\u00020\u00058\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010#\u001a\u0004\b$\u0010%R*\u0010(\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010'0&8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u001a\u0010+\u001a\u00020*8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010."}, d2={"Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "Lorg/jetbrains/kotlin/fir/java/FirJavaAwareSymbolProvider;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/java/FirJavaFacade;", "javaFacade", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/java/FirJavaFacade;)V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getClassLikeSymbolByClassId", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "javaClass", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/load/java/structure/JavaClass;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "destination", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/name/Name;", "name", "", "getTopLevelCallableSymbolsTo", "(Ljava/util/List;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getTopLevelPropertySymbolsTo", "fqName", "", "hasPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "Lorg/jetbrains/kotlin/fir/java/FirJavaFacade;", "getJavaFacade", "()Lorg/jetbrains/kotlin/fir/java/FirJavaFacade;", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider$ClassCacheContext;", "classCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "ClassCacheContext"})
public class JavaSymbolProvider
extends FirSymbolProvider
implements FirJavaAwareSymbolProvider {
    @NotNull
    private final FirJavaFacade javaFacade;
    @NotNull
    private final FirCache<ClassId, FirRegularClassSymbol, ClassCacheContext> classCache;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    public JavaSymbolProvider(@NotNull FirSession session, @NotNull FirJavaFacade javaFacade) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(javaFacade, "javaFacade");
        super(session);
        this.javaFacade = javaFacade;
        this.classCache = FirCachesFactoryKt.getFirCachesFactory(session).createCache((arg_0, arg_1) -> JavaSymbolProvider.classCache$lambda$0(this, arg_0, arg_1));
        this.symbolNamesProvider = new FirSymbolNamesProviderWithoutCallables(this){
            final /* synthetic */ JavaSymbolProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean getHasSpecificClassifierPackageNamesComputation() {
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public Set<Name> getTopLevelClassifierNamesInPackage(FqName packageFqName) {
                Set set;
                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                Set<String> set2 = this.this$0.getJavaFacade().knownClassNamesInPackage(packageFqName);
                if (set2 != null) {
                    Collection $this$mapToSetOrEmpty$iv = set2;
                    boolean $i$f$mapToSetOrEmpty = false;
                    if (!$this$mapToSetOrEmpty$iv.isEmpty()) {
                        void destination$iv$iv;
                        void $this$mapTo$iv$iv;
                        Iterable iterable = $this$mapToSetOrEmpty$iv;
                        Collection collection = new LinkedHashSet<E>();
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string2 = (String)item$iv$iv;
                            void var11_11 = destination$iv$iv;
                            boolean bl = false;
                            var11_11.add(Name.identifier((String)it));
                        }
                        set = (Set)destination$iv$iv;
                    } else {
                        set = SetsKt.emptySet();
                    }
                } else {
                    set = null;
                }
                return set;
            }
        };
    }

    @Override
    @NotNull
    public FirJavaFacade getJavaFacade() {
        return this.javaFacade;
    }

    @Nullable
    public FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.getJavaFacade().hasTopLevelClassOf(classId) ? this.getClassLikeSymbolByClassId(classId, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId, @Nullable JavaClass javaClass) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter(classId, "classId");
        FirCache<ClassId, FirRegularClassSymbol, ClassCacheContext> firCache = this.classCache;
        ClassId classId2 = classId;
        ClassId classId3 = classId.getOuterClassId();
        if (classId3 != null) {
            void it;
            ClassId classId4 = classId3;
            ClassId classId5 = classId2;
            FirCache<ClassId, FirRegularClassSymbol, ClassCacheContext> firCache2 = firCache;
            boolean bl = false;
            FirRegularClassSymbol firRegularClassSymbol2 = this.getClassLikeSymbolByClassId((ClassId)it, null);
            firCache = firCache2;
            classId2 = classId5;
            firRegularClassSymbol = firRegularClassSymbol2;
        } else {
            firRegularClassSymbol = null;
        }
        JavaClass javaClass2 = javaClass;
        FirRegularClassSymbol firRegularClassSymbol3 = firRegularClassSymbol;
        return firCache.getValue(classId2, new ClassCacheContext(firRegularClassSymbol3, javaClass2));
    }

    @Override
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
    }

    @Override
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
    }

    @Override
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
    }

    @Override
    public boolean hasPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return this.getJavaFacade().hasPackage(fqName2);
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    private static final FirRegularClassSymbol classCache$lambda$0(JavaSymbolProvider this$0, ClassId classId, ClassCacheContext context) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Object object = context;
        if ((object == null || (object = ((ClassCacheContext)object).getFoundJavaClass()) == null) && (object = FirJavaFacade.findClass$default(this$0.getJavaFacade(), classId, null, 2, null)) == null) {
            return null;
        }
        Object javaClass = object;
        FirRegularClassSymbol symbol = new FirRegularClassSymbol(classId);
        ClassCacheContext classCacheContext = context;
        this$0.getJavaFacade().convertJavaClassToFir(symbol, classCacheContext != null ? classCacheContext.getParentClassSymbol() : null, (JavaClass)javaClass);
        return symbol;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider$ClassCacheContext;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "parentClassSymbol", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "foundJavaClass", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/load/java/structure/JavaClass;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getParentClassSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "getFoundJavaClass", "()Lorg/jetbrains/kotlin/load/java/structure/JavaClass;"})
    private static final class ClassCacheContext {
        @Nullable
        private final FirRegularClassSymbol parentClassSymbol;
        @Nullable
        private final JavaClass foundJavaClass;

        public ClassCacheContext(@Nullable FirRegularClassSymbol parentClassSymbol, @Nullable JavaClass foundJavaClass) {
            this.parentClassSymbol = parentClassSymbol;
            this.foundJavaClass = foundJavaClass;
        }

        public /* synthetic */ ClassCacheContext(FirRegularClassSymbol firRegularClassSymbol, JavaClass javaClass, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                firRegularClassSymbol = null;
            }
            if ((n & 2) != 0) {
                javaClass = null;
            }
            this(firRegularClassSymbol, javaClass);
        }

        @Nullable
        public final FirRegularClassSymbol getParentClassSymbol() {
            return this.parentClassSymbol;
        }

        @Nullable
        public final JavaClass getFoundJavaClass() {
            return this.foundJavaClass;
        }

        public ClassCacheContext() {
            this(null, null, 3, null);
        }
    }
}

