/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.deserialization;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializerKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/FirJvmConstDeserializer;", "Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "binaryClass", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "protocol", "<init>", "(Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "propertyProto", "Lorg/jetbrains/kotlin/name/CallableId;", "callableId", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "nameResolver", "", "isUnsigned", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "loadConstant", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;Lorg/jetbrains/kotlin/name/CallableId;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Z)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;"})
public final class FirJvmConstDeserializer
extends FirConstDeserializer {
    @NotNull
    private final KotlinJvmBinaryClass binaryClass;

    public FirJvmConstDeserializer(@NotNull KotlinJvmBinaryClass binaryClass, @NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkNotNullParameter(binaryClass, "binaryClass");
        Intrinsics.checkNotNullParameter(protocol, "protocol");
        super(protocol);
        this.binaryClass = binaryClass;
    }

    @Override
    @Nullable
    public FirExpression loadConstant(@NotNull ProtoBuf.Property propertyProto, @NotNull CallableId callableId, @NotNull NameResolver nameResolver, boolean isUnsigned) {
        Intrinsics.checkNotNullParameter(propertyProto, "propertyProto");
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        if (!Flags.HAS_CONSTANT.get(propertyProto.getFlags()).booleanValue()) {
            return null;
        }
        FirExpression firExpression = this.getConstantCache().get(callableId);
        if (firExpression != null) {
            FirExpression it = firExpression;
            boolean bl = false;
            return it;
        }
        this.binaryClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(nameResolver, isUnsigned, this, callableId){
            final /* synthetic */ NameResolver $nameResolver;
            final /* synthetic */ boolean $isUnsigned;
            final /* synthetic */ FirJvmConstDeserializer this$0;
            final /* synthetic */ CallableId $callableId;
            {
                this.$nameResolver = $nameResolver;
                this.$isUnsigned = $isUnsigned;
                this.this$0 = $receiver;
                this.$callableId = $callableId;
            }

            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(Name name, String desc) {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(desc, "desc");
                return null;
            }

            public KotlinJvmBinaryClass.AnnotationVisitor visitField(Name name, String desc, Object initializer) {
                block1: {
                    FirExpression constant;
                    Intrinsics.checkNotNullParameter(name, "name");
                    Intrinsics.checkNotNullParameter(desc, "desc");
                    if (initializer == null) break block1;
                    FirExpression firExpression = constant = FirConstDeserializerKt.buildFirConstant(null, initializer, desc, this.$nameResolver, this.$isUnsigned);
                    if (firExpression != null) {
                        FirExpression firExpression2 = firExpression;
                        FirJvmConstDeserializer firJvmConstDeserializer = this.this$0;
                        CallableId callableId = this.$callableId;
                        FirExpression it = firExpression2;
                        boolean bl = false;
                        FirJvmConstDeserializer.access$getConstantCache(firJvmConstDeserializer).put(FirConstDeserializerKt.replaceName(callableId, name), it);
                    }
                }
                return null;
            }
        }, null);
        return this.getConstantCache().get(callableId);
    }

    public static final /* synthetic */ Map access$getConstantCache(FirJvmConstDeserializer $this) {
        return $this.getConstantCache();
    }
}

