/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.deserialization;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltInsSignatures;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationExtension;
import org.jetbrains.kotlin.fir.java.deserialization.FirJvmConstDeserializer;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0011\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0013\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J!\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/FirJvmDeserializationExtension;", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationExtension;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "containerSource", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "serializerExtensionProtocol", "Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "createConstDeserializer", "(Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirRegularClassBuilder;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "", "configureDeserializedClass", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirRegularClassBuilder;Lorg/jetbrains/kotlin/name/ClassId;)V", "addSerializableIfNeeded", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "classProto", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "nameResolver", "", "loadModuleName", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;)Ljava/lang/String;", "Companion"})
public final class FirJvmDeserializationExtension
extends FirDeserializationExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ClassId JAVA_IO_SERIALIZABLE = ClassId.Companion.topLevel(new FqName("java.io.Serializable"));

    public FirJvmDeserializationExtension(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        super(session);
    }

    @Override
    @Nullable
    public FirConstDeserializer createConstDeserializer(@Nullable DeserializedContainerSource containerSource, @NotNull FirSession session, @NotNull SerializerExtensionProtocol serializerExtensionProtocol) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(serializerExtensionProtocol, "serializerExtensionProtocol");
        return containerSource instanceof KotlinJvmBinarySourceElement ? (FirConstDeserializer)new FirJvmConstDeserializer(((KotlinJvmBinarySourceElement)containerSource).getBinaryClass(), serializerExtensionProtocol) : null;
    }

    @Override
    public void configureDeserializedClass(@NotNull FirRegularClassBuilder $this$configureDeserializedClass, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter($this$configureDeserializedClass, "<this>");
        Intrinsics.checkNotNullParameter(classId, "classId");
        this.addSerializableIfNeeded($this$configureDeserializedClass, classId);
    }

    private final void addSerializableIfNeeded(FirRegularClassBuilder $this$addSerializableIfNeeded, ClassId classId) {
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        if (!JvmBuiltInsSignatures.INSTANCE.isSerializableInJava(classId.asSingleFqName().toUnsafe())) {
            return;
        }
        Collection collection = $this$addSerializableIfNeeded.getSuperTypeRefs();
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $this$addSerializableIfNeeded_u24lambda_u240 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        boolean bl = false;
        $this$addSerializableIfNeeded_u24lambda_u240.setConeType(new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(JAVA_IO_SERIALIZABLE), ConeTypeProjection.Companion.getEMPTY_ARRAY(), false, null, 8, null));
        FirResolvedTypeRef firResolvedTypeRef = firResolvedTypeRefBuilder.build();
        collection.add(firResolvedTypeRef);
    }

    @Override
    @Nullable
    public String loadModuleName(@NotNull ProtoBuf.Class classProto2, @NotNull NameResolver nameResolver) {
        String string2;
        Intrinsics.checkNotNullParameter(classProto2, "classProto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        GeneratedMessageLite.ExtendableMessage extendableMessage = classProto2;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Class, Integer> generatedExtension = JvmProtoBuf.classModuleName;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, "classModuleName");
        Integer n = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (n != null) {
            int p0 = ((Number)n).intValue();
            boolean bl = false;
            string2 = nameResolver.getString(p0);
        } else {
            string2 = null;
        }
        return string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/FirJvmDeserializationExtension$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/name/ClassId;", "JAVA_IO_SERIALIZABLE", "Lorg/jetbrains/kotlin/name/ClassId;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

