/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRendererForDebugInfo;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0002\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nB;\b\u0016\u0012\n\u0010\r\u001a\u00060\u000bj\u0002`\f\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0002\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\"\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010 R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010!"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForReadability;", "Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForDebugInfo;", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "", "preRenderedConstructors", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "idRendererCreator", "<init>", "(Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "builder", "(Ljava/lang/StringBuilder;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "flexibleType", "", "render", "(Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;)V", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "bound", "renderBound", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Ljava/lang/String;", "lowerRendered", "upperRendered", "renderFlexibleTypeCompact", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "constructor", "nullabilityMarker", "renderConstructor", "(Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;Ljava/lang/String;)V", "Ljava/util/Map;", "Lkotlin/jvm/functions/Function0;"})
public class ConeTypeRendererForReadability
extends ConeTypeRendererForDebugInfo {
    @Nullable
    private final Map<TypeConstructorMarker, String> preRenderedConstructors;
    @NotNull
    private final Function0<ConeIdRenderer> idRendererCreator;

    public ConeTypeRendererForReadability(@Nullable Map<TypeConstructorMarker, String> preRenderedConstructors, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter(idRendererCreator, "idRendererCreator");
        this.preRenderedConstructors = preRenderedConstructors;
        this.idRendererCreator = idRendererCreator;
    }

    public /* synthetic */ ConeTypeRendererForReadability(Map map2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = null;
        }
        this(map2, function0);
    }

    public ConeTypeRendererForReadability(@NotNull StringBuilder builder2, @Nullable Map<TypeConstructorMarker, String> preRenderedConstructors, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(idRendererCreator, "idRendererCreator");
        this(preRenderedConstructors, idRendererCreator);
        this.setBuilder(builder2);
        this.setIdRenderer(idRendererCreator.invoke());
        this.getIdRenderer().setBuilder(builder2);
    }

    public /* synthetic */ ConeTypeRendererForReadability(StringBuilder stringBuilder, Map map2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map2 = null;
        }
        this(stringBuilder, map2, function0);
    }

    @Override
    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter(flexibleType, "flexibleType");
        ConeRigidType lower = flexibleType.getLowerBound();
        String lowerRendered = this.renderBound(lower);
        String upperRendered = this.renderBound(flexibleType.getUpperBound());
        String string2 = this.renderFlexibleTypeCompact(lowerRendered, upperRendered);
        if (string2 == null) {
            ConeTypeRendererForReadability $this$render_u24lambda_u240 = this;
            boolean bl = false;
            String string3 = lower instanceof ConeDefinitelyNotNullType ? $this$render_u24lambda_u240.renderFlexibleTypeCompact($this$render_u24lambda_u240.renderBound(((ConeDefinitelyNotNullType)lower).getOriginal()), upperRendered) : null;
            string2 = string3;
            if (string3 == null) {
                string2 = '(' + lowerRendered + ".." + upperRendered + ')';
            }
        }
        String rendered = string2;
        this.getBuilder().append(rendered);
    }

    private final String renderBound(ConeKotlinType bound) {
        ConeTypeRendererForReadability renderer = new ConeTypeRendererForReadability(new StringBuilder(), this.preRenderedConstructors, this.idRendererCreator);
        ConeTypeRenderer.render$default(renderer, bound, null, 2, null);
        String string2 = renderer.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private final String renderFlexibleTypeCompact(String lowerRendered, String upperRendered) {
        String array;
        String string2;
        String mutableEntry;
        String simpleCollection;
        String string3;
        if (Intrinsics.areEqual(lowerRendered, StringsKt.replace$default(upperRendered, "?", "", false, 4, null))) {
            return StringsKt.replace$default(upperRendered, "?", "!", false, 4, null);
        }
        if (StringsKt.endsWith$default(upperRendered, "?", false, 2, null) && Intrinsics.areEqual(lowerRendered + '?', upperRendered)) {
            return lowerRendered + '!';
        }
        if (Intrinsics.areEqual('(' + lowerRendered + ")?", upperRendered)) {
            return '(' + lowerRendered + ")!";
        }
        String it = string3 = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.asString() + '.';
        boolean bl = false;
        String string4 = StringsKt.startsWith$default(lowerRendered, it, false, 2, null) ? string3 : null;
        if (string4 == null) {
            string4 = "";
        }
        String kotlinCollectionsPrefix = string4;
        String mutablePrefix = "Mutable";
        String string5 = simpleCollection = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (string5 != null) {
            return string5;
        }
        String string6 = mutableEntry = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (string6 != null) {
            return string6;
        }
        String it2 = string2 = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.asString() + '.';
        boolean bl2 = false;
        String string7 = StringsKt.startsWith$default(lowerRendered, it2, false, 2, null) ? string2 : null;
        if (string7 == null) {
            string7 = "";
        }
        String kotlinPrefix = string7;
        String string8 = array = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinPrefix + "Array<", upperRendered, kotlinPrefix + "Array<out ", kotlinPrefix + "Array<(out) ");
        if (string8 != null) {
            return string8;
        }
        return null;
    }

    @Override
    public void renderConstructor(@NotNull TypeConstructorMarker constructor, @NotNull String nullabilityMarker) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(nullabilityMarker, "nullabilityMarker");
        Map<TypeConstructorMarker, String> map2 = this.preRenderedConstructors;
        if (map2 != null && (map2 = map2.get(constructor)) != null) {
            Map<TypeConstructorMarker, String> it = map2;
            boolean bl = false;
            this.getBuilder().append(StringsKt.replace$default((String)((Object)it), "^", nullabilityMarker, false, 4, null));
            return;
        }
        super.renderConstructor(constructor, nullabilityMarker);
    }
}

