/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLazyBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.renderer.FirAnnotationRenderer;
import org.jetbrains.kotlin.fir.renderer.FirPrinter;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.renderer.FirRendererComponents;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000bJ'\u0010\u0011\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0001@\u0000X\u0080.\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010!\u001a\u0004\u0018\u00010\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010&\u001a\u00060\"R\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010*\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/FirBodyRenderer;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "function", "", "render", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "variable", "(Lorg/jetbrains/kotlin/fir/declarations/FirVariable;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "block", "", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "additionalStatements", "renderBody", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Ljava/util/List;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "delegatedConstructor", "renderDelegatedConstructor", "(Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;)V", "Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "components", "Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "getComponents$tree", "()Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "setComponents$tree", "(Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;)V", "Lorg/jetbrains/kotlin/fir/renderer/FirAnnotationRenderer;", "getAnnotationRenderer", "()Lorg/jetbrains/kotlin/fir/renderer/FirAnnotationRenderer;", "annotationRenderer", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer;", "getVisitor", "()Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;", "visitor", "Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "getPrinter", "()Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "printer"})
public final class FirBodyRenderer {
    public FirRendererComponents components;

    @NotNull
    public final FirRendererComponents getComponents$tree() {
        FirRendererComponents firRendererComponents = this.components;
        if (firRendererComponents != null) {
            return firRendererComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException("components");
        return null;
    }

    public final void setComponents$tree(@NotNull FirRendererComponents firRendererComponents) {
        Intrinsics.checkNotNullParameter(firRendererComponents, "<set-?>");
        this.components = firRendererComponents;
    }

    private final FirAnnotationRenderer getAnnotationRenderer() {
        return this.getComponents$tree().getAnnotationRenderer();
    }

    private final FirRenderer.Visitor getVisitor() {
        return this.getComponents$tree().getVisitor();
    }

    private final FirPrinter getPrinter() {
        return this.getComponents$tree().getPrinter();
    }

    public final void render(@NotNull FirFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        FirBodyRenderer.renderBody$default(this, function2.getBody(), null, 2, null);
    }

    public final void render(@NotNull FirVariable variable) {
        block1: {
            Object[] objectArray;
            FirExpression it;
            Intrinsics.checkNotNullParameter(variable, "variable");
            FirExpression firExpression = variable.getInitializer();
            if (firExpression != null) {
                it = firExpression;
                boolean bl = false;
                objectArray = new Object[]{" = "};
                this.getPrinter().print(objectArray);
                it.accept(this.getVisitor());
            }
            FirExpression firExpression2 = variable.getDelegate();
            if (firExpression2 == null) break block1;
            it = firExpression2;
            boolean bl = false;
            objectArray = new Object[]{"by "};
            this.getPrinter().print(objectArray);
            it.accept(this.getVisitor());
        }
    }

    public final void renderBody(@Nullable FirBlock block, @NotNull List<? extends FirStatement> additionalStatements) {
        Intrinsics.checkNotNullParameter(additionalStatements, "additionalStatements");
        if (block == null) {
            return;
        }
        if (block instanceof FirLazyBlock) {
            Object[] objectArray = new Object[]{" { LAZY_BLOCK }"};
            this.getPrinter().println(objectArray);
        } else {
            FirAnnotationRenderer firAnnotationRenderer = this.getAnnotationRenderer();
            if (firAnnotationRenderer != null) {
                FirAnnotationRenderer.render$default(firAnnotationRenderer, block, null, 2, null);
            }
            FirPrinter.renderInBraces$default(this.getPrinter(), null, null, () -> FirBodyRenderer.renderBody$lambda$2(additionalStatements, block, this), 3, null);
        }
    }

    public static /* synthetic */ void renderBody$default(FirBodyRenderer firBodyRenderer, FirBlock firBlock, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        firBodyRenderer.renderBody(firBlock, list);
    }

    public final void renderDelegatedConstructor(@Nullable FirDelegatedConstructorCall delegatedConstructor) {
        if (delegatedConstructor != null) {
            FirPrinter.renderInBraces$default(this.getPrinter(), null, null, () -> FirBodyRenderer.renderDelegatedConstructor$lambda$3(delegatedConstructor, this), 3, null);
        } else {
            this.getPrinter().println(new Object[0]);
        }
    }

    private static final Unit renderBody$lambda$2(List $additionalStatements, FirBlock $block, FirBodyRenderer this$0) {
        for (FirStatement statement : CollectionsKt.plus((Collection)$additionalStatements, (Iterable)$block.getStatements())) {
            statement.accept(this$0.getVisitor());
            this$0.getPrinter().println(new Object[0]);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderDelegatedConstructor$lambda$3(FirDelegatedConstructorCall $delegatedConstructor, FirBodyRenderer this$0) {
        $delegatedConstructor.accept(this$0.getVisitor());
        this$0.getPrinter().println(new Object[0]);
        return Unit.INSTANCE;
    }
}

