/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRenderer;
import org.jetbrains.kotlin.fir.renderer.FirPrinter;
import org.jetbrains.kotlin.fir.renderer.FirRendererComponents;
import org.jetbrains.kotlin.fir.renderer.FirResolvePhaseRenderer;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0013\u0010\r\u001a\u00020\b*\u00020\u0006H\u0014\u00a2\u0006\u0004\b\r\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000eR\"\u0010\u0010\u001a\u00020\u000f8\u0001@\u0000X\u0081.\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u00168EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 "}, d2={"Lorg/jetbrains/kotlin/fir/renderer/FirDeclarationRenderer;", "", "", "localVariablePrefix", "<init>", "(Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "", "render", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "renderPhaseAndAttributes$tree", "renderPhaseAndAttributes", "renderDeclarationAttributes", "Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "components", "Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "getComponents$tree", "()Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "setComponents$tree", "(Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;)V", "Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "getPrinter", "()Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "printer", "Lorg/jetbrains/kotlin/fir/renderer/FirResolvePhaseRenderer;", "getResolvePhaseRenderer", "()Lorg/jetbrains/kotlin/fir/renderer/FirResolvePhaseRenderer;", "resolvePhaseRenderer", "Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "getTypeRenderer", "()Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "typeRenderer"})
public class FirDeclarationRenderer {
    @NotNull
    private final String localVariablePrefix;
    public FirRendererComponents components;

    public FirDeclarationRenderer(@NotNull String localVariablePrefix) {
        Intrinsics.checkNotNullParameter(localVariablePrefix, "localVariablePrefix");
        this.localVariablePrefix = localVariablePrefix;
    }

    public /* synthetic */ FirDeclarationRenderer(String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "l";
        }
        this(string2);
    }

    @NotNull
    public final FirRendererComponents getComponents$tree() {
        FirRendererComponents firRendererComponents = this.components;
        if (firRendererComponents != null) {
            return firRendererComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException("components");
        return null;
    }

    public final void setComponents$tree(@NotNull FirRendererComponents firRendererComponents) {
        Intrinsics.checkNotNullParameter(firRendererComponents, "<set-?>");
        this.components = firRendererComponents;
    }

    @NotNull
    protected final FirPrinter getPrinter() {
        return this.getComponents$tree().getPrinter();
    }

    private final FirResolvePhaseRenderer getResolvePhaseRenderer() {
        return this.getComponents$tree().getResolvePhaseRenderer();
    }

    private final ConeTypeRenderer getTypeRenderer() {
        return this.getComponents$tree().getTypeRenderer();
    }

    /*
     * WARNING - void declaration
     */
    public final void render(@NotNull FirDeclaration declaration) {
        String string2;
        Object[] objectArray;
        FirPrinter firPrinter;
        block14: {
            FirDeclaration firDeclaration;
            block16: {
                Object object;
                StringBuilder stringBuilder;
                block18: {
                    block17: {
                        void it;
                        int n;
                        Object[] objectArray2;
                        block15: {
                            block13: {
                                Intrinsics.checkNotNullParameter(declaration, "declaration");
                                this.renderPhaseAndAttributes$tree(declaration);
                                if (declaration instanceof FirConstructor) {
                                    Object[] objectArray3;
                                    ConeSimpleKotlinType coneSimpleKotlinType = ((FirConstructor)declaration).getDispatchReceiverType();
                                    if (coneSimpleKotlinType != null) {
                                        ConeSimpleKotlinType it2 = coneSimpleKotlinType;
                                        boolean bl = false;
                                        ConeTypeRenderer.render$default(this.getTypeRenderer(), it2, null, 2, null);
                                        Object[] objectArray4 = new Object[]{"."};
                                        this.getPrinter().print(objectArray4);
                                    }
                                    if (declaration instanceof FirErrorPrimaryConstructor) {
                                        objectArray3 = new Object[]{"error_"};
                                        this.getPrinter().print(objectArray3);
                                    }
                                    objectArray3 = new Object[]{"constructor"};
                                    this.getPrinter().print(objectArray3);
                                    return;
                                }
                                firPrinter = this.getPrinter();
                                objectArray2 = objectArray = new Object[1];
                                n = 0;
                                firDeclaration = declaration;
                                if (!(firDeclaration instanceof FirRegularClass)) break block13;
                                string2 = StringsKt.replace$default(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(((FirRegularClass)declaration).getClassKind().name()), "_", " ", false, 4, null);
                                break block14;
                            }
                            if (!(firDeclaration instanceof FirTypeAlias)) break block15;
                            string2 = "typealias";
                            break block14;
                        }
                        if (!(firDeclaration instanceof FirAnonymousFunction)) break block16;
                        stringBuilder = new StringBuilder();
                        object = ((FirAnonymousFunction)declaration).getLabel();
                        if (object == null) break block17;
                        FirLabel firLabel = object;
                        StringBuilder stringBuilder2 = stringBuilder;
                        int n2 = n;
                        Object[] objectArray5 = objectArray2;
                        FirPrinter firPrinter2 = firPrinter;
                        boolean bl = false;
                        String string3 = it.getName() + '@';
                        firPrinter = firPrinter2;
                        objectArray2 = objectArray5;
                        n = n2;
                        stringBuilder = stringBuilder2;
                        String string4 = string3;
                        object = string4;
                        if (string4 != null) break block18;
                    }
                    object = "";
                }
                string2 = stringBuilder.append((String)object).append("fun").toString();
                break block14;
            }
            if (firDeclaration instanceof FirSimpleFunction) {
                string2 = "fun";
            } else if (firDeclaration instanceof FirProperty) {
                if (Intrinsics.areEqual(ClassMembersKt.isCatchParameter((FirProperty)declaration), true)) {
                    string2 = "";
                } else {
                    String prefix = ((FirProperty)declaration).isLocal() ? this.localVariablePrefix : "";
                    string2 = prefix + (((FirProperty)declaration).isVal() ? "val" : "var");
                }
            } else {
                string2 = firDeclaration instanceof FirPropertyAccessor ? (((FirPropertyAccessor)declaration).isGetter() ? "get" : "set") : (firDeclaration instanceof FirField ? "field" : (firDeclaration instanceof FirEnumEntry ? "enum entry" : (firDeclaration instanceof FirBackingField ? "backing field" : "unknown")));
            }
        }
        objectArray2[n] = string2;
        firPrinter.print(objectArray);
    }

    public final void renderPhaseAndAttributes$tree(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirResolvePhaseRenderer firResolvePhaseRenderer = this.getResolvePhaseRenderer();
        if (firResolvePhaseRenderer != null) {
            firResolvePhaseRenderer.render(declaration);
        }
        FirDeclaration $this$renderPhaseAndAttributes_u24lambda_u242 = declaration;
        boolean bl = false;
        this.renderDeclarationAttributes($this$renderPhaseAndAttributes_u24lambda_u242);
    }

    protected void renderDeclarationAttributes(@NotNull FirDeclaration $this$renderDeclarationAttributes) {
        Intrinsics.checkNotNullParameter($this$renderDeclarationAttributes, "<this>");
    }

    public FirDeclarationRenderer() {
        this(null, 1, null);
    }
}

