/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.renderer.FirPrinter;
import org.jetbrains.kotlin.fir.renderer.FirRendererComponents;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 42\u00020\u0001:\u00014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH&\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH&\u00a2\u0006\u0004\b\u0007\u0010\u000eJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000fH&\u00a2\u0006\u0004\b\u0007\u0010\u0011J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012H&\u00a2\u0006\u0004\b\u0007\u0010\u0014J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0017J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u001aJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u0007\u0010\u001dJ\u0019\u0010 \u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0014\u00a2\u0006\u0004\b \u0010!J\u001f\u0010%\u001a\u00020\u001e*\u00020\"2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010#H\u0015\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010'\u001a\u0004\u0018\u00010\u001e*\u00020\u0004H\u0015\u00a2\u0006\u0004\b'\u0010(R\"\u0010*\u001a\u00020)8\u0001@\u0000X\u0080.\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0014\u00103\u001a\u0002008EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/FirModifierRenderer;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "memberDeclaration", "", "renderModifiers", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;", "backingField", "(Lorg/jetbrains/kotlin/fir/declarations/FirBackingField;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "propertyAccessor", "(Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "anonymousFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "valueParameter", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "typeParameter", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;)V", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "functionTypeRef", "(Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;)V", "", "modifier", "renderModifier", "(Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "effectiveVisibility", "asString", "(Lorg/jetbrains/kotlin/descriptors/Visibility;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)Ljava/lang/String;", "modalityAsString", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "components", "Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "getComponents$tree", "()Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;", "setComponents$tree", "(Lorg/jetbrains/kotlin/fir/renderer/FirRendererComponents;)V", "Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "getPrinter", "()Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "printer", "Companion"})
public abstract class FirModifierRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public FirRendererComponents components;
    @NotNull
    private static final Set<Visibility> visibilitiesToRenderEffectiveSet;

    @NotNull
    public final FirRendererComponents getComponents$tree() {
        FirRendererComponents firRendererComponents = this.components;
        if (firRendererComponents != null) {
            return firRendererComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException("components");
        return null;
    }

    public final void setComponents$tree(@NotNull FirRendererComponents firRendererComponents) {
        Intrinsics.checkNotNullParameter(firRendererComponents, "<set-?>");
        this.components = firRendererComponents;
    }

    @NotNull
    protected final FirPrinter getPrinter() {
        return this.getComponents$tree().getPrinter();
    }

    public abstract void renderModifiers(@NotNull FirMemberDeclaration var1);

    public abstract void renderModifiers(@NotNull FirBackingField var1);

    public abstract void renderModifiers(@NotNull FirConstructor var1);

    public abstract void renderModifiers(@NotNull FirPropertyAccessor var1);

    public abstract void renderModifiers(@NotNull FirAnonymousFunction var1);

    public void renderModifiers(@NotNull FirValueParameter valueParameter2) {
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        if (valueParameter2.isCrossinline()) {
            this.renderModifier("crossinline");
        }
        if (valueParameter2.isNoinline()) {
            this.renderModifier("noinline");
        }
        if (valueParameter2.isVararg()) {
            this.renderModifier("vararg");
        }
    }

    public void renderModifiers(@NotNull FirTypeParameter typeParameter) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        if (typeParameter.isReified()) {
            this.renderModifier("reified");
        }
    }

    public void renderModifiers(@NotNull FirFunctionTypeRef functionTypeRef) {
        Intrinsics.checkNotNullParameter(functionTypeRef, "functionTypeRef");
        if (functionTypeRef.isSuspend()) {
            this.renderModifier("suspend");
        }
    }

    protected void renderModifier(@Nullable String modifier) {
        if (modifier == null) {
            return;
        }
        Object[] objectArray = new Object[]{modifier + ' '};
        this.getPrinter().print(objectArray);
    }

    @NotNull
    protected String asString(@NotNull Visibility $this$asString, @Nullable EffectiveVisibility effectiveVisibility) {
        Intrinsics.checkNotNullParameter($this$asString, "<this>");
        if (Intrinsics.areEqual($this$asString, Visibilities.Unknown.INSTANCE)) {
            return "public?";
        }
        String itself = $this$asString.toString();
        if (effectiveVisibility == null) {
            return itself;
        }
        Visibility effectiveAsVisibility = effectiveVisibility.toVisibility();
        if (Intrinsics.areEqual(effectiveAsVisibility, $this$asString)) {
            return itself;
        }
        if (Intrinsics.areEqual(effectiveAsVisibility, Visibilities.Private.INSTANCE) && Intrinsics.areEqual($this$asString, Visibilities.PrivateToThis.INSTANCE)) {
            return itself;
        }
        if (!visibilitiesToRenderEffectiveSet.contains($this$asString)) {
            return itself;
        }
        return itself + '[' + effectiveVisibility.getName() + ']';
    }

    public static /* synthetic */ String asString$default(FirModifierRenderer firModifierRenderer, Visibility visibility, EffectiveVisibility effectiveVisibility, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asString");
        }
        if ((n & 1) != 0) {
            effectiveVisibility = null;
        }
        return firModifierRenderer.asString(visibility, effectiveVisibility);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected String modalityAsString(@NotNull FirMemberDeclaration $this$modalityAsString) {
        Intrinsics.checkNotNullParameter($this$modalityAsString, "<this>");
        if ($this$modalityAsString instanceof FirField) {
            if (!((FirField)$this$modalityAsString).isVal()) return null;
            return "final";
        }
        FirMemberDeclaration $this$modality$iv = $this$modalityAsString;
        boolean $i$f$getModality = false;
        Object object = $this$modality$iv.getStatus().getModality();
        if (object != null && (object = object.name()) != null) {
            String string2 = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)object);
            object = string2;
            if (string2 != null) return object;
        }
        FirMemberDeclaration $this$modalityAsString_u24lambda_u240 = $this$modalityAsString;
        boolean bl = false;
        if (!($this$modalityAsString_u24lambda_u240 instanceof FirCallableDeclaration)) return "final?";
        FirMemberDeclaration $this$isOverride$iv = $this$modalityAsString_u24lambda_u240;
        boolean $i$f$isOverride = false;
        if (!$this$isOverride$iv.getStatus().isOverride()) return "final?";
        return "open?";
    }

    static {
        Visibility[] visibilityArray = new Visibility[]{Visibilities.Private.INSTANCE, Visibilities.PrivateToThis.INSTANCE, Visibilities.Internal.INSTANCE, Visibilities.Protected.INSTANCE, Visibilities.Public.INSTANCE, Visibilities.Local.INSTANCE};
        visibilitiesToRenderEffectiveSet = SetsKt.setOf(visibilityArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/FirModifierRenderer$Companion;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "visibilitiesToRenderEffectiveSet", "Ljava/util/Set;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

