/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0004\u001a\u00060\u0002j\u0002`\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\n\u001a\u00020\t2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007\"\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\f\u001a\u00020\t2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007\"\u00020\u0001\u00a2\u0006\u0004\b\f\u0010\u000bJ\u000f\u0010\u000f\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0011\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\r\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u000eJ/\u0010\u0018\u001a\u00020\t2\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J)\u0010\"\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\u0010\u001f\u001a\u00060\u001dR\u00020\u001eH\u0000\u00a2\u0006\u0004\b \u0010!J)\u0010$\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\u0010\u001f\u001a\u00060\u001dR\u00020\u001eH\u0000\u00a2\u0006\u0004\b#\u0010!J\u000f\u0010%\u001a\u00020\u0013H\u0017\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/FirPrinter;", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "builder", "<init>", "(Ljava/lang/StringBuilder;)V", "", "objects", "", "print", "([Ljava/lang/Object;)V", "println", "pushIndent$tree", "()V", "pushIndent", "popIndent$tree", "popIndent", "newLine", "", "leftBrace", "rightBrace", "Lkotlin/Function0;", "f", "renderInBraces", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "elements", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;", "Lorg/jetbrains/kotlin/fir/renderer/FirRenderer;", "visitor", "renderSeparated$tree", "(Ljava/util/List;Lorg/jetbrains/kotlin/fir/renderer/FirRenderer$Visitor;)V", "renderSeparated", "renderSeparatedWithNewlines$tree", "renderSeparatedWithNewlines", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/utils/Printer;", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "", "lineBeginning", "Z"})
public class FirPrinter {
    @NotNull
    private final Printer printer;
    private boolean lineBeginning;

    public FirPrinter(@NotNull StringBuilder builder2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        this.printer = new Printer(builder2, 0, null, 6, null);
        this.lineBeginning = true;
    }

    public final void print(Object ... objects) {
        Printer printer;
        Intrinsics.checkNotNullParameter(objects, "objects");
        if (this.lineBeginning) {
            this.lineBeginning = false;
            printer = this.printer.print(Arrays.copyOf(objects, objects.length));
        } else {
            printer = this.printer.printWithNoIndent(Arrays.copyOf(objects, objects.length));
        }
    }

    public final void println(Object ... objects) {
        Intrinsics.checkNotNullParameter(objects, "objects");
        this.print(Arrays.copyOf(objects, objects.length));
        this.printer.printlnWithNoIndent(new Object[0]);
        this.lineBeginning = true;
    }

    public final void pushIndent$tree() {
        this.printer.pushIndent();
    }

    public final void popIndent$tree() {
        this.printer.popIndent();
    }

    public final void newLine() {
        this.println(new Object[0]);
    }

    public final void renderInBraces(@NotNull String leftBrace, @NotNull String rightBrace, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(leftBrace, "leftBrace");
        Intrinsics.checkNotNullParameter(rightBrace, "rightBrace");
        Intrinsics.checkNotNullParameter(f, "f");
        Object[] objectArray = new Object[]{' ' + leftBrace};
        this.println(objectArray);
        this.pushIndent$tree();
        f.invoke();
        this.popIndent$tree();
        objectArray = new Object[]{rightBrace};
        this.println(objectArray);
    }

    public static /* synthetic */ void renderInBraces$default(FirPrinter firPrinter, String string2, String string3, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: renderInBraces");
        }
        if ((n & 1) != 0) {
            string2 = "{";
        }
        if ((n & 2) != 0) {
            string3 = "}";
        }
        firPrinter.renderInBraces(string2, string3, function0);
    }

    public final void renderSeparated$tree(@NotNull List<? extends FirElement> elements, @NotNull FirRenderer.Visitor visitor2) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        Iterator iterator2 = ((Iterable)elements).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            FirElement element = (FirElement)iterator2.next();
            if (index2 > 0) {
                Object[] objectArray = new Object[]{", "};
                this.print(objectArray);
            }
            element.accept(visitor2);
        }
    }

    public final void renderSeparatedWithNewlines$tree(@NotNull List<? extends FirElement> elements, @NotNull FirRenderer.Visitor visitor2) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        Iterator iterator2 = ((Iterable)elements).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            FirElement element = (FirElement)iterator2.next();
            if (index2 > 0) {
                Object[] objectArray = new Object[]{","};
                this.print(objectArray);
                this.newLine();
            }
            element.accept(visitor2);
        }
    }

    @NotNull
    public String toString() {
        return this.printer.toString();
    }
}

