/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u0011\u0010\u0005\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0003\u001a\u0011\u0010\u0006\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0003\u001a\u0011\u0010\u0007\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\u0003\u001a\u0011\u0010\b\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\b\u0010\u0003\u001a\u0011\u0010\t\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\u0003\u001a\u0011\u0010\n\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\u0003\u001a\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u00020\u000b2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/name/CallableId;", "", "isInvoke", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "isFunctionOrSuspendFunctionInvoke", "isSuspendFunctionInvoke", "isFunctionInvoke", "isKFunctionInvoke", "isIteratorNext", "isIteratorHasNext", "isIterator", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/name/FqName;"})
public final class CallableIdUtilsKt {
    public static final boolean isInvoke(@NotNull CallableId $this$isInvoke) {
        Intrinsics.checkNotNullParameter($this$isInvoke, "<this>");
        return CallableIdUtilsKt.isFunctionInvoke($this$isInvoke) || CallableIdUtilsKt.isKFunctionInvoke($this$isInvoke);
    }

    public static final boolean isFunctionOrSuspendFunctionInvoke(@NotNull CallableId $this$isFunctionOrSuspendFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isFunctionOrSuspendFunctionInvoke, "<this>");
        return CallableIdUtilsKt.isFunctionInvoke($this$isFunctionOrSuspendFunctionInvoke) || CallableIdUtilsKt.isSuspendFunctionInvoke($this$isFunctionOrSuspendFunctionInvoke);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuspendFunctionInvoke(@NotNull CallableId $this$isSuspendFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionInvoke, "<this>");
        if (!Intrinsics.areEqual($this$isSuspendFunctionInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName2 = $this$isSuspendFunctionInvoke.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, "SuspendFunction", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isSuspendFunctionInvoke.getPackageName(), StandardClassIds.INSTANCE.getBASE_COROUTINES_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFunctionInvoke(@NotNull CallableId $this$isFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isFunctionInvoke, "<this>");
        if (!Intrinsics.areEqual($this$isFunctionInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName2 = $this$isFunctionInvoke.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, "Function", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isFunctionInvoke.getPackageName(), StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKFunctionInvoke(@NotNull CallableId $this$isKFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isKFunctionInvoke, "<this>");
        if (!Intrinsics.areEqual($this$isKFunctionInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName2 = $this$isKFunctionInvoke.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, "KFunction", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isKFunctionInvoke.getPackageName(), StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorNext(@NotNull CallableId $this$isIteratorNext) {
        Intrinsics.checkNotNullParameter($this$isIteratorNext, "<this>");
        if (!Intrinsics.areEqual($this$isIteratorNext.getCallableName().asString(), "next")) return false;
        FqName fqName2 = $this$isIteratorNext.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)object, "Iterator", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isIteratorNext.getPackageName(), StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorHasNext(@NotNull CallableId $this$isIteratorHasNext) {
        Intrinsics.checkNotNullParameter($this$isIteratorHasNext, "<this>");
        if (!Intrinsics.areEqual($this$isIteratorHasNext.getCallableName().asString(), "hasNext")) return false;
        FqName fqName2 = $this$isIteratorHasNext.getClassName();
        Object object = fqName2;
        if (fqName2 == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)object, "Iterator", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isIteratorHasNext.getPackageName(), StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIterator(@NotNull CallableId $this$isIterator) {
        Intrinsics.checkNotNullParameter($this$isIterator, "<this>");
        if (!Intrinsics.areEqual($this$isIterator.getCallableName().asString(), "iterator")) return false;
        String[] stringArray = new String[]{"kotlin", "kotlin.collections", "kotlin.ranges"};
        if (!ArraysKt.contains(stringArray, $this$isIterator.getPackageName().asString())) return false;
        return true;
    }

    @Nullable
    public static final FqName fqName(@NotNull FirAnnotation $this$fqName, @NotNull FirSession session) {
        Object object;
        Intrinsics.checkNotNullParameter($this$fqName, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirTypeRef $this$coneTypeSafe$iv = $this$fqName.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        if (!(coneKotlinType instanceof ConeSimpleKotlinType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeSimpleKotlinType)((ConeKotlinType)((ConeSimpleKotlinType)coneKotlinType))) == null || (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeKotlinType)object, session)) == null) {
            return null;
        }
        Object symbol = object;
        return ((FirClassLikeSymbol)symbol).getClassId().asSingleFqName();
    }
}

