/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapper;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\t\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0017\u00a2\u0006\u0004\b\t\u0010\rJ\u001b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0017\u00a2\u0006\u0004\b\u000e\u0010\rR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00108\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirJavaClassMapper;", "Lorg/jetbrains/kotlin/fir/scopes/FirPlatformClassMapper;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "getCorrespondingPlatformClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/name/ClassId;", "getCorrespondingKotlinClass", "Lorg/jetbrains/kotlin/fir/FirSession;", "", "classTypealiasesThatDontCauseAmbiguity", "Ljava/util/Map;", "getClassTypealiasesThatDontCauseAmbiguity", "()Ljava/util/Map;"})
public final class FirJavaClassMapper
extends FirPlatformClassMapper {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Map<ClassId, ClassId> classTypealiasesThatDontCauseAmbiguity;

    public FirJavaClassMapper(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        this.classTypealiasesThatDontCauseAmbiguity = MapsKt.mapOf(TuplesKt.to(JvmStandardClassIds.Annotations.INSTANCE.getThrows(), JvmStandardClassIds.Annotations.INSTANCE.getThrowsAlias()));
    }

    @Override
    @Nullable
    public FirRegularClass getCorrespondingPlatformClass(@NotNull FirClassLikeDeclaration declaration) {
        FirClassLikeDeclaration firClassLikeDeclaration;
        ClassId javaClassId;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        ClassId classId = javaClassId = this.getCorrespondingPlatformClass(declaration.getSymbol().getClassId());
        if (classId != null) {
            ClassId it = classId;
            boolean bl = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.session).getClassLikeSymbolByClassId(it);
            firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        } else {
            firClassLikeDeclaration = null;
        }
        FirClassLikeDeclaration firClassLikeDeclaration2 = firClassLikeDeclaration;
        return firClassLikeDeclaration2 instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration2 : null;
    }

    @Override
    @Nullable
    public ClassId getCorrespondingPlatformClass(@Nullable ClassId classId) {
        if (classId == null) {
            return null;
        }
        return JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(classId.asSingleFqName().toUnsafe());
    }

    @Override
    @Nullable
    public ClassId getCorrespondingKotlinClass(@Nullable ClassId classId) {
        if (classId == null) {
            return null;
        }
        return JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(classId.asSingleFqName());
    }

    @Override
    @NotNull
    public Map<ClassId, ClassId> getClassTypealiasesThatDontCauseAmbiguity() {
        return this.classTypealiasesThatDontCauseAmbiguity;
    }
}

