/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FunctionTypeKindSubstitutor;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemCommonSuperTypesContext;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001f\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a#\u0010\t\u001a\u00020\u0000*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\t\u0010\n\u001a'\u0010\f\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0001\u00a2\u0006\u0004\b\f\u0010\r\u001a#\u0010\u0013\u001a\u00020\u0012*\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "argumentType", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "prepareCapturedType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "parameter", "getExpectedType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expectedType", "captureFromTypeParameterUpperBoundIfNeeded", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/types/model/TypeSystemCommonSuperTypesContext;", "context", "", "hasSupertypeWithGivenClassId", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/types/model/TypeSystemCommonSuperTypesContext;)Z"})
public final class ArgumentUtilsKt {
    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull ConeKotlinType argumentType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(session, "session");
        if (org.jetbrains.kotlin.fir.types.TypeUtilsKt.isRaw(argumentType)) {
            return argumentType;
        }
        ConeKotlinType coneKotlinType = (ConeKotlinType)TypeComponentsKt.getTypeContext(session).captureFromExpression(TypeExpansionUtilsKt.fullyExpandedType$default(argumentType, session, null, 2, null));
        if (coneKotlinType == null) {
            coneKotlinType = argumentType;
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType getExpectedType(@NotNull FirExpression $this$getExpectedType, @NotNull FirSession session, @NotNull FirValueParameter parameter) {
        ConeKotlinType expectedType;
        Intrinsics.checkNotNullParameter($this$getExpectedType, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        FirExpression firExpression = $this$getExpectedType;
        boolean shouldUnwrapVarargType = firExpression instanceof FirSpreadArgumentExpression || firExpression instanceof FirNamedArgumentExpression ? false : parameter.isVararg();
        ConeKotlinType coneKotlinType = expectedType = shouldUnwrapVarargType ? ArrayUtilsKt.varargElementType(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())) : FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
        if (!FirFunctionTypeKindServiceKt.getFunctionTypeService(session).hasExtensionKinds()) {
            return expectedType;
        }
        return new FunctionTypeKindSubstitutor(session).substituteOrSelf(expectedType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeKotlinType captureFromTypeParameterUpperBoundIfNeeded(@NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType, @NotNull FirSession session) {
        ConeKotlinType coneKotlinType;
        Object v2;
        ConeInferenceContext context;
        block8: {
            void $this$singleOrNull$iv;
            Intrinsics.checkNotNullParameter(argumentType, "argumentType");
            Intrinsics.checkNotNullParameter(expectedType, "expectedType");
            Intrinsics.checkNotNullParameter(session, "session");
            ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypeUtilsKt.upperBoundIfFlexible(expectedType));
            if (classId == null) {
                return argumentType;
            }
            ClassId expectedTypeClassId = classId;
            ConeRigidType coneRigidType = ConeTypeUtilsKt.lowerBoundIfFlexible(argumentType);
            ConeTypeParameterType coneTypeParameterType = coneRigidType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneRigidType : null;
            if (coneTypeParameterType == null) {
                return argumentType;
            }
            ConeTypeParameterType simplifiedArgumentType = coneTypeParameterType;
            context = TypeComponentsKt.getTypeContext(session);
            Iterable iterable = TypeUtilsKt.collectUpperBounds(simplifiedArgumentType);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ConeClassLikeType it = (ConeClassLikeType)element$iv;
                boolean bl = false;
                if (!ArgumentUtilsKt.hasSupertypeWithGivenClassId(it, expectedTypeClassId, context)) continue;
                if (found$iv) {
                    v2 = null;
                    break block8;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        ConeClassLikeType coneClassLikeType = v2;
        if (coneClassLikeType == null) {
            return argumentType;
        }
        ConeClassLikeType chosenSupertype = coneClassLikeType;
        ConeKotlinType coneKotlinType2 = (ConeKotlinType)context.captureFromExpression(chosenSupertype);
        if (coneKotlinType2 == null) {
            return argumentType;
        }
        ConeKotlinType capturedType = coneKotlinType2;
        if (argumentType instanceof ConeDefinitelyNotNullType) {
            ConeDefinitelyNotNullType coneDefinitelyNotNullType = org.jetbrains.kotlin.fir.types.TypeUtilsKt.create$default(ConeDefinitelyNotNullType.Companion, capturedType, TypeComponentsKt.getTypeContext(session), false, 4, null);
            coneKotlinType = coneDefinitelyNotNullType != null ? (ConeKotlinType)coneDefinitelyNotNullType : capturedType;
        } else {
            coneKotlinType = capturedType;
        }
        return coneKotlinType;
    }

    private static final boolean hasSupertypeWithGivenClassId(ConeKotlinType $this$hasSupertypeWithGivenClassId, ClassId classId, TypeSystemCommonSuperTypesContext context) {
        TypeSystemCommonSuperTypesContext $this$hasSupertypeWithGivenClassId_u24lambda_u242 = context;
        boolean bl = false;
        return $this$hasSupertypeWithGivenClassId_u24lambda_u242.anySuperTypeConstructor($this$hasSupertypeWithGivenClassId, arg_0 -> ArgumentUtilsKt.hasSupertypeWithGivenClassId$lambda$2$lambda$1($this$hasSupertypeWithGivenClassId_u24lambda_u242, classId, arg_0));
    }

    private static final boolean hasSupertypeWithGivenClassId$lambda$2$lambda$1(TypeSystemCommonSuperTypesContext $this_with, ClassId $classId, RigidTypeMarker it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TypeConstructorMarker typeConstructor2 = $this_with.typeConstructor(it);
        return typeConstructor2 instanceof ConeClassLikeLookupTag && Intrinsics.areEqual(((ConeClassLikeLookupTag)typeConstructor2).getClassId(), $classId);
    }
}

