/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceConversionStrategy;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0000\u0018\u00002\u00020\u0001BQ\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\"\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tj\b\u0012\u0004\u0012\u00020\f`\r\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR6\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tj\b\u0012\u0004\u0012\u00020\f`\r8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0010\u001a\u00020\u000f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u001f\u001a\u0004\b \u0010!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceAdaptation;", "", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "argumentTypes", "Lorg/jetbrains/kotlin/types/expressions/CoercionStrategy;", "coercionStrategy", "", "defaults", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceMappedArguments;", "mappedArguments", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceConversionStrategy;", "suspendConversionStrategy", "<init>", "([Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/types/expressions/CoercionStrategy;ILjava/util/Map;Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceConversionStrategy;)V", "[Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getArgumentTypes", "()[Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/types/expressions/CoercionStrategy;", "getCoercionStrategy", "()Lorg/jetbrains/kotlin/types/expressions/CoercionStrategy;", "I", "getDefaults", "()I", "Ljava/util/Map;", "getMappedArguments", "()Ljava/util/Map;", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceConversionStrategy;", "getSuspendConversionStrategy", "()Lorg/jetbrains/kotlin/fir/resolve/calls/CallableReferenceConversionStrategy;"})
public final class CallableReferenceAdaptation {
    @NotNull
    private final ConeKotlinType[] argumentTypes;
    @NotNull
    private final CoercionStrategy coercionStrategy;
    private final int defaults;
    @NotNull
    private final Map<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> mappedArguments;
    @NotNull
    private final CallableReferenceConversionStrategy suspendConversionStrategy;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableReferenceAdaptation(@NotNull ConeKotlinType[] argumentTypes, @NotNull CoercionStrategy coercionStrategy, int defaults, @NotNull Map<FirValueParameter, ? extends ResolvedCallArgument<? extends ConeResolutionAtom>> mappedArguments, @NotNull CallableReferenceConversionStrategy suspendConversionStrategy) {
        boolean bl;
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter((Object)coercionStrategy, "coercionStrategy");
        Intrinsics.checkNotNullParameter(mappedArguments, "mappedArguments");
        Intrinsics.checkNotNullParameter(suspendConversionStrategy, "suspendConversionStrategy");
        this.argumentTypes = argumentTypes;
        this.coercionStrategy = coercionStrategy;
        this.defaults = defaults;
        this.mappedArguments = mappedArguments;
        this.suspendConversionStrategy = suspendConversionStrategy;
        if (!AbstractTypeChecker.RUN_SLOW_ASSERTIONS) return;
        if (this.defaults != 0) return;
        if (!Intrinsics.areEqual(this.suspendConversionStrategy, CallableReferenceConversionStrategy.NoConversion.INSTANCE)) return;
        if (this.coercionStrategy != CoercionStrategy.NO_COERCION) return;
        Iterable $this$any$iv = this.mappedArguments.values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                ResolvedCallArgument it = (ResolvedCallArgument)element$iv;
                boolean bl2 = false;
                if (!(it instanceof ResolvedCallArgument.VarargArgument)) continue;
                return;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        boolean bl3 = false;
        if (bl3) return;
        boolean bl4 = false;
        String string2 = "Adaptation must be non-trivial.";
        throw new IllegalArgumentException(string2.toString());
    }

    @NotNull
    public final ConeKotlinType[] getArgumentTypes() {
        return this.argumentTypes;
    }

    @NotNull
    public final CoercionStrategy getCoercionStrategy() {
        return this.coercionStrategy;
    }

    public final int getDefaults() {
        return this.defaults;
    }

    @NotNull
    public final Map<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> getMappedArguments() {
        return this.mappedArguments;
    }

    @NotNull
    public final CallableReferenceConversionStrategy getSuspendConversionStrategy() {
        return this.suspendConversionStrategy;
    }
}

