/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.QualifierReceiver;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0011\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0011\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\t\u001a\u00020\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u000b\u001a\u00020\n8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ClassQualifierReceiver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/QualifierReceiver;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "explicitReceiver", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "originalSymbol", "Lorg/jetbrains/kotlin/fir/FirSession;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "<init>", "(Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "callableScope", "()Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "classifierScope", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getClassSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getOriginalSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;"})
public final class ClassQualifierReceiver
extends QualifierReceiver {
    @NotNull
    private final FirRegularClassSymbol classSymbol;
    @NotNull
    private final FirClassLikeSymbol<?> originalSymbol;
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final ScopeSession scopeSession;

    public ClassQualifierReceiver(@NotNull FirResolvedQualifier explicitReceiver, @NotNull FirRegularClassSymbol classSymbol, @NotNull FirClassLikeSymbol<?> originalSymbol, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(explicitReceiver, "explicitReceiver");
        Intrinsics.checkNotNullParameter(classSymbol, "classSymbol");
        Intrinsics.checkNotNullParameter(originalSymbol, "originalSymbol");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        super(explicitReceiver);
        this.classSymbol = classSymbol;
        this.originalSymbol = originalSymbol;
        this.useSiteSession = useSiteSession;
        this.scopeSession = scopeSession;
    }

    @NotNull
    public final FirRegularClassSymbol getClassSymbol() {
        return this.classSymbol;
    }

    @NotNull
    public final FirClassLikeSymbol<?> getOriginalSymbol() {
        return this.originalSymbol;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @Override
    @Nullable
    public FirScope callableScope() {
        FirRegularClass klass = (FirRegularClass)this.classSymbol.getFir();
        FirScopeProvider provider2 = klass.getScopeProvider();
        return provider2.getStaticCallableMemberScope(klass, this.useSiteSession, this.scopeSession);
    }

    @Override
    @Nullable
    public FirScope classifierScope() {
        FirRegularClass klass = (FirRegularClass)this.classSymbol.getFir();
        return klass.getScopeProvider().getNestedClassifierScope(klass, this.useSiteSession, this.scopeSession);
    }
}

