/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0003\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00108WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "receiverExpression", "<init>", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "Lorg/jetbrains/kotlin/fir/FirSession;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "scope", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getReceiverExpression", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type"})
public final class ExpressionReceiverValue
implements ReceiverValue {
    @NotNull
    private final FirExpression receiverExpression;

    public ExpressionReceiverValue(@NotNull FirExpression receiverExpression) {
        Intrinsics.checkNotNullParameter(receiverExpression, "receiverExpression");
        this.receiverExpression = receiverExpression;
    }

    @Override
    @NotNull
    public FirExpression getReceiverExpression() {
        return this.receiverExpression;
    }

    @Override
    @NotNull
    public ConeKotlinType getType() {
        return FirTypeUtilsKt.getResolvedType(this.getReceiverExpression());
    }

    @Override
    @Nullable
    public FirTypeScope scope(@NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        FirExpression receiverExpr = this.getReceiverExpression();
        if (receiverExpr instanceof FirCheckNotNullCall) {
            FirCall $this$arguments$iv = (FirCall)((Object)receiverExpr);
            boolean $i$f$getArguments = false;
            receiverExpr = CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        }
        if (receiverExpr instanceof FirSmartCastExpression) {
            return ScopeUtilsKt.smartcastScope((FirSmartCastExpression)receiverExpr, useSiteSession, scopeSession, FirResolvePhase.STATUS);
        }
        return ScopeUtilsKt.scope(this.getType(), useSiteSession, scopeSession, CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS);
    }
}

