/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirSmartCastExpressionBuilder;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirThisOwnerSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.types.SmartcastStability;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\u00020\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH%\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0004H'\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00188'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00028\u0007@BX\u0087\u000e\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b \u0010\u001d\u001a\u0004\b!\u0010\u001fR\u001b\u0010%\u001a\u00020\b8EX\u0085\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010\nR\u0016\u0010&\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010\u0015R\u0018\u0010'\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(\u0082\u0001\u0002)*"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "", "mutable", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Z)V", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "computeOriginalExpression", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "computeExpression", "other", "isSameImplicitReceiverInstance", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "", "updateTypeFromSmartcast", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "keepMutable", "createSnapshot", "(Z)Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue;", "Z", "getMutable", "()Z", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getBoundSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "boundSymbol", "value", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "originalType", "getOriginalType", "originalExpression$delegate", "Lkotlin/Lazy;", "getOriginalExpression", "originalExpression", "isSmartCasted", "cachedCurrentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitContextParameterValue;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;"})
public abstract class ImplicitValue {
    private final boolean mutable;
    @NotNull
    private ConeKotlinType type;
    @NotNull
    private final ConeKotlinType originalType;
    @NotNull
    private final Lazy originalExpression$delegate;
    private boolean isSmartCasted;
    @Nullable
    private FirExpression cachedCurrentExpression;

    private ImplicitValue(ConeKotlinType type2, boolean mutable) {
        this.mutable = mutable;
        this.type = type2;
        this.originalType = type2;
        this.originalExpression$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)new Function0<FirExpression>((Object)this){

            public final FirExpression invoke() {
                return ((ImplicitValue)this.receiver).computeOriginalExpression();
            }
        });
    }

    protected final boolean getMutable() {
        return this.mutable;
    }

    @NotNull
    public abstract FirBasedSymbol<?> getBoundSymbol();

    @NotNull
    public final ConeKotlinType getType() {
        return this.type;
    }

    @NotNull
    public final ConeKotlinType getOriginalType() {
        return this.originalType;
    }

    @NotNull
    protected abstract FirExpression computeOriginalExpression();

    @NotNull
    protected final FirExpression getOriginalExpression() {
        Lazy lazy = this.originalExpression$delegate;
        return (FirExpression)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirExpression computeExpression() {
        FirExpression firExpression;
        FirExpression firExpression2 = this.cachedCurrentExpression;
        if (firExpression2 != null) {
            FirExpression it = firExpression2;
            boolean bl = false;
            return it;
        }
        if (this.isSmartCasted) {
            void $this$computeExpression_u24lambda_u242_u24lambda_u241;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            FirSmartCastExpressionBuilder firSmartCastExpressionBuilder;
            boolean $i$f$buildSmartCastExpression = false;
            FirSmartCastExpressionBuilder $this$computeExpression_u24lambda_u242 = firSmartCastExpressionBuilder = new FirSmartCastExpressionBuilder();
            boolean bl = false;
            $this$computeExpression_u24lambda_u242.setOriginalExpression(this.getOriginalExpression());
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            FirSmartCastExpressionBuilder firSmartCastExpressionBuilder2 = $this$computeExpression_u24lambda_u242;
            boolean bl2 = false;
            KtSourceElement ktSourceElement = this.getOriginalExpression().getSource();
            $this$computeExpression_u24lambda_u242_u24lambda_u241.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.SmartCastedTypeRef.INSTANCE, 0, 0, 6, null) : null);
            $this$computeExpression_u24lambda_u242_u24lambda_u241.setConeType(this.type);
            firSmartCastExpressionBuilder2.setSmartcastType(firResolvedTypeRefBuilder.build());
            $this$computeExpression_u24lambda_u242.setTypesFromSmartCast((Collection<? extends ConeKotlinType>)CollectionsKt.listOf(this.type));
            $this$computeExpression_u24lambda_u242.setSmartcastStability(SmartcastStability.STABLE_VALUE);
            $this$computeExpression_u24lambda_u242.setConeTypeOrNull(this.type);
            firExpression = firSmartCastExpressionBuilder.build();
        } else {
            firExpression = this.getOriginalExpression();
        }
        FirExpression it = firExpression2 = firExpression;
        boolean bl = false;
        this.cachedCurrentExpression = it;
        return firExpression2;
    }

    public final boolean isSameImplicitReceiverInstance(@NotNull FirExpression other) {
        FirBasedSymbol<Object> firBasedSymbol;
        FirExpression otherOriginal;
        Intrinsics.checkNotNullParameter(other, "other");
        FirExpression firExpression = otherOriginal = FirExpressionUtilKt.unwrapSmartcastExpression(other);
        if (firExpression instanceof FirThisReceiverExpression) {
            firBasedSymbol = ((FirThisReceiverExpression)otherOriginal).getCalleeReference().getBoundSymbol();
        } else if (firExpression instanceof FirPropertyAccessExpression) {
            FirReference $this$toResolvedSymbol_u24default$iv = ((FirPropertyAccessExpression)otherOriginal).getCalleeReference();
            boolean discardErrorReference$iv = false;
            boolean $i$f$toResolvedSymbol = false;
            FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$toResolvedSymbol_u24default$iv);
            firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
            if (!(firBasedSymbol instanceof FirBasedSymbol)) {
                firBasedSymbol = null;
            }
        } else {
            firBasedSymbol = null;
        }
        FirThisOwnerSymbol<?> otherBoundSymbol = firBasedSymbol;
        return this.getBoundSymbol() == otherBoundSymbol;
    }

    public void updateTypeFromSmartcast(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        if (Intrinsics.areEqual(type2, this.type)) {
            return;
        }
        if (!this.mutable) {
            throw new IllegalStateException("Cannot mutate an immutable ImplicitReceiverValue".toString());
        }
        this.type = type2;
        this.isSmartCasted = !Intrinsics.areEqual(type2, this.originalType);
        this.cachedCurrentExpression = null;
    }

    @NotNull
    public abstract ImplicitValue createSnapshot(boolean var1);

    public /* synthetic */ ImplicitValue(ConeKotlinType type2, boolean mutable, DefaultConstructorMarker $constructor_marker) {
        this(type2, mutable);
    }
}

