/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.candidate;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionResultOverridesOtherToPreserveCompatibility;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStageRunner;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u000f\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001dR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u001e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010 R$\u0010#\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00118\u0007@BX\u0087\u000e\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0011\u0010+\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0017\u0010,\u001a\u00020\u00178F\u00a2\u0006\f\u0012\u0004\b-\u0010\n\u001a\u0004\b,\u0010*"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CandidateCollector;", "", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "components", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;", "resolutionStageRunner", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;)V", "", "newDataSet", "()V", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "group", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "consumeCandidate", "(Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;)Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "", "bestCandidates", "()Ljava/util/List;", "", "shouldStopAtTheGroup", "(Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;)Z", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "getComponents", "()Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;", "", "groupNumbers", "Ljava/util/List;", "candidates", "value", "currentApplicability", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "getCurrentApplicability", "()Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "bestGroup", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "getShouldStopResolve", "()Z", "shouldStopResolve", "isSuccess", "isSuccess$annotations"})
public class CandidateCollector {
    @NotNull
    private final BodyResolveComponents components;
    @NotNull
    private final ResolutionStageRunner resolutionStageRunner;
    @NotNull
    private final List<TowerGroup> groupNumbers;
    @NotNull
    private final List<Candidate> candidates;
    @NotNull
    private CandidateApplicability currentApplicability;
    @NotNull
    private TowerGroup bestGroup;

    public CandidateCollector(@NotNull BodyResolveComponents components, @NotNull ResolutionStageRunner resolutionStageRunner) {
        Intrinsics.checkNotNullParameter(components, "components");
        Intrinsics.checkNotNullParameter(resolutionStageRunner, "resolutionStageRunner");
        this.components = components;
        this.resolutionStageRunner = resolutionStageRunner;
        this.groupNumbers = new ArrayList();
        this.candidates = new ArrayList();
        this.currentApplicability = CandidateApplicability.HIDDEN;
        this.bestGroup = TowerGroup.Companion.getLast();
    }

    @NotNull
    public final BodyResolveComponents getComponents() {
        return this.components;
    }

    @NotNull
    public final CandidateApplicability getCurrentApplicability() {
        return this.currentApplicability;
    }

    public final void newDataSet() {
        this.groupNumbers.clear();
        this.candidates.clear();
        this.currentApplicability = CandidateApplicability.HIDDEN;
        this.bestGroup = TowerGroup.Companion.getLast();
    }

    @NotNull
    public CandidateApplicability consumeCandidate(@NotNull TowerGroup group, @NotNull Candidate candidate, @NotNull ResolutionContext context) {
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(context, "context");
        CandidateApplicability applicability = ResolutionStageRunner.processCandidate$default(this.resolutionStageRunner, candidate, context, false, 4, null);
        if (applicability.compareTo((Enum)this.currentApplicability) > 0 || applicability == this.currentApplicability && group.compareTo(this.bestGroup) < 0) {
            if (applicability.compareTo((Enum)CandidateApplicability.RESOLVED_LOW_PRIORITY) >= 0) {
                this.candidates.clear();
            }
            if (this.currentApplicability == CandidateApplicability.RESOLVED_NEED_PRESERVE_COMPATIBILITY && applicability.compareTo((Enum)this.currentApplicability) > 0) {
                candidate.addDiagnostic(ResolutionResultOverridesOtherToPreserveCompatibility.INSTANCE);
            }
            this.currentApplicability = applicability;
            this.bestGroup = group;
        }
        if (applicability == this.currentApplicability && Intrinsics.areEqual(group, this.bestGroup) || this.currentApplicability == CandidateApplicability.INAPPLICABLE_ARGUMENTS_MAPPING_ERROR && applicability == CandidateApplicability.INAPPLICABLE_WRONG_RECEIVER) {
            this.candidates.add(candidate);
        }
        return applicability;
    }

    @NotNull
    public final List<Candidate> bestCandidates() {
        return this.candidates;
    }

    public boolean shouldStopAtTheGroup(@NotNull TowerGroup group) {
        Intrinsics.checkNotNullParameter(group, "group");
        return this.getShouldStopResolve() && this.bestGroup.compareTo(group) < 0;
    }

    public final boolean getShouldStopResolve() {
        return CandidateApplicabilityKt.getShouldStopResolve(this.currentApplicability);
    }

    public final boolean isSuccess() {
        return CandidateApplicabilityKt.isSuccess(this.currentApplicability);
    }

    public static /* synthetic */ void isSuccess$annotations() {
    }
}

