/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.candidate;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CandidateFactory;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CandidateKt;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.FirErrorReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStageRunner;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a9\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\f\u001a9\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a+\u0010\u0011\u001a\u00020\r*\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a!\u0010\u0014\u001a\u00020\u0013*\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "callInfo", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "diagnostic", "Lorg/jetbrains/kotlin/KtSourceElement;", "source", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "resolutionContext", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;", "resolutionStageRunner", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/FirErrorReferenceWithCandidate;", "createErrorReferenceWithErrorCandidate", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;)Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/FirErrorReferenceWithCandidate;", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "candidate", "createErrorReferenceWithExistingCandidate", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;)Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/FirErrorReferenceWithCandidate;", "createErrorCandidate", "(Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;)Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "", "fullyProcessCandidate", "(Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStageRunner;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;)V"})
public final class ErrorCandidateUtilsKt {
    @NotNull
    public static final FirErrorReferenceWithCandidate createErrorReferenceWithErrorCandidate(@NotNull CallInfo callInfo, @NotNull ConeDiagnostic diagnostic, @Nullable KtSourceElement source, @NotNull ResolutionContext resolutionContext, @NotNull ResolutionStageRunner resolutionStageRunner) {
        Intrinsics.checkNotNullParameter(callInfo, "callInfo");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        Intrinsics.checkNotNullParameter(resolutionStageRunner, "resolutionStageRunner");
        return new FirErrorReferenceWithCandidate(source, callInfo.getName(), ErrorCandidateUtilsKt.createErrorCandidate(resolutionStageRunner, callInfo, resolutionContext, diagnostic), diagnostic);
    }

    @NotNull
    public static final FirErrorReferenceWithCandidate createErrorReferenceWithExistingCandidate(@NotNull Candidate candidate, @NotNull ConeDiagnostic diagnostic, @Nullable KtSourceElement source, @NotNull ResolutionContext resolutionContext, @NotNull ResolutionStageRunner resolutionStageRunner) {
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        Intrinsics.checkNotNullParameter(resolutionStageRunner, "resolutionStageRunner");
        ErrorCandidateUtilsKt.fullyProcessCandidate(resolutionStageRunner, candidate, resolutionContext);
        return new FirErrorReferenceWithCandidate(source, candidate.getCallInfo().getName(), candidate, diagnostic);
    }

    @NotNull
    public static final Candidate createErrorCandidate(@NotNull ResolutionStageRunner $this$createErrorCandidate, @NotNull CallInfo callInfo, @NotNull ResolutionContext resolutionContext, @NotNull ConeDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter($this$createErrorCandidate, "<this>");
        Intrinsics.checkNotNullParameter(callInfo, "callInfo");
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Candidate candidate = new CandidateFactory(resolutionContext, callInfo).createErrorCandidate(callInfo, diagnostic);
        $this$createErrorCandidate.processCandidate(candidate, resolutionContext, false);
        return candidate;
    }

    public static final void fullyProcessCandidate(@NotNull ResolutionStageRunner $this$fullyProcessCandidate, @NotNull Candidate candidate, @NotNull ResolutionContext resolutionContext) {
        Intrinsics.checkNotNullParameter($this$fullyProcessCandidate, "<this>");
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        if (!CandidateKt.getFullyAnalyzed(candidate)) {
            $this$fullyProcessCandidate.processCandidate(candidate, resolutionContext, false);
        }
    }
}

