/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.scopes.impl.FirStandardOverrideChecker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u0018*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/overloads/ConeCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "inferenceComponents", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;)V", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "candidates", "", "discriminateAbstracts", "chooseMaximallySpecificCandidates", "(Ljava/util/Set;Z)Ljava/util/Set;", "", "filterOutEquivalentCalls", "(Ljava/util/Collection;)Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "first", "firstCandidate", "second", "secondCandidate", "areEquivalentTopLevelCallables", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;)Z", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "", "getMappedArgumentsOrderRepresentation", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;)[I", "mappedArgumentsOrderRepresentation"})
public final class ConeEquivalentCallConflictResolver
extends ConeCallConflictResolver {
    @NotNull
    private final InferenceComponents inferenceComponents;

    public ConeEquivalentCallConflictResolver(@NotNull InferenceComponents inferenceComponents) {
        Intrinsics.checkNotNullParameter(inferenceComponents, "inferenceComponents");
        this.inferenceComponents = inferenceComponents;
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates, "candidates");
        return this.filterOutEquivalentCalls((Collection<Candidate>)candidates);
    }

    private final Set<Candidate> filterOutEquivalentCalls(Collection<Candidate> candidates) {
        Iterable $this$sortedBy$iv = candidates;
        boolean $i$f$sortedBy = false;
        List<Candidate> fromSourceFirst = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Candidate it = (Candidate)a;
                boolean bl = false;
                boolean bl2 = ((FirDeclaration)it.getSymbol().getFir()).getModuleData().getSession().getKind() != FirSession.Kind.Source;
                it = (Candidate)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, ((FirDeclaration)it.getSymbol().getFir()).getModuleData().getSession().getKind() != FirSession.Kind.Source);
            }
        });
        Set result2 = new LinkedHashSet();
        block0: for (Candidate myCandidate : fromSourceFirst) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirCallableDeclaration && ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)me).getSymbol()) == null) {
                Iterator resultIterator = result2.iterator();
                while (resultIterator.hasNext()) {
                    Candidate otherCandidate = (Candidate)resultIterator.next();
                    Object other = otherCandidate.getSymbol().getFir();
                    if (!(other instanceof FirCallableDeclaration) || ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)other).getSymbol()) != null || !this.areEquivalentTopLevelCallables((FirCallableDeclaration)me, myCandidate, (FirCallableDeclaration)other, otherCandidate)) continue;
                    FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)other;
                    boolean $i$f$isExpect = false;
                    if (!$this$isExpect$iv.getStatus().isExpect()) continue block0;
                    $this$isExpect$iv = (FirMemberDeclaration)me;
                    $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) continue block0;
                    resultIterator.remove();
                }
            }
            ((Collection)result2).add(myCandidate);
        }
        return result2;
    }

    private final boolean areEquivalentTopLevelCallables(FirCallableDeclaration first2, Candidate firstCandidate, FirCallableDeclaration second2, Candidate secondCandidate) {
        if (!Intrinsics.areEqual(first2.getSymbol().getCallableId(), second2.getSymbol().getCallableId())) {
            return false;
        }
        if (Intrinsics.areEqual(first2.getModuleData(), second2.getModuleData()) && first2.getModuleData().getSession().getKind() == FirSession.Kind.Source) {
            return false;
        }
        if (first2 instanceof FirVariable != second2 instanceof FirVariable) {
            return false;
        }
        if (!Arrays.equals(this.getMappedArgumentsOrderRepresentation(firstCandidate), this.getMappedArgumentsOrderRepresentation(secondCandidate))) {
            return false;
        }
        FirStandardOverrideChecker overrideChecker = new FirStandardOverrideChecker(this.inferenceComponents.getSession());
        return first2 instanceof FirProperty && second2 instanceof FirProperty ? overrideChecker.isOverriddenProperty(first2, (FirProperty)second2, true) && overrideChecker.isOverriddenProperty(second2, (FirProperty)first2, true) : (first2 instanceof FirSimpleFunction && second2 instanceof FirSimpleFunction ? overrideChecker.isOverriddenFunction((FirSimpleFunction)first2, (FirSimpleFunction)second2, true) && overrideChecker.isOverriddenFunction((FirSimpleFunction)second2, (FirSimpleFunction)first2, true) : false);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] getMappedArgumentsOrderRepresentation(Candidate $this$mappedArgumentsOrderRepresentation) {
        void $this$mapIndexedTo$iv$iv;
        Object obj = $this$mappedArgumentsOrderRepresentation.getSymbol().getFir();
        FirFunction firFunction = obj instanceof FirFunction ? (FirFunction)obj : null;
        if (firFunction == null) {
            return null;
        }
        FirFunction function2 = firFunction;
        Iterable $this$mapIndexed$iv = function2.getValueParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo22 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void it;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it, (int)index2));
        }
        Map parametersToIndices = MapsKt.toMap((List)destination$iv$iv);
        if (!$this$mappedArgumentsOrderRepresentation.getArgumentMappingInitialized()) {
            return null;
        }
        LinkedHashMap<ConeResolutionAtom, FirValueParameter> mapping = $this$mappedArgumentsOrderRepresentation.getArgumentMapping();
        int n = 0;
        int n3 = mapping.size() + 1;
        int[] $i$f$mapIndexedTo22 = new int[n3];
        while (n < n3) {
            index$iv$iv = n++;
            $i$f$mapIndexedTo22[index$iv$iv] = function2.getValueParameters().size();
        }
        int[] result2 = $i$f$mapIndexedTo22;
        Iterator iterator2 = ((Iterable)mapping.values()).iterator();
        n3 = 0;
        while (iterator2.hasNext()) {
            int index3 = n3++;
            FirValueParameter parameter = (FirValueParameter)iterator2.next();
            Integer n4 = (Integer)parametersToIndices.get(parameter);
            if (n4 == null) {
                throw new IllegalStateException("Unmapped argument in arguments mapping".toString());
            }
            result2[index3 + 1] = n4;
        }
        return result2;
    }
}

