/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeCallConflictResolver;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u000e\u001a\u00020\t*\u00020\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0011\u001a\u00020\t*\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0015\u001a\u00020\t*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/JvmPlatformOverloadsConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/overloads/ConeCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "candidates", "", "discriminateAbstracts", "chooseMaximallySpecificCandidates", "(Ljava/util/Set;Z)Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isShadowedByFieldCandidate", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Ljava/util/Set;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "isShadowedByPropertyCandidate", "(Lorg/jetbrains/kotlin/fir/declarations/FirField;Ljava/util/Set;)Z", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeLookupTag;", "other", "strictlyDerivedFrom", "(Lorg/jetbrains/kotlin/fir/types/ConeClassLikeLookupTag;Lorg/jetbrains/kotlin/fir/types/ConeClassLikeLookupTag;)Z", "Lorg/jetbrains/kotlin/fir/FirSession;"})
public final class JvmPlatformOverloadsConflictResolver
extends ConeCallConflictResolver {
    @NotNull
    private final FirSession session;

    public JvmPlatformOverloadsConflictResolver(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates, "candidates");
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.PreferJavaFieldOverload)) {
            return candidates;
        }
        Set result2 = new LinkedHashSet();
        for (Candidate myCandidate : candidates) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirProperty) {
                if (this.isShadowedByFieldCandidate((FirProperty)me, candidates)) continue;
                ((Collection)result2).add(myCandidate);
                continue;
            }
            if (me instanceof FirField) {
                if (this.isShadowedByPropertyCandidate((FirField)me, candidates)) continue;
                ((Collection)result2).add(myCandidate);
                continue;
            }
            ((Collection)result2).add(myCandidate);
        }
        return result2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean isShadowedByFieldCandidate(FirProperty $this$isShadowedByFieldCandidate, Set<Candidate> candidates) {
        $this$unwrapSubstitutionOverrides$iv = $this$isShadowedByFieldCandidate;
        $i$f$unwrapSubstitutionOverrides = false;
        current$iv = $this$unwrapSubstitutionOverrides$iv;
        while (true) {
            $this$originalForSubstitutionOverride$iv$iv /* !! */  = current$iv;
            $i$f$getOriginalForSubstitutionOverride = false;
            if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv /* !! */ )) ** GOTO lbl-1000
            $this$isSynthetic$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv /* !! */ ;
            $i$f$isSynthetic = false;
            if ($this$isSynthetic$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
            // 2 sources

            {
                v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv /* !! */ );
            } else {
                v0 = null;
            }
            if (v0 == null) break;
            current$iv = next$iv = v0;
        }
        v1 = ClassMembersKt.containingClassLookupTag(((FirProperty)current$iv).getSymbol());
        if (v1 == null) {
            return false;
        }
        propertyContainingClassLookupTag = v1;
        for (Candidate otherCandidate : candidates) {
            $this$originalForSubstitutionOverride$iv$iv /* !! */  = otherCandidate.getSymbol().getFir();
            if (($this$originalForSubstitutionOverride$iv$iv /* !! */  instanceof FirField != false ? (FirField)$this$originalForSubstitutionOverride$iv$iv /* !! */  : null) == null) continue;
            field = field;
            $this$unwrapFakeOverrides$iv = field;
            $i$f$unwrapFakeOverrides = false;
            current$iv = $this$unwrapFakeOverrides$iv;
            while (true) {
                $this$originalIfFakeOverride$iv$iv = current$iv;
                $i$f$originalIfFakeOverride = false;
                $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                $i$f$getOriginalForSubstitutionOverride = false;
                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv)) ** GOTO lbl-1000
                $this$isSynthetic$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv;
                $i$f$isSynthetic = false;
                if ($this$isSynthetic$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                // 2 sources

                {
                    v2 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv);
                } else {
                    v2 = v3 = null;
                }
                if (v2 == null) {
                    $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                    $i$f$getBaseForIntersectionOverride = false;
                    v3 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
                }
                if (v3 == null) break;
                current$iv = next$iv = v3;
            }
            fieldContainingClassLookupTag = ClassMembersKt.containingClassLookupTag(((FirField)current$iv).getSymbol());
            if (fieldContainingClassLookupTag == null || this.strictlyDerivedFrom(propertyContainingClassLookupTag, fieldContainingClassLookupTag)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean isShadowedByPropertyCandidate(FirField $this$isShadowedByPropertyCandidate, Set<Candidate> candidates) {
        $this$unwrapFakeOverrides$iv = $this$isShadowedByPropertyCandidate;
        $i$f$unwrapFakeOverrides = false;
        current$iv = $this$unwrapFakeOverrides$iv;
        while (true) {
            $this$originalIfFakeOverride$iv$iv /* !! */  = current$iv;
            $i$f$originalIfFakeOverride = false;
            $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv /* !! */ ;
            $i$f$getOriginalForSubstitutionOverride = false;
            if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv)) ** GOTO lbl-1000
            $this$isSynthetic$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv;
            $i$f$isSynthetic = false;
            if ($this$isSynthetic$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
            // 2 sources

            {
                v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv);
            } else {
                v0 = v1 = null;
            }
            if (v0 == null) {
                $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv /* !! */ ;
                $i$f$getBaseForIntersectionOverride = false;
                v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
            }
            if (v1 == null) break;
            current$iv = next$iv = v1;
        }
        v2 = ClassMembersKt.containingClassLookupTag(((FirField)current$iv).getSymbol());
        if (v2 == null) {
            return false;
        }
        fieldContainingClassLookupTag = v2;
        for (Candidate otherCandidate : candidates) {
            $this$originalIfFakeOverride$iv$iv /* !! */  = otherCandidate.getSymbol().getFir();
            if (($this$originalIfFakeOverride$iv$iv /* !! */  instanceof FirProperty != false ? (FirProperty)$this$originalIfFakeOverride$iv$iv /* !! */  : null) == null) continue;
            property = property;
            $this$unwrapSubstitutionOverrides$iv = property;
            $i$f$unwrapSubstitutionOverrides = false;
            current$iv = $this$unwrapSubstitutionOverrides$iv;
            while (true) {
                $this$originalForSubstitutionOverride$iv$iv = current$iv;
                $i$f$getOriginalForSubstitutionOverride = false;
                if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv)) ** GOTO lbl-1000
                $this$isSynthetic$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv;
                $i$f$isSynthetic = false;
                if ($this$isSynthetic$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
                // 2 sources

                {
                    v3 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv);
                } else {
                    v3 = null;
                }
                if (v3 == null) break;
                current$iv = next$iv = v3;
            }
            propertyContainingClassLookupTag = ClassMembersKt.containingClassLookupTag(((FirProperty)current$iv).getSymbol());
            if (propertyContainingClassLookupTag == null || !this.strictlyDerivedFrom(propertyContainingClassLookupTag, fieldContainingClassLookupTag)) continue;
            return true;
        }
        return false;
    }

    private final boolean strictlyDerivedFrom(ConeClassLikeLookupTag $this$strictlyDerivedFrom, ConeClassLikeLookupTag other) {
        if (Intrinsics.areEqual($this$strictlyDerivedFrom, other)) {
            return false;
        }
        FirClassSymbol<?> firClassSymbol = ToSymbolUtilsKt.toClassSymbol($this$strictlyDerivedFrom, this.session);
        if (firClassSymbol == null || (firClassSymbol = (FirClass)firClassSymbol.getFir()) == null) {
            return false;
        }
        FirClassSymbol<?> thisClass = firClassSymbol;
        return SupertypeUtilsKt.isSubclassOf$default((FirClass)((Object)thisClass), other, this.session, true, null, false, 24, null);
    }
}

