/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012.\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0002j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004`\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0002j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0003`\u0006H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J8\u0010\u0012\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0002j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004`\u0006H\u00c7\u0003\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c7\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014JR\u0010\u0015\u001a\u00020\u000020\b\u0002\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0002j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004`\u00062\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c7\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u0011J\u0010\u0010\u001d\u001a\u00020\u001cH\u00d7\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eRB\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0002j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004`\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001f\u001a\u0004\b \u0010\u000eR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010!\u001a\u0004\b\"\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ArgumentMapping;", "", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "Lkotlin/collections/LinkedHashMap;", "parameterToCallArgumentMap", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "diagnostics", "<init>", "(Ljava/util/LinkedHashMap;Ljava/util/List;)V", "toArgumentToParameterMapping", "()Ljava/util/LinkedHashMap;", "", "numDefaults", "()I", "component1", "component2", "()Ljava/util/List;", "copy", "(Ljava/util/LinkedHashMap;Ljava/util/List;)Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ArgumentMapping;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Ljava/util/LinkedHashMap;", "getParameterToCallArgumentMap", "Ljava/util/List;", "getDiagnostics"})
public final class ArgumentMapping {
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> parameterToCallArgumentMap;
    @NotNull
    private final List<ResolutionDiagnostic> diagnostics;

    public ArgumentMapping(@NotNull LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> parameterToCallArgumentMap, @NotNull List<? extends ResolutionDiagnostic> diagnostics) {
        Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, "parameterToCallArgumentMap");
        Intrinsics.checkNotNullParameter(diagnostics, "diagnostics");
        this.parameterToCallArgumentMap = parameterToCallArgumentMap;
        this.diagnostics = diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> getParameterToCallArgumentMap() {
        return this.parameterToCallArgumentMap;
    }

    @NotNull
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<ConeResolutionAtom, FirValueParameter> toArgumentToParameterMapping() {
        LinkedHashMap<ConeResolutionAtom, FirValueParameter> argumentToParameterMapping = new LinkedHashMap<ConeResolutionAtom, FirValueParameter>();
        Map $this$forEach$iv = this.parameterToCallArgumentMap;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            FirValueParameter valueParameter2 = (FirValueParameter)entry.getKey();
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)entry.getValue();
            ResolvedCallArgument resolvedCallArgument = resolvedArgument;
            if (resolvedCallArgument instanceof ResolvedCallArgument.SimpleArgument) {
                ((Map)argumentToParameterMapping).put(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument(), valueParameter2);
                continue;
            }
            if (resolvedCallArgument instanceof ResolvedCallArgument.VarargArgument) {
                Iterable $this$forEach$iv2 = ((ResolvedCallArgument.VarargArgument)resolvedArgument).getArguments();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    ConeResolutionAtom it = (ConeResolutionAtom)element$iv2;
                    boolean bl2 = false;
                    ((Map)argumentToParameterMapping).put(it, valueParameter2);
                }
                continue;
            }
            if (Intrinsics.areEqual(resolvedCallArgument, ResolvedCallArgument.DefaultArgument.INSTANCE)) continue;
            throw new NoWhenBranchMatchedException();
        }
        return argumentToParameterMapping;
    }

    /*
     * WARNING - void declaration
     */
    public final int numDefaults() {
        int n;
        Collection<ResolvedCallArgument<ConeResolutionAtom>> collection = this.parameterToCallArgumentMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ResolvedCallArgument it = (ResolvedCallArgument)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it, ResolvedCallArgument.DefaultArgument.INSTANCE) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> component1() {
        return this.parameterToCallArgumentMap;
    }

    @NotNull
    public final List<ResolutionDiagnostic> component2() {
        return this.diagnostics;
    }

    @NotNull
    public final ArgumentMapping copy(@NotNull LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> parameterToCallArgumentMap, @NotNull List<? extends ResolutionDiagnostic> diagnostics) {
        Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, "parameterToCallArgumentMap");
        Intrinsics.checkNotNullParameter(diagnostics, "diagnostics");
        return new ArgumentMapping(parameterToCallArgumentMap, diagnostics);
    }

    public static /* synthetic */ ArgumentMapping copy$default(ArgumentMapping argumentMapping2, LinkedHashMap linkedHashMap, List list, int n, Object object) {
        if ((n & 1) != 0) {
            linkedHashMap = argumentMapping2.parameterToCallArgumentMap;
        }
        if ((n & 2) != 0) {
            list = argumentMapping2.diagnostics;
        }
        return argumentMapping2.copy(linkedHashMap, list);
    }

    @NotNull
    public String toString() {
        return "ArgumentMapping(parameterToCallArgumentMap=" + this.parameterToCallArgumentMap + ", diagnostics=" + this.diagnostics + ')';
    }

    public int hashCode() {
        int result2 = this.parameterToCallArgumentMap.hashCode();
        result2 = result2 * 31 + ((Object)this.diagnostics).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArgumentMapping)) {
            return false;
        }
        ArgumentMapping argumentMapping2 = (ArgumentMapping)other;
        if (!Intrinsics.areEqual(this.parameterToCallArgumentMap, argumentMapping2.parameterToCallArgumentMap)) {
            return false;
        }
        return Intrinsics.areEqual(this.diagnostics, argumentMapping2.diagnostics);
    }
}

