/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.DoubleColonLHS;
import org.jetbrains.kotlin.fir.resolve.calls.AdaptedCallableReferenceIsUsedWithReflection;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceAdaptation;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.LowerPriorityToPreserveCompatibilityDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallableReferenceInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.CheckCallableReferenceExpectedTypeKt;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeArgumentConstraintPosition;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirErrorCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0097@\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CheckCallableReferenceExpectedType;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;"})
public final class CheckCallableReferenceExpectedType
extends ResolutionStage {
    @NotNull
    public static final CheckCallableReferenceExpectedType INSTANCE = new CheckCallableReferenceExpectedType();

    private CheckCallableReferenceExpectedType() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context, @NotNull Continuation<? super Unit> $completion) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNull(callInfo, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.calls.candidate.CallableReferenceInfo");
        CallableReferenceInfo cfr_ignored_0 = (CallableReferenceInfo)callInfo;
        ConeKotlinType expectedType = ((CallableReferenceInfo)callInfo).getExpectedType();
        if (!(candidate.getSymbol() instanceof FirCallableSymbol)) {
            return Unit.INSTANCE;
        }
        if (((CallableReferenceInfo)callInfo).getLhs() instanceof DoubleColonLHS.Type) {
            ConeKotlinType coneKotlinType2;
            ConeKotlinType it = coneKotlinType2 = ((DoubleColonLHS.Type)((CallableReferenceInfo)callInfo).getLhs()).getType();
            boolean bl = false;
            FirExpression firExpression = callInfo.getExplicitReceiver();
            coneKotlinType = !((firExpression != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null) instanceof FirResolvedQualifier) ? coneKotlinType2 : null;
        } else {
            coneKotlinType = null;
        }
        ConeKotlinType resultingReceiverType = coneKotlinType;
        Object obj = candidate.getSymbol().getFir();
        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration");
        FirCallableDeclaration fir = (FirCallableDeclaration)obj;
        ConeKotlinType coneKotlinType3 = ((CallableReferenceInfo)callInfo).getExpectedType();
        boolean isExpectedTypeReflectionType = coneKotlinType3 != null ? FunctionalTypeUtilsKt.isReflectFunctionType(coneKotlinType3, callInfo.getSession()) : false;
        Pair pair = CheckCallableReferenceExpectedTypeKt.access$buildResultingTypeAndAdaptation(fir, resultingReceiverType, candidate, context, isExpectedTypeReflectionType);
        ConeKotlinType rawResultingType = (ConeKotlinType)pair.component1();
        CallableReferenceAdaptation callableReferenceAdaptation = (CallableReferenceAdaptation)pair.component2();
        if (callableReferenceAdaptation != null) {
            if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.DisableCompatibilityModeForNewInference)) {
                sink.reportDiagnostic(LowerPriorityToPreserveCompatibilityDiagnostic.INSTANCE);
            }
            if (isExpectedTypeReflectionType) {
                sink.reportDiagnostic(AdaptedCallableReferenceIsUsedWithReflection.INSTANCE);
            }
        }
        ConeKotlinType resultingType = candidate.getSubstitutor().substituteOrSelf(rawResultingType);
        candidate.initializeCallableReferenceAdaptation$resolve(callableReferenceAdaptation, resultingType);
        if (expectedType != null && !(candidate.getSymbol() instanceof FirErrorCallableSymbol)) {
            candidate.getSystem().addSubtypeConstraint(resultingType, expectedType, new ConeArgumentConstraintPosition(callInfo.getCallSite()));
        }
        if (candidate.getSystem().getHasContradiction()) {
            void $this$yieldDiagnostic$iv;
            CheckerSink checkerSink = sink;
            ResolutionDiagnostic diagnostic$iv = InapplicableCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

