/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.CallToPotentiallyHiddenSymbolResult;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.resolve.calls.CallToDeprecatedOverrideOfHidden;
import org.jetbrains.kotlin.fir.resolve.calls.FirSimpleSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.resolve.calls.HiddenCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.SyntheticsKt;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0097@\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0011\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J;\u0010\u0017\u001a\u00020\u00102\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CheckHiddenDeclaration;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "", "isDeprecatedHidden", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;)Z", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "symbol", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "isHiddenForThisCallSite", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;)Z"})
public final class CheckHiddenDeclaration
extends ResolutionStage {
    @NotNull
    public static final CheckHiddenDeclaration INSTANCE = new CheckHiddenDeclaration();

    private CheckHiddenDeclaration() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context, @NotNull Continuation<? super Unit> $completion) {
        block8: {
            void $this$yieldDiagnostic$iv;
            block6: {
                FirCallableSymbol symbol;
                block7: {
                    FirBasedSymbol<?> firBasedSymbol = candidate.getSymbol();
                    FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
                    if (firCallableSymbol == null) {
                        return Unit.INSTANCE;
                    }
                    symbol = firCallableSymbol;
                    if (this.isDeprecatedHidden(symbol, context, callInfo)) break block6;
                    if (!(symbol instanceof FirConstructorSymbol)) break block7;
                    FirTypeAliasSymbol firTypeAliasSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirFunctionSymbol)symbol);
                    if (firTypeAliasSymbol != null ? this.isDeprecatedHidden(firTypeAliasSymbol, context, callInfo) : false) break block6;
                }
                if (!this.isHiddenForThisCallSite(symbol, callInfo, candidate, context.getSession(), sink)) break block8;
            }
            CheckerSink checkerSink = sink;
            ResolutionDiagnostic diagnostic$iv = HiddenCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final boolean isDeprecatedHidden(FirBasedSymbol<?> $this$isDeprecatedHidden, ResolutionContext context, CallInfo callInfo) {
        FirDeprecationInfo deprecation;
        FirDeprecationInfo firDeprecationInfo = deprecation = DeprecationUtilsKt.getDeprecation($this$isDeprecatedHidden, context.getSession(), callInfo.getCallSite());
        return (firDeprecationInfo != null ? firDeprecationInfo.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN;
    }

    private final boolean isHiddenForThisCallSite(FirCallableSymbol<?> symbol, CallInfo callInfo, Candidate candidate, FirSession session, CheckerSink sink) {
        if (symbol instanceof FirSimpleSyntheticPropertySymbol && SyntheticsKt.getDeprecatedOverrideOfHidden((FirSimpleSyntheticPropertySymbol)symbol)) {
            sink.reportDiagnostic(CallToDeprecatedOverrideOfHidden.INSTANCE);
        }
        if (((FirCallableDeclaration)symbol.getFir()).getDispatchReceiverType() == null || !(symbol instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        boolean isSuperCall = ResolutionStagesKt.isSuperCall(callInfo.getCallSite(), session);
        if (DeprecationUtilsKt.hiddenStatusOfCall(symbol, isSuperCall, false) == CallToPotentiallyHiddenSymbolResult.Hidden) {
            return true;
        }
        FirScope firScope = candidate.getOriginScope();
        FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
        if (firTypeScope == null) {
            return false;
        }
        FirTypeScope scope2 = firTypeScope;
        Ref.BooleanRef hidden = new Ref.BooleanRef();
        Ref.BooleanRef deprecated = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(scope2, (FirNamedFunctionSymbol)symbol, arg_0 -> CheckHiddenDeclaration.isHiddenForThisCallSite$lambda$0(isSuperCall, hidden, deprecated, arg_0));
        if (deprecated.element) {
            sink.reportDiagnostic(CallToDeprecatedOverrideOfHidden.INSTANCE);
        }
        return hidden.element;
    }

    private static final ProcessorAction isHiddenForThisCallSite$lambda$0(boolean $isSuperCall, Ref.BooleanRef $hidden, Ref.BooleanRef $deprecated, FirNamedFunctionSymbol it) {
        ProcessorAction processorAction;
        Intrinsics.checkNotNullParameter(it, "it");
        CallToPotentiallyHiddenSymbolResult result2 = DeprecationUtilsKt.hiddenStatusOfCall(it, $isSuperCall, true);
        if (result2 != CallToPotentiallyHiddenSymbolResult.Visible) {
            if (result2 == CallToPotentiallyHiddenSymbolResult.Hidden) {
                $hidden.element = true;
            } else if (result2 == CallToPotentiallyHiddenSymbolResult.VisibleWithDeprecation) {
                $deprecated.element = true;
            }
            processorAction = ProcessorAction.STOP;
        } else {
            processorAction = ProcessorAction.NEXT;
        }
        return processorAction;
    }
}

