/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.FirDefaultParametersResolverKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentPassedTwice;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtomWithSingleChild;
import org.jetbrains.kotlin.fir.resolve.calls.ManyLambdaExpressionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.fir.resolve.calls.NameForAmbiguousParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NameNotFound;
import org.jetbrains.kotlin.fir.resolve.calls.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.fir.resolve.calls.NoValueForParameter;
import org.jetbrains.kotlin.fir.resolve.calls.NonVarargSpread;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallArgument;
import org.jetbrains.kotlin.fir.resolve.calls.TooManyArguments;
import org.jetbrains.kotlin.fir.resolve.calls.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ParameterNameTypeAttributeKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.ForbiddenNamedArgumentsTarget;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001_B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0012\u001a\u00020\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u001f\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001f\u0010 J\u001b\u0010\"\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\"\u0010\u0013J\r\u0010#\u001a\u00020\u0011\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b%\u0010$J\u0017\u0010&\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b&\u0010 J\u0019\u0010*\u001a\u0004\u0018\u00010)2\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b*\u0010+J\u0019\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010\u0018\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b,\u0010-J\u0017\u00100\u001a\u00020\u00112\u0006\u0010/\u001a\u00020.H\u0002\u00a2\u0006\u0004\b0\u00101R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00102R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00103R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00104R\u0016\u0010\t\u001a\u0004\u0018\u00010\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00105R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u00106R\u0016\u00108\u001a\u0002078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0016\u0010;\u001a\u00020:8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u001e\u0010>\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010=8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R$\u0010A\u001a\u0010\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020)\u0018\u00010@8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u001e\u0010D\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010C8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020'0C8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR4\u0010J\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010=2\u000e\u0010I\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010=8\u0007@BX\u0087\u000e\u00a2\u0006\f\n\u0004\bJ\u0010?\u001a\u0004\bK\u0010LRB\u0010P\u001a*\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0N0Mj\u0014\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0N`O8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010SR\u001d\u0010Y\u001a\u0004\u0018\u00010T8GX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\bU\u0010V\u001a\u0004\bW\u0010XR\u0018\u0010[\u001a\u00020\n*\u00020Z8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u001a\u0010^\u001a\b\u0012\u0004\u0012\u00020)0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010L"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor;", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "function", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "originScope", "", "isIndexedSetOperator", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;Z)V", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "arguments", "", "processNonLambdaArguments", "(Ljava/util/List;)V", "atom", "isLastArgument", "processNonLambdaArgument", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;Z)V", "argument", "processPositionArgument", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtomWithSingleChild;", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "processNamedArgument", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtomWithSingleChild;Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;)V", "externalArgument", "processExternalArgument", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;)V", "excessLambdaArguments", "processExcessLambdaArguments", "processDefaultsAndRunChecks", "()V", "completeVarargPositionArguments", "addVarargArgument", "Lorg/jetbrains/kotlin/name/Name;", "name", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getParameterByName", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "findParameterByName", "(Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;)Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;", "diagnostic", "addDiagnostic", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionDiagnostic;)V", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "Z", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor$State;", "state", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor$State;", "", "currentPositionedParameterIndex", "I", "", "varargArguments", "Ljava/util/List;", "", "nameToParameter", "Ljava/util/Map;", "", "namedDynamicArgumentsNamesImpl", "Ljava/util/Set;", "getNamedDynamicArgumentsNames", "()Ljava/util/Set;", "namedDynamicArgumentsNames", "value", "diagnostics", "getDiagnostics", "()Ljava/util/List;", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallArgument;", "Lkotlin/collections/LinkedHashMap;", "result", "Ljava/util/LinkedHashMap;", "getResult", "()Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "forbiddenNamedArgumentsTarget$delegate", "Lkotlin/Lazy;", "getForbiddenNamedArgumentsTarget", "()Lorg/jetbrains/kotlin/resolve/ForbiddenNamedArgumentsTarget;", "forbiddenNamedArgumentsTarget", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isSpread", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "getParameters", "parameters", "State"})
final class FirCallArgumentsProcessor {
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final FirFunction function;
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @Nullable
    private final FirScope originScope;
    private final boolean isIndexedSetOperator;
    @NotNull
    private State state;
    private int currentPositionedParameterIndex;
    @Nullable
    private List<ConeResolutionAtom> varargArguments;
    @Nullable
    private Map<Name, ? extends FirValueParameter> nameToParameter;
    @Nullable
    private Set<Name> namedDynamicArgumentsNamesImpl;
    @Nullable
    private List<ResolutionDiagnostic> diagnostics;
    @NotNull
    private final LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> result;
    @NotNull
    private final Lazy forbiddenNamedArgumentsTarget$delegate;

    public FirCallArgumentsProcessor(@NotNull FirSession useSiteSession, @NotNull FirFunction function2, @NotNull BodyResolveComponents bodyResolveComponents2, @Nullable FirScope originScope, boolean isIndexedSetOperator) {
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(bodyResolveComponents2, "bodyResolveComponents");
        this.useSiteSession = useSiteSession;
        this.function = function2;
        this.bodyResolveComponents = bodyResolveComponents2;
        this.originScope = originScope;
        this.isIndexedSetOperator = isIndexedSetOperator;
        this.state = State.POSITION_ARGUMENTS;
        this.result = new LinkedHashMap(this.function.getValueParameters().size());
        this.forbiddenNamedArgumentsTarget$delegate = LazyKt.lazy(() -> FirCallArgumentsProcessor.forbiddenNamedArgumentsTarget_delegate$lambda$1(this));
    }

    private final Set<Name> getNamedDynamicArgumentsNames() {
        Set set = this.namedDynamicArgumentsNamesImpl;
        if (set == null) {
            Set set2;
            Set it = set2 = (Set)new LinkedHashSet();
            boolean bl = false;
            this.namedDynamicArgumentsNamesImpl = it;
            set = set2;
        }
        return set;
    }

    @Nullable
    public final List<ResolutionDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final LinkedHashMap<FirValueParameter, ResolvedCallArgument<ConeResolutionAtom>> getResult() {
        return this.result;
    }

    @Nullable
    public final ForbiddenNamedArgumentsTarget getForbiddenNamedArgumentsTarget() {
        Lazy lazy = this.forbiddenNamedArgumentsTarget$delegate;
        return (ForbiddenNamedArgumentsTarget)((Object)lazy.getValue());
    }

    public final void processNonLambdaArguments(@NotNull List<? extends ConeResolutionAtom> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Iterator iterator2 = ((Iterable)arguments2).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int argumentIndex = n++;
            ConeResolutionAtom argument = (ConeResolutionAtom)iterator2.next();
            this.processNonLambdaArgument(argument, argumentIndex == CollectionsKt.getLastIndex(arguments2));
        }
        if (this.state == State.VARARG_POSITION) {
            this.completeVarargPositionArguments();
        }
    }

    private final void processNonLambdaArgument(ConeResolutionAtom atom, boolean isLastArgument) {
        FirExpression argument = atom.getExpression();
        if (!(argument instanceof FirNamedArgumentExpression)) {
            if (this.state == State.VARARG_POSITION && this.isIndexedSetOperator && isLastArgument) {
                this.completeVarargPositionArguments();
            }
            this.processPositionArgument(atom, isLastArgument);
            return;
        }
        if (!(atom instanceof ConeResolutionAtomWithSingleChild)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (((ConeResolutionAtomWithSingleChild)atom).getSubAtom() == null) {
            boolean bl = false;
            String string3 = "SubAtom of named argument is null";
            throw new IllegalArgumentException(string3.toString());
        }
        if (Intrinsics.areEqual(this.function.getOrigin(), FirDeclarationOrigin.DynamicScope.INSTANCE)) {
            this.processPositionArgument(((ConeResolutionAtomWithSingleChild)atom).getSubAtom(), isLastArgument);
            if (!this.getNamedDynamicArgumentsNames().add(((FirNamedArgumentExpression)argument).getName())) {
                this.addDiagnostic(new ArgumentPassedTwice((FirNamedArgumentExpression)argument));
            }
        } else {
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
            this.processNamedArgument((ConeResolutionAtomWithSingleChild)atom, (FirNamedArgumentExpression)argument);
        }
    }

    private final void processPositionArgument(ConeResolutionAtom argument, boolean isLastArgument) {
        int n;
        if (this.state == State.NAMED_ONLY_ARGUMENTS) {
            this.addDiagnostic(new MixingNamedAndPositionArguments(argument.getExpression()));
            return;
        }
        if (this.isIndexedSetOperator) {
            int lastParameterIndex = CollectionsKt.getLastIndex(this.getParameters());
            n = isLastArgument ? lastParameterIndex : (this.currentPositionedParameterIndex >= lastParameterIndex ? -1 : this.currentPositionedParameterIndex);
        } else {
            n = this.currentPositionedParameterIndex;
        }
        int assignedParameterIndex = n;
        FirValueParameter parameter = CollectionsKt.getOrNull(this.getParameters(), assignedParameterIndex);
        if (parameter == null) {
            this.addDiagnostic(new TooManyArguments(argument.getExpression(), this.function));
            return;
        }
        if (!parameter.isVararg()) {
            int n2 = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n2 + 1;
            ((Map)this.result).put(parameter, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtom>(argument));
            this.state = State.POSITION_ARGUMENTS;
        } else {
            this.addVarargArgument(argument);
            this.state = State.VARARG_POSITION;
        }
    }

    private final void processNamedArgument(ConeResolutionAtomWithSingleChild atom, FirNamedArgumentExpression argument) {
        ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget = this.getForbiddenNamedArgumentsTarget();
        if (forbiddenNamedArgumentsTarget != null) {
            ForbiddenNamedArgumentsTarget it = forbiddenNamedArgumentsTarget;
            boolean bl = false;
            this.addDiagnostic(new NamedArgumentNotAllowed(atom.getExpression(), this.function, it));
        }
        boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
        this.state = State.NAMED_ONLY_ARGUMENTS;
        FirValueParameter firValueParameter = this.findParameterByName(argument);
        if (firValueParameter == null) {
            return;
        }
        FirValueParameter parameter = firValueParameter;
        ResolvedCallArgument<ConeResolutionAtom> resolvedCallArgument = this.result.get(parameter);
        if (resolvedCallArgument != null) {
            ResolvedCallArgument<ConeResolutionAtom> it = resolvedCallArgument;
            boolean bl = false;
            this.addDiagnostic(new ArgumentPassedTwice(argument));
            return;
        }
        ((Map)this.result).put(parameter, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtomWithSingleChild>(atom));
        if (stateAllowsMixedNamedAndPositionArguments && Intrinsics.areEqual(CollectionsKt.getOrNull(this.getParameters(), this.currentPositionedParameterIndex), parameter)) {
            this.state = State.POSITION_ARGUMENTS;
            int n = this.currentPositionedParameterIndex;
            this.currentPositionedParameterIndex = n + 1;
        }
    }

    public final void processExternalArgument(@NotNull ConeResolutionAtom externalArgument) {
        Intrinsics.checkNotNullParameter(externalArgument, "externalArgument");
        FirExpression argumentExpression = externalArgument.getExpression();
        FirValueParameter lastParameter = CollectionsKt.lastOrNull(this.getParameters());
        if (lastParameter == null) {
            this.addDiagnostic(new TooManyArguments(argumentExpression, this.function));
            return;
        }
        if (!Intrinsics.areEqual(this.function.getOrigin(), FirDeclarationOrigin.DynamicScope.INSTANCE)) {
            if (lastParameter.isVararg()) {
                this.addDiagnostic(new VarargArgumentOutsideParentheses(argumentExpression, lastParameter));
                return;
            }
            ResolvedCallArgument<ConeResolutionAtom> previousOccurrence = this.result.get(lastParameter);
            if (previousOccurrence != null) {
                this.addDiagnostic(new TooManyArguments(argumentExpression, this.function));
                return;
            }
            ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtom>(externalArgument));
        } else {
            ResolvedCallArgument<ConeResolutionAtom> existing = this.result.get(lastParameter);
            if (existing == null) {
                ((Map)this.result).put(lastParameter, new ResolvedCallArgument.SimpleArgument<ConeResolutionAtom>(externalArgument));
            } else {
                ((Map)this.result).put(lastParameter, new ResolvedCallArgument.VarargArgument<ConeResolutionAtom>(CollectionsKt.plus((Collection)existing.getArguments(), externalArgument)));
            }
        }
    }

    public final void processExcessLambdaArguments(@NotNull List<? extends ConeResolutionAtom> excessLambdaArguments) {
        Intrinsics.checkNotNullParameter(excessLambdaArguments, "excessLambdaArguments");
        Iterable $this$forEach$iv = excessLambdaArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeResolutionAtom arg = (ConeResolutionAtom)element$iv;
            boolean bl = false;
            this.addDiagnostic(new ManyLambdaExpressionArguments(arg.getExpression()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processDefaultsAndRunChecks() {
        for (Map.Entry entry : ((Map)this.result).entrySet()) {
            FirValueParameter parameter = (FirValueParameter)entry.getKey();
            ResolvedCallArgument resolvedArgument = (ResolvedCallArgument)entry.getValue();
            if (parameter.isVararg()) continue;
            if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                String message$iv = "Incorrect resolved argument for parameter " + parameter.getClass() + ": " + resolvedArgument.getClass();
                Throwable cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string2 = attachmentName$iv;
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
                boolean bl = false;
                void $this$processDefaultsAndRunChecks_u24lambda_u247 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl2 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$processDefaultsAndRunChecks_u24lambda_u247, "parameter", parameter);
                $this$processDefaultsAndRunChecks_u24lambda_u247.withEntryGroup("arguments", arg_0 -> FirCallArgumentsProcessor.processDefaultsAndRunChecks$lambda$7$lambda$6(resolvedArgument, arg_0));
                kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            if (!this.isSpread(((ConeResolutionAtom)((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()).getExpression())) continue;
            this.addDiagnostic(new NonVarargSpread(((ConeResolutionAtom)((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()).getExpression()));
        }
        Iterator iterator2 = ((Iterable)this.getParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            FirValueParameter parameter = (FirValueParameter)((Object)iterator2.next());
            if (this.result.containsKey(parameter)) continue;
            if (FirDefaultParametersResolverKt.getDefaultParameterResolver(this.bodyResolveComponents.getSession()).declaresDefaultValue(this.useSiteSession, this.bodyResolveComponents.getScopeSession(), this.function, this.originScope, index2)) {
                ((Map)this.result).put(parameter, ResolvedCallArgument.DefaultArgument.INSTANCE);
                continue;
            }
            if (parameter.isVararg()) {
                ((Map)this.result).put(parameter, new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList()));
                continue;
            }
            this.addDiagnostic(new NoValueForParameter(parameter, this.function));
        }
    }

    private final void completeVarargPositionArguments() {
        boolean bl;
        boolean bl2 = bl = this.state == State.VARARG_POSITION;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Incorrect state: " + (Object)((Object)this.state);
            throw new AssertionError((Object)string2);
        }
        FirValueParameter parameter = this.getParameters().get(this.currentPositionedParameterIndex);
        Map map2 = this.result;
        List<ConeResolutionAtom> list = this.varargArguments;
        Intrinsics.checkNotNull(list);
        map2.put(parameter, new ResolvedCallArgument.VarargArgument<ConeResolutionAtom>(list));
    }

    private final void addVarargArgument(ConeResolutionAtom argument) {
        if (this.varargArguments == null) {
            this.varargArguments = new ArrayList();
        }
        List<ConeResolutionAtom> list = this.varargArguments;
        Intrinsics.checkNotNull(list);
        list.add(argument);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter getParameterByName(Name name) {
        block8: {
            void $this$associateByTo$iv;
            block9: {
                FirNamedFunctionSymbol symbol;
                if (this.nameToParameter != null) break block8;
                if (!ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden(this.function) || this.getForbiddenNamedArgumentsTarget() != null) break block9;
                FirFunctionSymbol<FirFunction> firFunctionSymbol = this.function.getSymbol();
                FirNamedFunctionSymbol firNamedFunctionSymbol = symbol = firFunctionSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firFunctionSymbol : null;
                if (symbol != null) {
                    FirScope firScope = this.originScope;
                    FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                    if (firTypeScope != null) {
                        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol, arg_0 -> FirCallArgumentsProcessor.getParameterByName$lambda$10(this, arg_0));
                    }
                }
                if (this.nameToParameter == null) {
                    this.nameToParameter = MapsKt.emptyMap();
                }
                break block8;
            }
            Iterable symbol = this.getParameters();
            Map map2 = new LinkedHashMap();
            FirCallArgumentsProcessor firCallArgumentsProcessor = this;
            boolean $i$f$associateByTo = false;
            for (Object element$iv : $this$associateByTo$iv) {
                Object object;
                void var14_17;
                block11: {
                    void parameter;
                    block10: {
                        FirAnnotation annotation;
                        void destination$iv;
                        FirValueParameter firValueParameter = (FirValueParameter)element$iv;
                        var14_17 = destination$iv;
                        boolean bl = false;
                        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(parameter.getReturnTypeRef());
                        FirAnnotation firAnnotation = annotation = coneKotlinType != null ? ParameterNameTypeAttributeKt.getParameterNameAnnotation(coneKotlinType) : null;
                        String argument = firAnnotation != null ? FirAnnotationUtilsKt.getStringArgument(firAnnotation, StandardNames.NAME, this.useSiteSession) : null;
                        object = argument;
                        if (object == null) break block10;
                        String it = object;
                        boolean bl2 = false;
                        Name name2 = Name.identifier(it);
                        object = name2;
                        if (name2 != null) break block11;
                    }
                    object = parameter.getName();
                }
                var14_17.put(object, element$iv);
            }
            firCallArgumentsProcessor.nameToParameter = map2;
        }
        Map<Name, ? extends FirValueParameter> map3 = this.nameToParameter;
        Intrinsics.checkNotNull(map3);
        return map3.get(name);
    }

    /*
     * WARNING - void declaration
     */
    private final FirValueParameter findParameterByName(FirNamedArgumentExpression argument) {
        Ref.ObjectRef parameter;
        block9: {
            int n;
            int n2;
            Ref.IntRef matchedIndex;
            FirNamedFunctionSymbol symbol;
            block7: {
                void $this$indexOfFirst$iv;
                block8: {
                    parameter = new Ref.ObjectRef();
                    parameter.element = this.getParameterByName(argument.getName());
                    FirFunctionSymbol<FirFunction> firFunctionSymbol = this.function.getSymbol();
                    symbol = firFunctionSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firFunctionSymbol : null;
                    matchedIndex = new Ref.IntRef();
                    matchedIndex.element = -1;
                    if (parameter.element != null) break block8;
                    if (symbol != null && (ClassMembersKt.isSubstitutionOrIntersectionOverride(this.function) || DeclarationUtilsKt.isJavaOrEnhancement(this.function))) {
                        Ref.ObjectRef allowedParameters = new Ref.ObjectRef();
                        FirScope firScope = this.originScope;
                        FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                        if (firTypeScope != null) {
                            FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol, arg_0 -> FirCallArgumentsProcessor.findParameterByName$lambda$14(matchedIndex, parameter, this, allowedParameters, argument, arg_0));
                        }
                    }
                    if (parameter.element != null) break block9;
                    this.addDiagnostic(new NameNotFound(argument, this.function));
                    break block9;
                }
                if (symbol == null || !ClassMembersKt.isSubstitutionOrIntersectionOverride(this.function) && !DeclarationUtilsKt.isJavaOrEnhancement(this.function)) break block9;
                Map<Name, ? extends FirValueParameter> map2 = this.nameToParameter;
                Intrinsics.checkNotNull(map2);
                Iterable allowedParameters = map2.entrySet();
                Ref.IntRef intRef = matchedIndex;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    if (index$iv < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Map.Entry it = (Map.Entry)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual(it.getKey(), argument.getName())) {
                        n2 = index$iv;
                        break block7;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            intRef.element = n = n2;
            if (matchedIndex.element != -1) {
                FirScope firScope = this.originScope;
                FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
                if (firTypeScope != null) {
                    FirTypeScopeKt.processOverriddenFunctions(firTypeScope, symbol, arg_0 -> FirCallArgumentsProcessor.findParameterByName$lambda$16(matchedIndex, argument, this, arg_0));
                }
            }
        }
        return (FirValueParameter)parameter.element;
    }

    private final void addDiagnostic(ResolutionDiagnostic diagnostic) {
        if (this.diagnostics == null) {
            this.diagnostics = new ArrayList();
        }
        List<ResolutionDiagnostic> list = this.diagnostics;
        Intrinsics.checkNotNull(list);
        list.add(diagnostic);
    }

    private final boolean isSpread(FirExpression $this$isSpread) {
        return $this$isSpread instanceof FirWrappedArgumentExpression ? ((FirWrappedArgumentExpression)$this$isSpread).isSpread() : false;
    }

    private final List<FirValueParameter> getParameters() {
        return this.function.getValueParameters();
    }

    private static final ForbiddenNamedArgumentsTarget forbiddenNamedArgumentsTarget_delegate$lambda$1(FirCallArgumentsProcessor this$0) {
        FirScope firScope = this$0.originScope;
        return ResolveUtilsKt.forbiddenNamedArgumentsTargetOrNull(this$0.function, firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null);
    }

    private static final Unit processDefaultsAndRunChecks$lambda$7$lambda$6(ResolvedCallArgument $resolvedArgument, ExceptionAttachmentBuilder $this$withEntryGroup) {
        Intrinsics.checkNotNullParameter($this$withEntryGroup, "$this$withEntryGroup");
        Iterator iterator2 = ((Iterable)$resolvedArgument.getArguments()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            ConeResolutionAtom argument = (ConeResolutionAtom)iterator2.next();
            FirExceptionUtilsKt.withFirEntry($this$withEntryGroup, "argument" + index2, argument.getExpression());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final ProcessorAction getParameterByName$lambda$10(FirCallArgumentsProcessor this$0, FirNamedFunctionSymbol overrideSymbol) {
        void $this$associateTo$iv;
        Intrinsics.checkNotNullParameter(overrideSymbol, "overrideSymbol");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)overrideSymbol.getFir())) {
            return ProcessorAction.NEXT;
        }
        Iterable iterable = CollectionsKt.withIndex((Iterable)this$0.getParameters());
        Map map2 = new LinkedHashMap();
        FirCallArgumentsProcessor firCallArgumentsProcessor = this$0;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            void destination$iv;
            void var7_8 = destination$iv;
            Object object = (IndexedValue)element$iv;
            boolean bl = false;
            int i = ((IndexedValue)object).component1();
            FirValueParameter p = (FirValueParameter)((IndexedValue)object).component2();
            object = TuplesKt.to(((FirSimpleFunction)overrideSymbol.getFir()).getValueParameters().get(i).getName(), p);
            var7_8.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
        }
        firCallArgumentsProcessor.nameToParameter = map2;
        return ProcessorAction.STOP;
    }

    private static final ProcessorAction findParameterByName$findAndReportValueParameterWithDifferentName(List<FirValueParameterSymbol> $this$findParameterByName_u24findAndReportValueParameterWithDifferentName, Ref.IntRef matchedIndex, FirNamedArgumentExpression $argument, FirCallArgumentsProcessor this$0) {
        Name someName;
        FirValueParameter someParameter;
        FirValueParameterSymbol firValueParameterSymbol = CollectionsKt.getOrNull($this$findParameterByName_u24findAndReportValueParameterWithDifferentName, matchedIndex.element);
        FirValueParameter firValueParameter = someParameter = firValueParameterSymbol != null ? (FirValueParameter)firValueParameterSymbol.getFir() : null;
        Name name = someName = firValueParameter != null ? firValueParameter.getName() : null;
        if (someName != null && !Intrinsics.areEqual(someName, $argument.getName())) {
            this$0.addDiagnostic(new NameForAmbiguousParameter($argument));
            return ProcessorAction.STOP;
        }
        return ProcessorAction.NEXT;
    }

    /*
     * WARNING - void declaration
     */
    private static final ProcessorAction findParameterByName$lambda$14(Ref.IntRef $matchedIndex, Ref.ObjectRef $parameter, FirCallArgumentsProcessor this$0, Ref.ObjectRef $allowedParameters, FirNamedArgumentExpression $argument, FirNamedFunctionSymbol it) {
        ProcessorAction processorAction;
        Intrinsics.checkNotNullParameter(it, "it");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)it.getFir())) {
            return ProcessorAction.NEXT;
        }
        List<FirValueParameterSymbol> someParameterSymbols = it.getValueParameterSymbols();
        if ($matchedIndex.element != -1) {
            processorAction = FirCallArgumentsProcessor.findParameterByName$findAndReportValueParameterWithDifferentName(someParameterSymbols, $matchedIndex, $argument, this$0);
        } else {
            int n;
            int n2;
            block9: {
                void $this$indexOfFirst$iv;
                List<FirValueParameterSymbol> list = someParameterSymbols;
                Ref.IntRef intRef = $matchedIndex;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    FirValueParameterSymbol originalParameter = (FirValueParameterSymbol)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual(originalParameter.getName(), $argument.getName())) {
                        n2 = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            intRef.element = n = n2;
            if ($matchedIndex.element != -1) {
                FirValueParameter someParameter;
                $parameter.element = this$0.getParameters().get($matchedIndex.element);
                Object object = (List)$allowedParameters.element;
                FirValueParameter firValueParameter = object != null && (object = (FirValueParameterSymbol)CollectionsKt.getOrNull(object, $matchedIndex.element)) != null ? (FirValueParameter)((FirBasedSymbol)object).getFir() : (someParameter = null);
                if (someParameter != null) {
                    this$0.addDiagnostic(new NameForAmbiguousParameter($argument));
                    processorAction = ProcessorAction.STOP;
                } else {
                    processorAction = ProcessorAction.NEXT;
                }
            } else {
                $allowedParameters.element = someParameterSymbols;
                processorAction = ProcessorAction.NEXT;
            }
        }
        return processorAction;
    }

    private static final ProcessorAction findParameterByName$lambda$16(Ref.IntRef $matchedIndex, FirNamedArgumentExpression $argument, FirCallArgumentsProcessor this$0, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (ResolveUtilsKt.areNamedArgumentsForbiddenIgnoringOverridden((FirFunction)it.getFir())) {
            return ProcessorAction.NEXT;
        }
        return FirCallArgumentsProcessor.findParameterByName$findAndReportValueParameterWithDifferentName(it.getValueParameterSymbols(), $matchedIndex, $argument, this$0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/FirCallArgumentsProcessor$State;", "", "<init>", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State POSITION_ARGUMENTS = new State();
        public static final /* enum */ State VARARG_POSITION = new State();
        public static final /* enum */ State NAMED_ONLY_ARGUMENTS = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.POSITION_ARGUMENTS, State.VARARG_POSITION, State.NAMED_ONLY_ARGUMENTS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

