/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.builder.FirResolvedQualifierBuilder;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.ConstructorFilter;
import org.jetbrains.kotlin.fir.resolve.calls.ConstructorProcessingKt;
import org.jetbrains.kotlin.fir.resolve.calls.ExpressionReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.tower.ProcessResult;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerLevel;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerLevelProcessor;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirActualizingScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDefaultStarImportingScope;
import org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0016\u001a\u00020\r*\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J%\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001b\u0010\u001f\u001a\u00020\t2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J+\u0010$\u001a\u00020#2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020!H\u0017\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010*\u001a\u00020'2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020!H\u0017\u00a2\u0006\u0004\b*\u0010)J\u001f\u0010+\u001a\u00020'2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020!H\u0017\u00a2\u0006\u0004\b+\u0010)R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010,R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010-R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010.R\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010/R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u00100R\u0014\u00104\u001a\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00105\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/ScopeBasedTowerLevel;", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerLevel;", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "givenScope", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "givenExtensionReceiverOptions", "", "withHideMembersOnly", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConstructorFilter;", "constructorFilter", "Lorg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;", "dispatchReceiverForStatics", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;Lorg/jetbrains/kotlin/fir/scopes/FirScope;Ljava/util/List;ZLorg/jetbrains/kotlin/fir/resolve/calls/ConstructorFilter;Lorg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;)V", "areThereExtensionReceiverOptions", "()Z", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/KtSourceElement;", "source", "toResolvedQualifierExpressionReceiver", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/KtSourceElement;)Lorg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "dispatchReceiverValue", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;)Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "shouldSkipCandidateWithInconsistentExtensionReceiver", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerLevelProcessor;", "processor", "", "consumeCallableCandidate", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerLevelProcessor;)V", "info", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/ProcessResult;", "processFunctionsByName", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerLevelProcessor;)Lorg/jetbrains/kotlin/fir/resolve/calls/tower/ProcessResult;", "processPropertiesByName", "processObjectsByName", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "Ljava/util/List;", "Z", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConstructorFilter;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "session", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;"})
public final class ScopeBasedTowerLevel
extends TowerLevel {
    @NotNull
    private final BodyResolveComponents bodyResolveComponents;
    @NotNull
    private final List<FirExpression> givenExtensionReceiverOptions;
    private final boolean withHideMembersOnly;
    @NotNull
    private final ConstructorFilter constructorFilter;
    @Nullable
    private final ExpressionReceiverValue dispatchReceiverForStatics;
    @NotNull
    private final FirScope scope;

    public ScopeBasedTowerLevel(@NotNull BodyResolveComponents bodyResolveComponents2, @NotNull FirScope givenScope, @NotNull List<? extends FirExpression> givenExtensionReceiverOptions, boolean withHideMembersOnly, @NotNull ConstructorFilter constructorFilter, @Nullable ExpressionReceiverValue dispatchReceiverForStatics) {
        Intrinsics.checkNotNullParameter(bodyResolveComponents2, "bodyResolveComponents");
        Intrinsics.checkNotNullParameter(givenScope, "givenScope");
        Intrinsics.checkNotNullParameter(givenExtensionReceiverOptions, "givenExtensionReceiverOptions");
        Intrinsics.checkNotNullParameter((Object)constructorFilter, "constructorFilter");
        this.bodyResolveComponents = bodyResolveComponents2;
        this.givenExtensionReceiverOptions = givenExtensionReceiverOptions;
        this.withHideMembersOnly = withHideMembersOnly;
        this.constructorFilter = constructorFilter;
        this.dispatchReceiverForStatics = dispatchReceiverForStatics;
        this.scope = FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession()).supportsFeature(LanguageFeature.MultiPlatformProjects) ? (FirScope)new FirActualizingScope(givenScope) : givenScope;
    }

    private final FirSession getSession() {
        return this.bodyResolveComponents.getSession();
    }

    public final boolean areThereExtensionReceiverOptions() {
        return !((Collection)this.givenExtensionReceiverOptions).isEmpty();
    }

    private final ExpressionReceiverValue toResolvedQualifierExpressionReceiver(FirRegularClassSymbol $this$toResolvedQualifierExpressionReceiver, KtSourceElement source) {
        FirResolvedQualifier firResolvedQualifier;
        FirResolvedQualifierBuilder firResolvedQualifierBuilder;
        boolean $i$f$buildResolvedQualifier = false;
        FirResolvedQualifierBuilder $this$toResolvedQualifierExpressionReceiver_u24lambda_u240 = firResolvedQualifierBuilder = new FirResolvedQualifierBuilder();
        boolean bl = false;
        $this$toResolvedQualifierExpressionReceiver_u24lambda_u240.setPackageFqName($this$toResolvedQualifierExpressionReceiver.getClassId().getPackageFqName());
        $this$toResolvedQualifierExpressionReceiver_u24lambda_u240.setRelativeClassFqName($this$toResolvedQualifierExpressionReceiver.getClassId().getRelativeClassName());
        $this$toResolvedQualifierExpressionReceiver_u24lambda_u240.setSymbol($this$toResolvedQualifierExpressionReceiver);
        KtSourceElement ktSourceElement = source;
        $this$toResolvedQualifierExpressionReceiver_u24lambda_u240.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ImplicitReceiver.INSTANCE, 0, 0, 6, null) : null);
        FirResolvedQualifier $this$toResolvedQualifierExpressionReceiver_u24lambda_u241 = firResolvedQualifier = firResolvedQualifierBuilder.build();
        boolean bl2 = false;
        ResolveUtilsKt.setTypeOfQualifier($this$toResolvedQualifierExpressionReceiver_u24lambda_u241, this.bodyResolveComponents);
        FirResolvedQualifier resolvedQualifier = firResolvedQualifier;
        return new ExpressionReceiverValue(resolvedQualifier);
    }

    private final ReceiverValue dispatchReceiverValue(FirCallableSymbol<?> candidate, CallInfo callInfo) {
        ImportedFromObjectOrStaticData<FirCallableDeclaration> importedFromObjectOrStaticData = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData((FirCallableDeclaration)candidate.getFir());
        if (importedFromObjectOrStaticData != null) {
            ImportedFromObjectOrStaticData<FirCallableDeclaration> data2 = importedFromObjectOrStaticData;
            boolean bl = false;
            ClassId objectClassId = data2.getObjectClassId();
            FirClassLikeSymbol<?> symbol = FirSymbolProviderKt.getSymbolProvider(this.getSession()).getClassLikeSymbolByClassId(objectClassId);
            if (symbol instanceof FirRegularClassSymbol) {
                return this.toResolvedQualifierExpressionReceiver((FirRegularClassSymbol)symbol, callInfo.getCallSite().getSource());
            }
        }
        if (candidate instanceof FirBackingFieldSymbol) {
            ConeClassLikeLookupTag lookupTag = ClassMembersKt.dispatchReceiverClassLookupTagOrNull(((FirBackingField)((FirBackingFieldSymbol)candidate).getFir()).getPropertySymbol());
            return lookupTag != null ? (ReceiverValue)this.bodyResolveComponents.getImplicitValueStorage().lastDispatchReceiver(arg_0 -> ScopeBasedTowerLevel.dispatchReceiverValue$lambda$3(this, lookupTag, arg_0)) : null;
        }
        FirCallableSymbol<?> $this$isStatic$iv = candidate;
        boolean $i$f$isStatic = false;
        if ($this$isStatic$iv.getRawStatus().isStatic()) {
            return this.dispatchReceiverForStatics;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean shouldSkipCandidateWithInconsistentExtensionReceiver(FirCallableSymbol<?> candidate) {
        boolean bl;
        block6: {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            if (!(this.scope instanceof FirDefaultStarImportingScope) || !this.areThereExtensionReceiverOptions()) {
                return false;
            }
            FirResolvedTypeRef firResolvedTypeRef = candidate.getResolvedReceiverTypeRef();
            ConeTypeProjection[] coneTypeProjectionArray = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
            ConeClassLikeType coneClassLikeType = coneTypeProjectionArray instanceof ConeClassLikeType ? (ConeClassLikeType)coneTypeProjectionArray : null;
            if (coneClassLikeType == null) {
                return false;
            }
            ConeClassLikeType declarationReceiverType = coneClassLikeType;
            coneTypeProjectionArray = declarationReceiverType.getTypeArguments();
            ConeClassLikeLookupTag coneClassLikeLookupTag = declarationReceiverType.getLookupTag();
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void item$iv$iv;
                void var12_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(ConeStarProjection.INSTANCE);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ConeClassLikeType startProjectedDeclarationReceiverType = TypeConstructionUtilsKt.constructClassType$default(coneClassLikeLookupTag, thisCollection$iv.toArray(new ConeStarProjection[0]), true, null, 4, null);
            Iterable $this$none$iv = this.givenExtensionReceiverOptions;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirExpression extensionReceiver = (FirExpression)element$iv;
                    boolean bl3 = false;
                    ConeKotlinType extensionReceiverType = FirTypeUtilsKt.getResolvedType(extensionReceiver);
                    boolean bl4 = !(extensionReceiverType instanceof ConeClassLikeType) ? true : AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(this.getSession()), (KotlinTypeMarker)extensionReceiverType, (KotlinTypeMarker)startProjectedDeclarationReceiverType, false, 8, null);
                    if (!bl4) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void consumeCallableCandidate(FirCallableSymbol<?> candidate, CallInfo callInfo, TowerLevelProcessor processor) {
        FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)candidate, FirResolvePhase.TYPES);
        if (this.withHideMembersOnly && FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)candidate, StandardClassIds.Annotations.INSTANCE.getHidesMembers(), this.getSession()) == null) {
            return;
        }
        boolean receiverExpected = this.withHideMembersOnly || this.areThereExtensionReceiverOptions();
        FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)candidate.getFir()).getReceiverParameter();
        FirTypeRef candidateReceiverTypeRef = firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null;
        if (candidateReceiverTypeRef == null == receiverExpected) {
            return;
        }
        ReceiverValue dispatchReceiverValue = this.dispatchReceiverValue(candidate, callInfo);
        if (dispatchReceiverValue == null && this.shouldSkipCandidateWithInconsistentExtensionReceiver(candidate)) {
            return;
        }
        Object object = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData((FirCallableDeclaration)candidate.getFir());
        if (object == null || (object = ((ImportedFromObjectOrStaticData)object).getOriginal()) == null || (object = ((FirCallableDeclaration)object).getSymbol()) == null) {
            object = candidate;
        }
        FirCallableSymbol<?> unwrappedCandidate = object;
        ReceiverValue receiverValue = dispatchReceiverValue;
        TowerLevelProcessor.consumeCandidate$default(processor, unwrappedCandidate, receiverValue != null ? receiverValue.getReceiverExpression() : null, this.givenExtensionReceiverOptions, this.scope, false, false, 48, null);
    }

    @Override
    @NotNull
    public ProcessResult processFunctionsByName(@NotNull CallInfo info, @NotNull TowerLevelProcessor processor) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(processor, "processor");
        FirLookupTrackerComponent lookupTracker = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        Ref.BooleanRef empty2 = new Ref.BooleanRef();
        empty2.element = true;
        FirLookupTrackerComponent firLookupTrackerComponent = lookupTracker;
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallLookup(firLookupTrackerComponent, (AbstractCallInfo)info, (Iterable<String>)this.scope.getScopeOwnerLookupNames());
        }
        ConstructorProcessingKt.processFunctionsAndConstructorsByName(this.scope, info, this.getSession(), this.bodyResolveComponents, this.constructorFilter, arg_0 -> ScopeBasedTowerLevel.processFunctionsByName$lambda$6(lookupTracker, info, empty2, this, processor, arg_0));
        return empty2.element ? ProcessResult.SCOPE_EMPTY : ProcessResult.FOUND;
    }

    @Override
    @NotNull
    public ProcessResult processPropertiesByName(@NotNull CallInfo info, @NotNull TowerLevelProcessor processor) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(processor, "processor");
        FirLookupTrackerComponent lookupTracker = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        Ref.BooleanRef empty2 = new Ref.BooleanRef();
        empty2.element = true;
        FirLookupTrackerComponent firLookupTrackerComponent = lookupTracker;
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallLookup(firLookupTrackerComponent, (AbstractCallInfo)info, (Iterable<String>)this.scope.getScopeOwnerLookupNames());
        }
        this.scope.processPropertiesByName(info.getName(), arg_0 -> ScopeBasedTowerLevel.processPropertiesByName$lambda$7(lookupTracker, info, empty2, this, processor, arg_0));
        return empty2.element ? ProcessResult.SCOPE_EMPTY : ProcessResult.FOUND;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ProcessResult processObjectsByName(@NotNull CallInfo info, @NotNull TowerLevelProcessor processor) {
        void name$iv;
        void $this$processClassifiersByName$iv;
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(processor, "processor");
        Ref.BooleanRef empty2 = new Ref.BooleanRef();
        empty2.element = true;
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallLookup(firLookupTrackerComponent, (AbstractCallInfo)info, (Iterable<String>)this.scope.getScopeOwnerLookupNames());
        }
        FirScope firScope = this.scope;
        Name name = info.getName();
        Function1<FirClassifierSymbol, Unit> processor$iv = arg_0 -> ScopeBasedTowerLevel.processObjectsByName$lambda$8(empty2, processor, this, arg_0);
        boolean $i$f$processClassifiersByName = false;
        $this$processClassifiersByName$iv.processClassifiersByNameWithSubstitution((Name)name$iv, new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(processor$iv){
            final /* synthetic */ Function1 $processor;
            {
                this.$processor = $processor;
            }

            public final void invoke(FirClassifierSymbol<?> symbol, ConeSubstitutor coneSubstitutor) {
                Intrinsics.checkNotNullParameter(symbol, "symbol");
                Intrinsics.checkNotNullParameter(coneSubstitutor, "<unused var>");
                this.$processor.invoke(symbol);
            }
        });
        return empty2.element ? ProcessResult.SCOPE_EMPTY : ProcessResult.FOUND;
    }

    private static final boolean dispatchReceiverValue$lambda$3(ScopeBasedTowerLevel this$0, ConeClassLikeLookupTag $lookupTag, ImplicitReceiverValue implicitReceiverValue) {
        Intrinsics.checkNotNullParameter(implicitReceiverValue, "implicitReceiverValue");
        return Intrinsics.areEqual(ConeTypeUtilsKt.getLookupTagIfAny(TypeExpansionUtilsKt.fullyExpandedType$default(implicitReceiverValue.getType(), this$0.getSession(), null, 2, null)), $lookupTag);
    }

    private static final Unit processFunctionsByName$lambda$6(FirLookupTrackerComponent $lookupTracker, CallInfo $info, Ref.BooleanRef $empty, ScopeBasedTowerLevel this$0, TowerLevelProcessor $processor, FirCallableSymbol candidate) {
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        FirLookupTrackerComponent firLookupTrackerComponent = $lookupTracker;
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallableCandidateAsLookup(firLookupTrackerComponent, candidate, $info.getCallSite().getSource(), $info.getContainingFile().getSource());
        }
        $empty.element = false;
        this$0.consumeCallableCandidate(candidate, $info, $processor);
        return Unit.INSTANCE;
    }

    private static final Unit processPropertiesByName$lambda$7(FirLookupTrackerComponent $lookupTracker, CallInfo $info, Ref.BooleanRef $empty, ScopeBasedTowerLevel this$0, TowerLevelProcessor $processor, FirVariableSymbol candidate) {
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        FirLookupTrackerComponent firLookupTrackerComponent = $lookupTracker;
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordCallableCandidateAsLookup(firLookupTrackerComponent, candidate, $info.getCallSite().getSource(), $info.getContainingFile().getSource());
        }
        $empty.element = false;
        this$0.consumeCallableCandidate(candidate, $info, $processor);
        return Unit.INSTANCE;
    }

    private static final Unit processObjectsByName$lambda$8(Ref.BooleanRef $empty, TowerLevelProcessor $processor, ScopeBasedTowerLevel this$0, FirClassifierSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $empty.element = false;
        TowerLevelProcessor.consumeCandidate$default($processor, it, null, CollectionsKt.emptyList(), this$0.scope, true, false, 32, null);
        return Unit.INSTANCE;
    }
}

