/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAugmentedAssignment;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.dfa.Stack;
import org.jetbrains.kotlin.fir.resolve.dfa.StackKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\b\u0000\u0018\u0000 K2\u00020\u0001:\u0001KB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J-\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ7\u0010\u0012\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00150\u001a2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010 \u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b \u0010!J\u001d\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\b2\u0006\u0010#\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\u0004\u00a2\u0006\u0004\b'\u0010\u0003J\u0015\u0010*\u001a\u00020\u00042\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u00020\u0004\u00a2\u0006\u0004\b,\u0010\u0003J\u001b\u00100\u001a\u00020\u00042\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-\u00a2\u0006\u0004\b0\u00101J\u0015\u00103\u001a\u00020\u00042\u0006\u00102\u001a\u00020\r\u00a2\u0006\u0004\b3\u00104J\u001d\u00107\u001a\b\u0012\u0004\u0012\u00020$0\b2\u0006\u00106\u001a\u000205H\u0007\u00a2\u0006\u0004\b7\u00108J\u0015\u00109\u001a\b\u0012\u0004\u0012\u00020$0\bH\u0007\u00a2\u0006\u0004\b9\u0010:J\u001d\u0010>\u001a\u00020\u00042\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020\t\u00a2\u0006\u0004\b>\u0010?R\u001c\u0010@\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00188\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR$\u0010B\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001a8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR*\u0010E\u001a\u0016\u0012\u0004\u0012\u00020;\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100D\u0018\u00010\u001a8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010CR(\u0010G\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u001f0\u001e0F8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bG\u0010HR&\u0010J\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\r0I0F8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bJ\u0010H"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer;", "", "<init>", "()V", "", "reset", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "types", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "isUnstableInCurrentScope", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "assignments", "allAssignmentsPreserveType", "(Ljava/util/Set;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "symbol", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "getInfoForDeclaration", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "root", "", "buildInfoForRoot", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;)Ljava/util/Map;", "evaluatedInPlace", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "enterScope", "(Ljava/lang/Object;Z)Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "function", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "enterFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)Ljava/util/Set;", "exitFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "klass", "enterClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "exitClass", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "lambdaArgs", "enterFunctionCall", "(Ljava/util/Collection;)V", "callCompleted", "exitFunctionCall", "(Z)V", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "loop", "enterLoop", "(Lorg/jetbrains/kotlin/fir/expressions/FirLoop;)Ljava/util/Set;", "exitLoop", "()Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "type", "visitAssignment", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "rootFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "assignedLocalVariablesByDeclaration", "Ljava/util/Map;", "", "variableAssignments", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Stack;", "scopes", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Stack;", "", "postponedLambdas", "Companion"})
public final class FirLocalVariableAssignmentAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FirFunctionSymbol<?> rootFunction;
    @Nullable
    private Map<Object, Companion.Fork> assignedLocalVariablesByDeclaration;
    @Nullable
    private Map<FirProperty, ? extends List<Companion.Assignment>> variableAssignments;
    @NotNull
    private final Stack<Pair<Companion.Fork, Companion.VariableAssignments>> scopes = StackKt.stackOf(new Pair[0]);
    @NotNull
    private final Stack<Map<Companion.Fork, Boolean>> postponedLambdas = StackKt.stackOf(new Map[0]);

    public final void reset() {
        this.rootFunction = null;
        this.assignedLocalVariablesByDeclaration = null;
        this.variableAssignments = null;
        this.postponedLambdas.reset();
        this.scopes.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnstableInCurrentScope(@NotNull FirDeclaration declaration, @Nullable Set<? extends ConeKotlinType> types2, @NotNull FirSession session) {
        boolean bl;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(session, "session");
        if (this.assignedLocalVariablesByDeclaration == null) {
            return false;
        }
        if (!(declaration instanceof FirProperty)) return false;
        if (!((FirProperty)declaration).isLocal()) return false;
        if (!((FirProperty)declaration).isVar()) {
            return false;
        }
        if (!this.allAssignmentsPreserveType(this.scopes.top().getSecond().get((FirProperty)declaration), types2, session)) return true;
        Iterable $this$any$iv = this.postponedLambdas.all();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Map lambdas = (Map)element$iv;
            boolean bl2 = false;
            Map $this$any$iv2 = lambdas;
            boolean $i$f$any2 = false;
            if ($this$any$iv2.isEmpty()) {
                bl = false;
                continue;
            }
            Iterator iterator3 = $this$any$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator3.next();
                boolean bl3 = false;
                Companion.Fork lambda = (Companion.Fork)entry.getKey();
                boolean dataFlowOnly = (Boolean)entry.getValue();
                if (dataFlowOnly && lambda.getAssignedInside().contains((FirProperty)declaration)) {
                    return true;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean allAssignmentsPreserveType(Set<Companion.Assignment> assignments, Set<? extends ConeKotlinType> types2, FirSession session) {
        boolean bl;
        boolean bl2;
        Collection collection = assignments;
        if (collection == null) return true;
        if (collection.isEmpty()) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        if (types2 == null) return false;
        Iterable $this$all$iv = assignments;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                Companion.Assignment it = (Companion.Assignment)element$iv;
                boolean bl4 = false;
                if (it.getType() == null) return false;
                boolean bl5 = true;
                if (bl5) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        $this$all$iv = assignments;
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            Companion.Assignment assignment = (Companion.Assignment)element$iv;
            boolean bl6 = false;
            Iterable $this$all$iv2 = types2;
            boolean $i$f$all2 = false;
            if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                bl = true;
                continue;
            }
            for (Object element$iv2 : $this$all$iv2) {
                ConeKotlinType it = (ConeKotlinType)element$iv2;
                boolean bl7 = false;
                TypeCheckerProviderContext typeCheckerProviderContext = TypeComponentsKt.getTypeContext(session);
                ConeKotlinType coneKotlinType = assignment.getType();
                Intrinsics.checkNotNull(coneKotlinType);
                if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerProviderContext, (KotlinTypeMarker)coneKotlinType, (KotlinTypeMarker)it, false, 8, null)) continue;
                return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    private final Companion.Fork getInfoForDeclaration(Object symbol) {
        FirFunctionSymbol<?> firFunctionSymbol = this.rootFunction;
        if (firFunctionSymbol == null) {
            return null;
        }
        FirFunctionSymbol<?> root = firFunctionSymbol;
        if (Intrinsics.areEqual(root, symbol)) {
            return null;
        }
        Map<Object, Companion.Fork> cachedMap2 = this.buildInfoForRoot(root);
        return cachedMap2.get(symbol);
    }

    private final Map<Object, Companion.Fork> buildInfoForRoot(FirFunctionSymbol<?> root) {
        Map<Object, Companion.Fork> map2 = this.assignedLocalVariablesByDeclaration;
        if (map2 != null) {
            Map<Object, Companion.Fork> it = map2;
            boolean bl = false;
            return it;
        }
        Companion.MiniCfgBuilder.MiniCfgData data2 = new Companion.MiniCfgBuilder.MiniCfgData();
        new Companion.MiniCfgBuilder().visitElement((FirElement)root.getFir(), data2);
        this.assignedLocalVariablesByDeclaration = data2.getForks();
        this.variableAssignments = data2.getAssignments();
        return data2.getForks();
    }

    private final Pair<Companion.Fork, Companion.VariableAssignments> enterScope(Object symbol, boolean evaluatedInPlace) {
        Companion.Fork currentInfo = this.getInfoForDeclaration(symbol);
        Companion.VariableAssignments prohibitInThisScope = this.scopes.top().getSecond().copy();
        this.scopes.push(TuplesKt.to(currentInfo, prohibitInThisScope));
        if (!evaluatedInPlace) {
            for (Pair<Companion.Fork, Companion.VariableAssignments> pair : this.scopes.all()) {
                Companion.Fork outerInfo = pair.component1();
                Companion.VariableAssignments prohibitInOuterScope = pair.component2();
                Companion.Fork fork = currentInfo;
                prohibitInOuterScope.merge(fork != null ? fork.getAssignedInside() : null);
                Companion.Fork fork2 = outerInfo;
                prohibitInThisScope.merge(fork2 != null ? fork2.getAssignedLater() : null);
            }
        }
        return this.scopes.top();
    }

    @NotNull
    public final Set<FirPropertySymbol> enterFunction(@NotNull FirFunction function2) {
        Set<FirPropertySymbol> set;
        Intrinsics.checkNotNullParameter(function2, "function");
        if (this.rootFunction == null) {
            this.rootFunction = function2.getSymbol();
            this.scopes.push(TuplesKt.to(null, new Companion.VariableAssignments()));
            return SetsKt.emptySet();
        }
        Pair<Companion.Fork, Companion.VariableAssignments> pair = this.enterScope(function2.getSymbol(), function2 instanceof FirAnonymousFunction && EventOccurrencesRangeKt.isInPlace(((FirAnonymousFunction)function2).getInvocationKind()));
        Companion.Fork info = pair.component1();
        Companion.VariableAssignments prohibitSmartCasts = pair.component2();
        for (Map<Companion.Fork, Boolean> concurrentLambdas : this.postponedLambdas.all()) {
            for (Map.Entry<Companion.Fork, Boolean> entry : concurrentLambdas.entrySet()) {
                Companion.Fork otherLambda = entry.getKey();
                boolean dataFlowOnly = entry.getValue();
                if (dataFlowOnly || Intrinsics.areEqual(otherLambda, info)) continue;
                prohibitSmartCasts.merge(otherLambda.getAssignedInside());
            }
        }
        Object object = this.scopes.top().getFirst();
        if ((object != null && (object = ((Companion.Fork)object).getAssignedInside()) != null ? ((Companion.VariableAssignments)object).getAssignedProperties() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void exitFunction() {
        this.scopes.pop();
        if (StackKt.isEmpty(this.scopes)) {
            this.rootFunction = null;
            this.assignedLocalVariablesByDeclaration = null;
            this.variableAssignments = null;
        }
    }

    public final void enterClass(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (this.rootFunction == null) {
            return;
        }
        Pair<Companion.Fork, Companion.VariableAssignments> pair = this.enterScope(klass.getSymbol(), klass instanceof FirAnonymousObject);
        Companion.Fork info = pair.component1();
        Companion.VariableAssignments prohibitSmartCasts = pair.component2();
        if (klass instanceof FirAnonymousObject && info != null) {
            prohibitSmartCasts.merge(info.getAssignedInside());
        }
    }

    public final void exitClass() {
        if (this.rootFunction == null) {
            return;
        }
        this.scopes.pop();
    }

    /*
     * WARNING - void declaration
     */
    public final void enterFunctionCall(@NotNull Collection<? extends FirAnonymousFunction> lambdaArgs) {
        void var3_5;
        void $this$associateWithTo$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(lambdaArgs, "lambdaArgs");
        if (this.rootFunction == null) {
            return;
        }
        Iterable iterable = lambdaArgs;
        Stack<Map<Companion.Fork, Boolean>> stack = this.postponedLambdas;
        boolean $i$f$mapNotNull22 = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Companion.Fork $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Companion.Fork it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirAnonymousFunction it = (FirAnonymousFunction)element$iv$iv;
            boolean bl2 = false;
            if (this.getInfoForDeclaration(it.getSymbol()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Map $i$f$mapNotNull22 = new LinkedHashMap();
        boolean $i$f$associateWithTo = false;
        for (Object element$iv : $this$associateWithTo$iv) {
            void destination$iv;
            $this$forEach$iv$iv$iv = (Companion.Fork)element$iv;
            Object t = element$iv;
            void var18_21 = destination$iv;
            boolean bl = false;
            Boolean bl4 = false;
            var18_21.put(t, bl4);
        }
        stack.push((Map<Companion.Fork, Boolean>)var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final void exitFunctionCall(boolean callCompleted) {
        if (this.rootFunction == null) {
            return;
        }
        Map<Companion.Fork, Boolean> lambdasInCall = this.postponedLambdas.pop();
        if (!callCompleted) {
            void $this$associateWithTo$iv;
            Iterable iterable = lambdasInCall.keySet();
            Map<Companion.Fork, Boolean> map2 = StackKt.topOrNull(this.postponedLambdas);
            if (map2 == null) {
                return;
            }
            Map<Companion.Fork, Boolean> destination$iv = map2;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv : $this$associateWithTo$iv) {
                Companion.Fork fork = (Companion.Fork)element$iv;
                Object t = element$iv;
                Map<Companion.Fork, Boolean> map3 = destination$iv;
                boolean bl = false;
                Boolean bl2 = true;
                map3.put((Companion.Fork)t, bl2);
            }
        }
    }

    @NotNull
    public final Set<FirPropertySymbol> enterLoop(@NotNull FirLoop loop) {
        Set<FirPropertySymbol> set;
        Intrinsics.checkNotNullParameter(loop, "loop");
        if (this.rootFunction == null) {
            return SetsKt.emptySet();
        }
        Companion.Fork info = this.enterScope(loop, true).component1();
        Object object = info;
        if ((object != null && (object = ((Companion.Fork)object).getAssignedInside()) != null ? ((Companion.VariableAssignments)object).getAssignedProperties() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<FirPropertySymbol> exitLoop() {
        Set<FirPropertySymbol> set;
        if (this.rootFunction == null) {
            return SetsKt.emptySet();
        }
        Companion.Fork info = this.scopes.pop().component1();
        Object object = info;
        if ((object != null && (object = ((Companion.Fork)object).getAssignedInside()) != null ? ((Companion.VariableAssignments)object).getAssignedProperties() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void visitAssignment(@NotNull FirProperty property, @NotNull ConeKotlinType type2) {
        Object v2;
        block4: {
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(type2, "type");
            FirFunctionSymbol<?> firFunctionSymbol = this.rootFunction;
            if (firFunctionSymbol == null) {
                return;
            }
            this.buildInfoForRoot(firFunctionSymbol);
            Map<FirProperty, ? extends List<Companion.Assignment>> map2 = this.variableAssignments;
            if (map2 == null || (map2 = map2.get(property)) == null) {
                return;
            }
            Map<FirProperty, ? extends List<Companion.Assignment>> assignments = map2;
            Iterable $this$firstOrNull$iv = (Iterable)((Object)assignments);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Companion.Assignment it = (Companion.Assignment)element$iv;
                boolean bl = false;
                if (!(it.getType() == null)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Companion.Assignment assignment = v2;
        if (assignment == null) {
            return;
        }
        Companion.Assignment assignment2 = assignment;
        assignment2.setType(type2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion;", "", "<init>", "()V", "Fork", "Assignment", "VariableAssignments", "MiniFlow", "MiniCfgBuilder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR$\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0007@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "", "", "operatorAssignment", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "<init>", "(ZLorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "Z", "getOperatorAssignment", "()Z", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "setType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V"})
        private static final class Assignment {
            private final boolean operatorAssignment;
            @Nullable
            private ConeKotlinType type;

            public Assignment(boolean operatorAssignment, @Nullable ConeKotlinType type2) {
                this.operatorAssignment = operatorAssignment;
                this.type = type2;
            }

            public /* synthetic */ Assignment(boolean bl, ConeKotlinType coneKotlinType, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    coneKotlinType = null;
                }
                this(bl, coneKotlinType);
            }

            public final boolean getOperatorAssignment() {
                return this.operatorAssignment;
            }

            @Nullable
            public final ConeKotlinType getType() {
                return this.type;
            }

            public final void setType(@Nullable ConeKotlinType coneKotlinType) {
                this.type = coneKotlinType;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\n\u0010\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "assignedLater", "assignedInside", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "getAssignedLater", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "getAssignedInside"})
        private static final class Fork {
            @NotNull
            private final VariableAssignments assignedLater;
            @NotNull
            private final VariableAssignments assignedInside;

            public Fork(@NotNull VariableAssignments assignedLater, @NotNull VariableAssignments assignedInside) {
                Intrinsics.checkNotNullParameter(assignedLater, "assignedLater");
                Intrinsics.checkNotNullParameter(assignedInside, "assignedInside");
                this.assignedLater = assignedLater;
                this.assignedInside = assignedInside;
            }

            @NotNull
            public final VariableAssignments getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final VariableAssignments getAssignedInside() {
                return this.assignedInside;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001ZB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b \u0010!J\u001f\u0010$\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010(\u001a\u00020\u00022\u0006\u0010'\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b(\u0010)J\u0019\u0010,\u001a\u00020+*\b\u0012\u0004\u0012\u00020+0*H\u0002\u00a2\u0006\u0004\b,\u0010-J\u001f\u00100\u001a\u00020\u00022\u0006\u0010/\u001a\u00020.2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b0\u00101J\u001f\u00104\u001a\u00020\u00022\u0006\u00103\u001a\u0002022\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b4\u00105J\u001f\u00108\u001a\u00020\u00022\u0006\u00107\u001a\u0002062\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b8\u00109J\u001f\u0010<\u001a\u00020\u00022\u0006\u0010;\u001a\u00020:2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b<\u0010=J\u001f\u0010@\u001a\u00020\u00022\u0006\u0010?\u001a\u00020>2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b@\u0010AJ\u001f\u0010D\u001a\u00020\u00022\u0006\u0010C\u001a\u00020B2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\bD\u0010EJ\u001f\u0010H\u001a\u00020\u00022\u0006\u0010G\u001a\u00020F2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\bH\u0010IJ\u001f\u0010L\u001a\u00020\u00022\u0006\u0010K\u001a\u00020J2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\bL\u0010MJ#\u0010R\u001a\u00020\u0002*\u00020\u00032\u0006\u0010O\u001a\u00020N2\u0006\u0010Q\u001a\u00020PH\u0002\u00a2\u0006\u0004\bR\u0010SJ#\u0010R\u001a\u00020\u0002*\u00020+2\u0006\u0010C\u001a\u00020B2\u0006\u0010U\u001a\u00020TH\u0002\u00a2\u0006\u0004\bR\u0010VJ\u001b\u0010X\u001a\u00020\u0002*\u00020+2\u0006\u0010W\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\bX\u0010Y"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "visitElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "visitElementWithLexicalScope", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "anonymousFunction", "visitAnonymousFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "visitSimpleFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "regularClass", "visitRegularClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "anonymousObject", "visitAnonymousObject", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "visitLocalDeclaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "whenExpression", "visitWhenExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "tryExpression", "visitTryExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "join", "(Ljava/util/Set;)Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "loop", "visitLoop", "(Lorg/jetbrains/kotlin/fir/expressions/FirLoop;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;", "whileLoop", "visitWhileLoop", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhileLoop;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;", "doWhileLoop", "visitDoWhileLoop", "(Lorg/jetbrains/kotlin/fir/expressions/FirDoWhileLoop;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "functionCall", "visitFunctionCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "block", "visitBlock", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "visitProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "variableAssignment", "visitVariableAssignment", "(Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirAugmentedAssignment;", "augmentedAssignment", "visitAugmentedAssignment", "(Lorg/jetbrains/kotlin/fir/expressions/FirAugmentedAssignment;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;)V", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "reference", "", "operatorAssignment", "recordAssignment", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;Lorg/jetbrains/kotlin/fir/references/FirReference;Z)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "assignment", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;)V", "properties", "recordAssignments", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;)V", "MiniCfgData"})
        private static final class MiniCfgBuilder
        extends FirVisitor<Unit, MiniCfgData> {
            @Override
            public void visitElement(@NotNull FirElement element, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(element, "element");
                Intrinsics.checkNotNullParameter(data2, "data");
                element.acceptChildren(this, data2);
            }

            /*
             * WARNING - void declaration
             */
            private final VariableAssignments visitElementWithLexicalScope(FirElement element, MiniCfgData data2) {
                void destination$iv;
                void $this$flatMapTo$iv;
                MiniFlow flow = MiniFlow.Companion.start();
                Object object = data2.getVariableDeclarations();
                Collection collection = new LinkedHashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    Map it = (Map)element$iv;
                    boolean bl = false;
                    Iterable list$iv = it.values();
                    CollectionsKt.addAll(destination$iv, list$iv);
                }
                Set freeVariables = (Set)destination$iv;
                data2.setFlow(flow);
                element.acceptChildren(this, data2);
                Object $this$visitElementWithLexicalScope_u24lambda_u241 = object = flow.getAssignedLater();
                boolean bl = false;
                ((VariableAssignments)$this$visitElementWithLexicalScope_u24lambda_u241).retain(freeVariables);
                return object;
            }

            @Override
            public void visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(anonymousFunction, "anonymousFunction");
                Intrinsics.checkNotNullParameter(data2, "data");
                this.visitLocalDeclaration(anonymousFunction, data2);
            }

            @Override
            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
                Intrinsics.checkNotNullParameter(data2, "data");
                this.visitLocalDeclaration(simpleFunction, data2);
            }

            @Override
            public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(regularClass, "regularClass");
                Intrinsics.checkNotNullParameter(data2, "data");
                this.visitLocalDeclaration(regularClass, data2);
            }

            @Override
            public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
                Intrinsics.checkNotNullParameter(data2, "data");
                this.visitLocalDeclaration(anonymousObject, data2);
            }

            private final void visitLocalDeclaration(FirDeclaration declaration, MiniCfgData data2) {
                MiniFlow flow = data2.getFlow();
                VariableAssignments assignedInside = this.visitElementWithLexicalScope(declaration, data2);
                this.recordAssignments(flow, assignedInside);
                data2.setFlow(flow.fork());
                data2.getForks().put(declaration.getSymbol(), new Fork(data2.getFlow().getAssignedLater(), assignedInside));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitWhenExpression(@NotNull FirWhenExpression whenExpression, @NotNull MiniCfgData data2) {
                void var13_13;
                void destination$iv;
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter(whenExpression, "whenExpression");
                Intrinsics.checkNotNullParameter(data2, "data");
                FirVariable firVariable = whenExpression.getSubjectVariable();
                FirElement firElement = firVariable != null ? (FirElement)firVariable : (FirElement)whenExpression.getSubject();
                if (firElement != null) {
                    ((FirStatement)firElement).accept(this, data2);
                }
                MiniFlow flow = data2.getFlow();
                Iterable iterable = whenExpression.getBranches();
                Object object = new MiniFlow[]{flow};
                object = SetsKt.mutableSetOf(object);
                MiniCfgBuilder miniCfgBuilder = this;
                MiniCfgData miniCfgData = data2;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FirWhenBranch firWhenBranch = (FirWhenBranch)item$iv;
                    var13_13 = destination$iv;
                    boolean bl = false;
                    data2.setFlow(flow);
                    it.accept(this, data2);
                    var13_13.add(data2.getFlow());
                }
                var13_13 = destination$iv;
                miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitTryExpression(@NotNull FirTryExpression tryExpression, @NotNull MiniCfgData data2) {
                block1: {
                    void var13_13;
                    void destination$iv;
                    void $this$mapTo$iv;
                    Intrinsics.checkNotNullParameter(tryExpression, "tryExpression");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    tryExpression.getTryBlock().accept(this, data2);
                    MiniFlow flow = data2.getFlow();
                    Iterable iterable = tryExpression.getCatches();
                    Object object = new MiniFlow[]{flow};
                    object = SetsKt.mutableSetOf(object);
                    MiniCfgBuilder miniCfgBuilder = this;
                    MiniCfgData miniCfgData = data2;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        FirCatch firCatch = (FirCatch)item$iv;
                        var13_13 = destination$iv;
                        boolean bl = false;
                        data2.setFlow(flow);
                        it.accept(this, data2);
                        var13_13.add(data2.getFlow());
                    }
                    var13_13 = destination$iv;
                    miniCfgData.setFlow(miniCfgBuilder.join((Set)var13_13));
                    FirBlock firBlock = tryExpression.getFinallyBlock();
                    if (firBlock == null) break block1;
                    firBlock.accept(this, data2);
                }
            }

            private final MiniFlow join(Set<MiniFlow> $this$join) {
                MiniFlow miniFlow = (MiniFlow)CollectionsKt.singleOrNull((Iterable)$this$join);
                if (miniFlow == null) {
                    miniFlow = new MiniFlow($this$join);
                }
                return miniFlow;
            }

            @Override
            public void visitLoop(@NotNull FirLoop loop, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(loop, "loop");
                Intrinsics.checkNotNullParameter(data2, "data");
                MiniFlow entry = data2.getFlow();
                VariableAssignments assignedInside = this.visitElementWithLexicalScope(loop, data2);
                this.recordAssignments(entry, assignedInside);
                this.recordAssignments(data2.getFlow(), assignedInside);
                data2.setFlow(entry.fork());
                data2.getForks().put(loop, new Fork(data2.getFlow().getAssignedLater(), assignedInside));
            }

            @Override
            public void visitWhileLoop(@NotNull FirWhileLoop whileLoop, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(whileLoop, "whileLoop");
                Intrinsics.checkNotNullParameter(data2, "data");
                this.visitLoop((FirLoop)whileLoop, data2);
            }

            @Override
            public void visitDoWhileLoop(@NotNull FirDoWhileLoop doWhileLoop, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(doWhileLoop, "doWhileLoop");
                Intrinsics.checkNotNullParameter(data2, "data");
                this.visitLoop((FirLoop)doWhileLoop, data2);
            }

            @Override
            public void visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull MiniCfgData data2) {
                FirExpression it;
                Intrinsics.checkNotNullParameter(functionCall, "functionCall");
                Intrinsics.checkNotNullParameter(data2, "data");
                MiniCfgBuilder visitor2 = this;
                FirFunctionCall $this$visitFunctionCall_u24lambda_u248 = functionCall;
                boolean bl = false;
                Object object = new FirExpression[]{$this$visitFunctionCall_u24lambda_u248.getExplicitReceiver(), $this$visitFunctionCall_u24lambda_u248.getDispatchReceiver(), $this$visitFunctionCall_u24lambda_u248.getExtensionReceiver()};
                Iterable $this$forEach$iv = SetsKt.setOfNotNull(object);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirExpression it2 = (FirExpression)element$iv;
                    boolean bl2 = false;
                    it2.accept(visitor2, data2);
                }
                Iterable $this$partition$iv = $this$visitFunctionCall_u24lambda_u248.getArgumentList().getArguments();
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    it = (FirExpression)element$iv;
                    boolean bl3 = false;
                    boolean bl4 = it instanceof FirAnonymousFunctionExpression ? first$iv.add(element$iv) : second$iv.add(element$iv);
                }
                object = new Pair(first$iv, second$iv);
                List postponedFunctionArgs = (List)((Pair)object).component1();
                List normalArgs = (List)((Pair)object).component2();
                Iterable $this$forEach$iv2 = normalArgs;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl5 = false;
                    it.accept(visitor2, data2);
                }
                $this$forEach$iv2 = postponedFunctionArgs;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (FirExpression)element$iv;
                    boolean bl6 = false;
                    it.accept(visitor2, data2);
                }
                $this$visitFunctionCall_u24lambda_u248.getCalleeReference().accept(visitor2, data2);
            }

            @Override
            public void visitBlock(@NotNull FirBlock block, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(block, "block");
                Intrinsics.checkNotNullParameter(data2, "data");
                data2.getVariableDeclarations().addLast(new LinkedHashMap());
                this.visitElement((FirElement)block, data2);
                data2.getVariableDeclarations().removeLast();
            }

            @Override
            public void visitProperty(@NotNull FirProperty property, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(property, "property");
                Intrinsics.checkNotNullParameter(data2, "data");
                this.visitElement((FirElement)property, data2);
                if (property.isLocal()) {
                    data2.getVariableDeclarations().last().put(property.getName(), property);
                }
            }

            @Override
            public void visitVariableAssignment(@NotNull FirVariableAssignment variableAssignment, @NotNull MiniCfgData data2) {
                block1: {
                    Intrinsics.checkNotNullParameter(variableAssignment, "variableAssignment");
                    Intrinsics.checkNotNullParameter(data2, "data");
                    this.visitElement((FirElement)variableAssignment, data2);
                    if (FirExpressionUtilKt.getExplicitReceiver(variableAssignment) != null) {
                        return;
                    }
                    FirReference firReference = ReferenceUtilsKt.getCalleeReference(variableAssignment);
                    if (firReference == null) break block1;
                    FirReference it = firReference;
                    boolean bl = false;
                    KtSourceElement ktSourceElement = variableAssignment.getSource();
                    boolean operatorAssignment = (ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement;
                    this.recordAssignment(data2, it, operatorAssignment);
                }
            }

            @Override
            public void visitAugmentedAssignment(@NotNull FirAugmentedAssignment augmentedAssignment, @NotNull MiniCfgData data2) {
                Intrinsics.checkNotNullParameter(augmentedAssignment, "augmentedAssignment");
                Intrinsics.checkNotNullParameter(data2, "data");
                this.visitElement((FirElement)augmentedAssignment, data2);
                FirExpression firExpression = augmentedAssignment.getLeftArgument();
                FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
                if (firQualifiedAccessExpression == null) {
                    return;
                }
                FirQualifiedAccessExpression lhs = firQualifiedAccessExpression;
                if (lhs.getExplicitReceiver() != null) {
                    return;
                }
                this.recordAssignment(data2, lhs.getCalleeReference(), true);
            }

            private final void recordAssignment(MiniCfgData $this$recordAssignment, FirReference reference, boolean operatorAssignment) {
                List list;
                Object object;
                Object v1;
                Object name;
                block5: {
                    Object object2 = reference instanceof FirNamedReference ? (FirNamedReference)reference : null;
                    if (object2 == null || (object2 = ((FirNamedReference)object2).getName()) == null) {
                        return;
                    }
                    name = object2;
                    List $this$lastOrNull$iv = $this$recordAssignment.getVariableDeclarations();
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        Map it = (Map)element$iv;
                        boolean bl = false;
                        if (!it.containsKey(name)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                if ((object = (Map)v1) == null || (object = (FirProperty)object.get(name)) == null) {
                    return;
                }
                Object property = object;
                Assignment assignment = new Assignment(operatorAssignment, null, 2, null);
                Map<FirProperty, List<Assignment>> $this$getOrPut$iv = $this$recordAssignment.getAssignments();
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(property);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put((FirProperty)property, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                list.add((Assignment)assignment);
                this.recordAssignment($this$recordAssignment.getFlow(), (FirProperty)property, assignment);
            }

            private final void recordAssignment(MiniFlow $this$recordAssignment, FirProperty property, Assignment assignment) {
                if (!$this$recordAssignment.getAssignedLater().add(property, assignment)) {
                    return;
                }
                Iterable $this$forEach$iv = $this$recordAssignment.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignment(it, property, assignment);
                }
            }

            private final void recordAssignments(MiniFlow $this$recordAssignments, VariableAssignments properties2) {
                if (!$this$recordAssignments.getAssignedLater().merge(properties2)) {
                    return;
                }
                Iterable $this$forEach$iv = $this$recordAssignments.getParents();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MiniFlow it = (MiniFlow)element$iv;
                    boolean bl = false;
                    this.recordAssignments(it, properties2);
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0007@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR,\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u000b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R,\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0016\u001a\u0004\b\u001b\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniCfgBuilder$MiniCfgData;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "getFlow", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "setFlow", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;)V", "Lkotlin/collections/ArrayDeque;", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "variableDeclarations", "Lkotlin/collections/ArrayDeque;", "getVariableDeclarations", "()Lkotlin/collections/ArrayDeque;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "assignments", "Ljava/util/Map;", "getAssignments", "()Ljava/util/Map;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Fork;", "forks", "getForks"})
            public static final class MiniCfgData {
                @NotNull
                private MiniFlow flow = MiniFlow.Companion.start();
                @NotNull
                private final ArrayDeque<Map<Name, FirProperty>> variableDeclarations = new ArrayDeque(CollectionsKt.listOf((Map)new LinkedHashMap()));
                @NotNull
                private final Map<FirProperty, List<Assignment>> assignments = new LinkedHashMap();
                @NotNull
                private final Map<Object, Fork> forks = new LinkedHashMap();

                @NotNull
                public final MiniFlow getFlow() {
                    return this.flow;
                }

                public final void setFlow(@NotNull MiniFlow miniFlow) {
                    Intrinsics.checkNotNullParameter(miniFlow, "<set-?>");
                    this.flow = miniFlow;
                }

                @NotNull
                public final ArrayDeque<Map<Name, FirProperty>> getVariableDeclarations() {
                    return this.variableDeclarations;
                }

                @NotNull
                public final Map<FirProperty, List<Assignment>> getAssignments() {
                    return this.assignments;
                }

                @NotNull
                public final Map<Object, Fork> getForks() {
                    return this.forks;
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u001a\u0010\f\u001a\u00020\u000b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "", "", "parents", "<init>", "(Ljava/util/Set;)V", "fork", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "Ljava/util/Set;", "getParents", "()Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "assignedLater", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "getAssignedLater", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "Companion"})
        private static final class MiniFlow {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Set<MiniFlow> parents;
            @NotNull
            private final VariableAssignments assignedLater;

            public MiniFlow(@NotNull Set<MiniFlow> parents2) {
                Intrinsics.checkNotNullParameter(parents2, "parents");
                this.parents = parents2;
                this.assignedLater = new VariableAssignments();
            }

            @NotNull
            public final Set<MiniFlow> getParents() {
                return this.parents;
            }

            @NotNull
            public final VariableAssignments getAssignedLater() {
                return this.assignedLater;
            }

            @NotNull
            public final MiniFlow fork() {
                return new MiniFlow(SetsKt.setOf(this));
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;", "start", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$MiniFlow;"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final MiniFlow start() {
                    return new MiniFlow(SetsKt.emptySet());
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0087\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0017\u001a\u00020\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0006H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bR&\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001d0\u001c8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;", "get", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Ljava/util/Set;", "", "contains", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)Z", "assignment", "add", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$Assignment;)Z", "copy", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;", "other", "merge", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FirLocalVariableAssignmentAnalyzer$Companion$VariableAssignments;)Z", "properties", "", "retain", "(Ljava/util/Set;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getAssignedProperties", "()Ljava/util/Set;", "", "", "assignments", "Ljava/util/Map;"})
        private static final class VariableAssignments {
            @NotNull
            private final Map<FirProperty, Set<Assignment>> assignments = new LinkedHashMap();

            @Nullable
            public final Set<Assignment> get(@NotNull FirProperty property) {
                Intrinsics.checkNotNullParameter(property, "property");
                return this.assignments.get(property);
            }

            public final boolean contains(@NotNull FirProperty property) {
                Intrinsics.checkNotNullParameter(property, "property");
                return this.assignments.containsKey(property);
            }

            public final boolean add(@NotNull FirProperty property, @NotNull Assignment assignment) {
                Set set;
                Intrinsics.checkNotNullParameter(property, "property");
                Intrinsics.checkNotNullParameter(assignment, "assignment");
                Map<FirProperty, Set<Assignment>> $this$getOrPut$iv = this.assignments;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(property);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(property, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                return set.add((Assignment)assignment);
            }

            @NotNull
            public final VariableAssignments copy() {
                VariableAssignments copy2 = new VariableAssignments();
                copy2.assignments.putAll(this.assignments);
                return copy2;
            }

            public final boolean merge(@Nullable VariableAssignments other) {
                if (other == null || other.assignments.isEmpty()) {
                    return false;
                }
                boolean modified = false;
                for (Map.Entry<FirProperty, Set<Assignment>> entry : other.assignments.entrySet()) {
                    Set set;
                    FirProperty property = entry.getKey();
                    Set<Assignment> values2 = entry.getValue();
                    boolean bl = modified;
                    Map<FirProperty, Set<Assignment>> $this$getOrPut$iv = this.assignments;
                    boolean $i$f$getOrPut = false;
                    Set value$iv = $this$getOrPut$iv.get(property);
                    if (value$iv == null) {
                        boolean bl2 = bl;
                        boolean bl3 = false;
                        Set set2 = new LinkedHashSet();
                        bl = bl2;
                        Set answer$iv = set2;
                        $this$getOrPut$iv.put(property, answer$iv);
                        set = answer$iv;
                    } else {
                        set = value$iv;
                    }
                    modified = bl | set.addAll((Collection<Assignment>)values2);
                }
                return modified;
            }

            public final void retain(@NotNull Set<? extends FirProperty> properties2) {
                Intrinsics.checkNotNullParameter(properties2, "properties");
                this.assignments.keySet().retainAll((Collection)properties2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<FirPropertySymbol> getAssignedProperties() {
                void var2_3;
                void $this$mapTo$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.assignments.entrySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block5: {
                        Map.Entry entry = (Map.Entry)element$iv$iv;
                        boolean bl2 = false;
                        Set v = (Set)entry.getValue();
                        Iterable $this$any$iv = v;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Assignment it = (Assignment)element$iv;
                                boolean bl3 = false;
                                if (!(!it.getOperatorAssignment())) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Collection destination$iv = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    Map.Entry entry = (Map.Entry)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    FirProperty k = (FirProperty)entry.getKey();
                    collection.add(k.getSymbol());
                }
                return (Set)var2_3;
            }
        }
    }
}

