/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Implication;
import org.jetbrains.kotlin.fir.resolve.dfa.LogicSystemKt;
import org.jetbrains.kotlin.fir.resolve.dfa.ModelKt;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.MutableTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.Operation;
import org.jetbrains.kotlin.fir.resolve.dfa.OperationStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentTypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.RealVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.Statement;
import org.jetbrains.kotlin.fir.resolve.dfa.SyntheticVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.resolve.dfa.VariableStorage;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\b\u001a\u00020\u0007*\u00020\u0006H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ3\u0010\u0010\u001a\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0018J!\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ5\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190 2\u0006\u0010\u0012\u001a\u00020\u000f2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001eH\u0007\u00a2\u0006\u0004\b!\u0010\"J\u001d\u0010%\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J=\u0010,\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020'2\u0016\b\u0002\u0010+\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010#0*\u00a2\u0006\u0004\b,\u0010-J/\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001e2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020.H\u0007\u00a2\u0006\u0004\b/\u00100J7\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001e2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020.2\u0006\u00101\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b/\u00102J%\u00106\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u00132\u0006\u00105\u001a\u000204\u00a2\u0006\u0004\b6\u00107J%\u0010:\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u0013\u00a2\u0006\u0004\b:\u0010;J%\u0010:\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u0013\u00a2\u0006\u0004\b:\u0010<J!\u0010=\u001a\u00020\u0016*\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b=\u0010>J!\u0010?\u001a\u00020\u0016*\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b?\u0010>J)\u0010A\u001a\u00020\u0016*\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010@\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\bA\u0010BJ1\u0010C\u001a\u00020\u0016*\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bC\u0010DJ!\u0010E\u001a\u00020\u0016*\u00020\u000f2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\bE\u0010>J%\u0010G\u001a\u00020\u0016*\u00020\u000f2\u0006\u00103\u001a\u00020\u00132\b\u0010F\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\bG\u0010\u0018JI\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001e2\u0018\u0010I\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0H0\u001d2\u0006\u0010J\u001a\u00020.2\u0006\u00101\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b/\u0010KJO\u0010N\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001e2\u0016\u0010L\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001e2\u0016\u0010M\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001eH\u0007\u00a2\u0006\u0004\bN\u0010OJO\u0010P\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001e2\u0016\u0010L\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001e2\u0016\u0010M\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001eH\u0007\u00a2\u0006\u0004\bP\u0010OJ\u001c\u0010S\u001a\u00020\u0016*\u00020Q2\u0006\u0010R\u001a\u00020\u0019H\u0082\u0002\u00a2\u0006\u0004\bS\u0010TJ!\u0010U\u001a\u00020\u00192\b\u00108\u001a\u0004\u0018\u00010\u00192\u0006\u00109\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\bU\u0010VJ\u001f\u0010U\u001a\u0004\u0018\u00010\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\nH\u0007\u00a2\u0006\u0004\bU\u0010WJ\u001f\u0010X\u001a\u0004\u0018\u00010\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\nH\u0007\u00a2\u0006\u0004\bX\u0010WR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010YR\u0011\u0010]\u001a\u00020Z8G\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u0014\u0010_\u001a\u00020^8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b_\u0010`R\u0014\u0010a\u001a\u00020^8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\ba\u0010`R\u0014\u0010e\u001a\u00020b8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bc\u0010d"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/LogicSystem;", "", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "context", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;)V", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "", "isAcceptableForSmartcast", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "flows", "statementFlows", "union", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;", "joinFlow", "(Ljava/util/Collection;Ljava/util/Collection;Z)Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "alias", "underlyingVariable", "", "addLocalVariableAlias", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "statement", "addTypeStatement", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;)Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatements;", "statements", "", "addTypeStatements", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Ljava/util/Map;)Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Implication;", "implication", "addImplication", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/Implication;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "originalVariable", "newVariable", "Lkotlin/Function1;", "transform", "translateVariableFromConditionInStatements", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;Lkotlin/jvm/functions/Function1;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/OperationStatement;", "approveOperationStatement", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/OperationStatement;)Ljava/util/Map;", "removeApprovedOrImpossible", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/OperationStatement;Z)Ljava/util/Map;", "variable", "", "index", "recordNewAssignment", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;I)V", "a", "b", "isSameValueIn", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;)Z", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;)Z", "mergeAssignments", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Ljava/util/Collection;)V", "copyCommonAliases", "commonFlow", "copyNonConflictingAliases", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Ljava/util/Collection;Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;)V", "copyStatements", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableFlow;Ljava/util/Collection;Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;Z)V", "copyImplications", "replacement", "replaceVariable", "Lkotlinx/collections/immutable/PersistentList;", "logicStatements", "approvedStatement", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/resolve/dfa/OperationStatement;Z)Ljava/util/Map;", "left", "right", "orForTypeStatements", "(Ljava/util/Map;Ljava/util/Map;)Ljava/util/Map;", "andForTypeStatements", "Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableTypeStatement;", "other", "plusAssign", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/MutableTypeStatement;Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;)V", "and", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;)Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "(Ljava/util/Collection;)Lorg/jetbrains/kotlin/fir/resolve/dfa/TypeStatement;", "or", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "nullableNothingType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "anyType", "Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorage;", "getVariableStorage", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/VariableStorage;", "variableStorage"})
public abstract class LogicSystem {
    @NotNull
    private final ConeInferenceContext context;
    @NotNull
    private final ConeClassLikeType nullableNothingType;
    @NotNull
    private final ConeClassLikeType anyType;

    public LogicSystem(@NotNull ConeInferenceContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.nullableNothingType = this.getSession().getBuiltinTypes().getNullableNothingType().getConeType();
        this.anyType = this.getSession().getBuiltinTypes().getAnyType().getConeType();
    }

    @NotNull
    public final FirSession getSession() {
        return this.context.getSession();
    }

    @NotNull
    public abstract VariableStorage getVariableStorage();

    protected boolean isAcceptableForSmartcast(@NotNull ConeKotlinType $this$isAcceptableForSmartcast) {
        Intrinsics.checkNotNullParameter($this$isAcceptableForSmartcast, "<this>");
        return !ConeBuiltinTypeUtilsKt.isNullableNothing($this$isAcceptableForSmartcast);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MutableFlow joinFlow(@NotNull Collection<PersistentFlow> flows, @NotNull Collection<PersistentFlow> statementFlows, boolean union) {
        Intrinsics.checkNotNullParameter(flows, "flows");
        Intrinsics.checkNotNullParameter(statementFlows, "statementFlows");
        switch (flows.size()) {
            case 0: {
                return new MutableFlow();
            }
            case 1: {
                return ((PersistentFlow)CollectionsKt.first((Iterable)flows)).fork();
            }
        }
        Iterable $this$reduce$iv = flows;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            PersistentFlow persistentFlow = (PersistentFlow)iterator$iv.next();
            PersistentFlow a = (PersistentFlow)accumulator$iv;
            boolean bl = false;
            if (a.lowestCommonAncestor((PersistentFlow)b) != null) continue;
            throw new IllegalStateException(("no common ancestor in " + a + ", " + b).toString());
        }
        PersistentFlow commonFlow = (PersistentFlow)accumulator$iv;
        MutableFlow result2 = commonFlow.fork();
        this.mergeAssignments(result2, flows);
        if (union) {
            this.copyNonConflictingAliases(result2, flows, commonFlow);
        } else {
            this.copyCommonAliases(result2, flows);
        }
        this.copyStatements(result2, statementFlows, commonFlow, union);
        this.copyImplications(result2, statementFlows);
        return result2;
    }

    public final void addLocalVariableAlias(@NotNull MutableFlow flow, @NotNull RealVariable alias, @NotNull RealVariable underlyingVariable) {
        Intrinsics.checkNotNullParameter(flow, "flow");
        Intrinsics.checkNotNullParameter(alias, "alias");
        Intrinsics.checkNotNullParameter(underlyingVariable, "underlyingVariable");
        if (Intrinsics.areEqual(underlyingVariable, alias)) {
            return;
        }
        ((Map)flow.getDirectAliasMap$semantics()).put(alias, underlyingVariable);
        Map map2 = flow.getBackwardsAliasMap$semantics();
        PersistentSet<RealVariable> persistentSet = (PersistentSet<RealVariable>)flow.getBackwardsAliasMap$semantics().get(underlyingVariable);
        if (persistentSet == null || (persistentSet = persistentSet.add(alias)) == null) {
            RealVariable[] realVariableArray = new RealVariable[]{alias};
            persistentSet = ExtensionsKt.persistentSetOf(realVariableArray);
        }
        PersistentSet<RealVariable> persistentSet2 = persistentSet;
        map2.put(underlyingVariable, persistentSet2);
    }

    @Nullable
    public final TypeStatement addTypeStatement(@NotNull MutableFlow flow, @NotNull TypeStatement statement) {
        PersistentTypeStatement persistentTypeStatement;
        PersistentSet newExactType;
        Intrinsics.checkNotNullParameter(flow, "flow");
        Intrinsics.checkNotNullParameter(statement, "statement");
        if (statement.getExactType().isEmpty()) {
            return null;
        }
        RealVariable variable = statement.getVariable();
        PersistentTypeStatement persistentTypeStatement2 = (PersistentTypeStatement)flow.getApprovedTypeStatements$semantics().get(variable);
        PersistentSet oldExactType = persistentTypeStatement2 != null ? persistentTypeStatement2.getExactType() : null;
        PersistentSet persistentSet = oldExactType;
        if (persistentSet == null || (persistentSet = persistentSet.addAll(statement.getExactType())) == null) {
            persistentSet = ExtensionsKt.toPersistentSet((Iterable)statement.getExactType());
        }
        if ((newExactType = persistentSet) == oldExactType) {
            return null;
        }
        PersistentTypeStatement it = persistentTypeStatement = new PersistentTypeStatement(variable, newExactType);
        boolean bl = false;
        ((Map)flow.getApprovedTypeStatements$semantics()).put(variable, it);
        return persistentTypeStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TypeStatement> addTypeStatements(@NotNull MutableFlow flow, @NotNull Map<RealVariable, ? extends TypeStatement> statements) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(flow, "flow");
        Intrinsics.checkNotNullParameter(statements, "statements");
        Iterable $this$mapNotNull$iv = statements.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeStatement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            TypeStatement it = (TypeStatement)element$iv$iv;
            boolean bl2 = false;
            if (this.addTypeStatement(flow, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void addImplication(@NotNull MutableFlow flow, @NotNull Implication implication) {
        boolean redundant;
        boolean bl;
        Intrinsics.checkNotNullParameter(flow, "flow");
        Intrinsics.checkNotNullParameter(implication, "implication");
        Statement effect = implication.getEffect();
        if (Intrinsics.areEqual(effect, implication.getCondition())) return;
        if (effect instanceof TypeStatement) {
            boolean bl2;
            if (((TypeStatement)effect).isEmpty()) return;
            Object object = (PersistentTypeStatement)flow.getApprovedTypeStatements$semantics().get(((TypeStatement)effect).getVariable());
            if (object != null && (object = ((PersistentTypeStatement)object).getExactType()) != null) {
                if (object.containsAll((Collection)((TypeStatement)effect).getExactType())) {
                    return;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return;
            }
            bl = false;
        } else {
            if (effect.getVariable() instanceof SyntheticVariable && !((Map)flow.getImplications$semantics()).containsKey(effect.getVariable())) {
                return;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        boolean bl3 = redundant = false;
        if (redundant) {
            return;
        }
        DataFlowVariable variable = implication.getCondition().getVariable();
        Map map2 = flow.getImplications$semantics();
        PersistentList<Implication> persistentList = (PersistentList<Implication>)flow.getImplications$semantics().get(variable);
        if (persistentList == null || (persistentList = persistentList.add(implication)) == null) {
            Implication[] implicationArray = new Implication[]{implication};
            persistentList = ExtensionsKt.persistentListOf(implicationArray);
        }
        PersistentList<Implication> persistentList2 = persistentList;
        map2.put(variable, persistentList2);
    }

    /*
     * WARNING - void declaration
     */
    public final void translateVariableFromConditionInStatements(@NotNull MutableFlow flow, @NotNull DataFlowVariable originalVariable, @NotNull DataFlowVariable newVariable, @NotNull Function1<? super Implication, Implication> transform2) {
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(flow, "flow");
        Intrinsics.checkNotNullParameter(originalVariable, "originalVariable");
        Intrinsics.checkNotNullParameter(newVariable, "newVariable");
        Intrinsics.checkNotNullParameter(transform2, "transform");
        PersistentList statements = ModelKt.isSynthetic(originalVariable) ? (PersistentList)flow.getImplications$semantics().remove(originalVariable) : (PersistentList)flow.getImplications$semantics().get(originalVariable);
        Collection collection = statements;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        PersistentList persistentList = (PersistentList)flow.getImplications$semantics().get(newVariable);
        if (persistentList == null) {
            persistentList = ExtensionsKt.persistentListOf();
        }
        PersistentList existing = persistentList;
        Map map2 = flow.getImplications$semantics();
        PersistentList persistentList2 = statements;
        Collection destination$iv = existing.builder();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Implication it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Implication it = (Implication)element$iv;
            boolean bl2 = false;
            if (transform2.invoke(ModelKt.implies(new OperationStatement(newVariable, it.getCondition().getOperation()), it.getEffect())) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        persistentList2 = ((PersistentList.Builder)destination$iv).build();
        map2.put(newVariable, persistentList2);
    }

    public static /* synthetic */ void translateVariableFromConditionInStatements$default(LogicSystem logicSystem2, MutableFlow mutableFlow, DataFlowVariable dataFlowVariable, DataFlowVariable dataFlowVariable2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: translateVariableFromConditionInStatements");
        }
        if ((n & 8) != 0) {
            function1 = LogicSystem::translateVariableFromConditionInStatements$lambda$3;
        }
        logicSystem2.translateVariableFromConditionInStatements(mutableFlow, dataFlowVariable, dataFlowVariable2, function1);
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> approveOperationStatement(@NotNull PersistentFlow flow, @NotNull OperationStatement statement) {
        Intrinsics.checkNotNullParameter(flow, "flow");
        Intrinsics.checkNotNullParameter(statement, "statement");
        return this.approveOperationStatement(MapsKt.toMutableMap((Map)flow.getImplications$semantics()), statement, false);
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> approveOperationStatement(@NotNull MutableFlow flow, @NotNull OperationStatement statement, boolean removeApprovedOrImpossible) {
        Intrinsics.checkNotNullParameter(flow, "flow");
        Intrinsics.checkNotNullParameter(statement, "statement");
        return this.approveOperationStatement((Map<DataFlowVariable, ? extends PersistentList<Implication>>)flow.getImplications$semantics(), statement, removeApprovedOrImpossible);
    }

    public final void recordNewAssignment(@NotNull MutableFlow flow, @NotNull RealVariable variable, int index2) {
        Intrinsics.checkNotNullParameter(flow, "flow");
        Intrinsics.checkNotNullParameter(variable, "variable");
        this.replaceVariable(flow, variable, null);
        Integer n = index2;
        ((Map)flow.getAssignmentIndex$semantics()).put(variable, n);
    }

    public final boolean isSameValueIn(@NotNull PersistentFlow a, @NotNull PersistentFlow b, @NotNull RealVariable variable) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(variable, "variable");
        return Intrinsics.areEqual(a.getAssignmentIndex$semantics().get(variable), b.getAssignmentIndex$semantics().get(variable));
    }

    public final boolean isSameValueIn(@NotNull PersistentFlow a, @NotNull MutableFlow b, @NotNull RealVariable variable) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(variable, "variable");
        return Intrinsics.areEqual(a.getAssignmentIndex$semantics().get(variable), b.getAssignmentIndex$semantics().get(variable));
    }

    private final void mergeAssignments(MutableFlow $this$mergeAssignments, Collection<PersistentFlow> flows) {
        Map reassignedVariables = new LinkedHashMap();
        for (PersistentFlow entry : flows) {
            for (Map.Entry entry2 : ((Map)entry.getAssignmentIndex$semantics()).entrySet()) {
                RealVariable variable = (RealVariable)entry2.getKey();
                int index2 = ((Number)entry2.getValue()).intValue();
                Integer n = (Integer)$this$mergeAssignments.getAssignmentIndex$semantics().get(variable);
                int n2 = index2;
                if (n != null && n == n2) continue;
                Map map2 = reassignedVariables;
                Integer n3 = (Integer)reassignedVariables.get(variable);
                int n4 = n3 != null ? n3 : 0;
                Integer n5 = Math.max(index2, n4);
                map2.put(variable, n5);
            }
        }
        for (Map.Entry entry : reassignedVariables.entrySet()) {
            RealVariable variable = (RealVariable)entry.getKey();
            int index3 = ((Number)entry.getValue()).intValue();
            this.recordNewAssignment($this$mergeAssignments, variable, index3);
        }
    }

    private final void copyCommonAliases(MutableFlow $this$copyCommonAliases, Collection<PersistentFlow> flows) {
        for (Map.Entry entry : ((Map)((PersistentFlow)CollectionsKt.first((Iterable)flows)).getDirectAliasMap$semantics()).entrySet()) {
            boolean bl;
            RealVariable to;
            RealVariable from;
            block4: {
                from = (RealVariable)entry.getKey();
                to = (RealVariable)entry.getValue();
                if (Intrinsics.areEqual($this$copyCommonAliases.getDirectAliasMap$semantics().get(from), to)) continue;
                Iterable $this$all$iv = flows;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PersistentFlow it = (PersistentFlow)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual(it.unwrapVariable(from), to)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            this.addLocalVariableAlias($this$copyCommonAliases, from, to);
        }
    }

    private final void copyNonConflictingAliases(MutableFlow $this$copyNonConflictingAliases, Collection<PersistentFlow> flows, PersistentFlow commonFlow) {
        Map candidates = new LinkedHashMap();
        for (PersistentFlow entry : flows) {
            for (Map.Entry entry2 : ((Map)entry.getDirectAliasMap$semantics()).entrySet()) {
                RealVariable from = (RealVariable)entry2.getKey();
                RealVariable to = (RealVariable)entry2.getValue();
                Map map2 = candidates;
                if (Intrinsics.areEqual(commonFlow.getAssignmentIndex$semantics().get(from), entry.getAssignmentIndex$semantics().get(from))) continue;
                RealVariable realVariable = candidates.containsKey(from) && !Intrinsics.areEqual(candidates.get(from), to) ? null : to;
                map2.put(from, realVariable);
            }
        }
        for (Map.Entry entry : candidates.entrySet()) {
            RealVariable from = (RealVariable)entry.getKey();
            RealVariable to = (RealVariable)entry.getValue();
            RealVariable realVariable = to;
            if (realVariable == null) continue;
            this.addLocalVariableAlias($this$copyNonConflictingAliases, from, realVariable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void copyStatements(MutableFlow $this$copyStatements, Collection<PersistentFlow> flows, PersistentFlow commonFlow, boolean union) {
        void $this$forEach$iv;
        void destination$iv;
        Iterable $this$flatMapTo$iv;
        Iterable iterable = flows;
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PersistentFlow it = (PersistentFlow)element$iv;
            boolean bl2 = false;
            Iterable list$iv = it.getKnownVariables();
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        $this$flatMapTo$iv = (Iterable)destination$iv;
        boolean $i$f$forEach = false;
        block1: for (Object element$iv : $this$forEach$iv) {
            TypeStatement statement;
            TypeStatement typeStatement;
            Iterator it;
            Iterable iterable2;
            Iterable destination$iv2;
            Iterable $this$mapTo$iv;
            Object object;
            RealVariable variable = (RealVariable)element$iv;
            boolean bl = false;
            if (((Map)$this$copyStatements.getDirectAliasMap$semantics()).containsKey(variable)) continue;
            if (!union) {
                Iterable bl2 = flows;
                Collection collection2 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    PersistentFlow persistentFlow = (PersistentFlow)item$iv;
                    iterable2 = destination$iv2;
                    boolean bl3 = false;
                    TypeStatement typeStatement2 = ((PersistentFlow)((Object)it)).getTypeStatement(variable);
                    if (typeStatement2 == null) continue block1;
                    iterable2.add(typeStatement2);
                }
                typeStatement = ((LogicSystem)object).or((Collection<? extends TypeStatement>)destination$iv2);
            } else if (Intrinsics.areEqual($this$copyStatements.getAssignmentIndex$semantics().get(variable), commonFlow.getAssignmentIndex$semantics().get(variable))) {
                void $this$mapNotNullTo$iv;
                $this$mapTo$iv = flows;
                destination$iv2 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach2 = false;
                it = $this$forEach$iv$iv.iterator();
                while (it.hasNext()) {
                    TypeStatement it$iv;
                    Object element$iv$iv;
                    Object element$iv2 = element$iv$iv = it.next();
                    boolean bl4 = false;
                    PersistentFlow it2 = (PersistentFlow)element$iv2;
                    boolean bl5 = false;
                    if (it2.getTypeStatement(variable) == null) continue;
                    boolean bl6 = false;
                    destination$iv2.add(it$iv);
                }
                typeStatement = ((LogicSystem)object).and((Collection<? extends TypeStatement>)destination$iv2);
            } else {
                void $this$mapTo$iv2;
                Collection destination$iv3;
                Iterable $this$groupByTo$iv;
                destination$iv2 = flows;
                Map $i$f$mapNotNullTo = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv3 : $this$groupByTo$iv) {
                    Object object2;
                    PersistentFlow it3 = (PersistentFlow)element$iv3;
                    boolean bl7 = false;
                    Integer n = (Integer)it3.getAssignmentIndex$semantics().get(variable);
                    Integer key$iv = n != null ? n : -1;
                    void $this$getOrPut$iv$iv = destination$iv3;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                    if (value$iv$iv == null) {
                        boolean bl8 = false;
                        List answer$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                        object2 = answer$iv$iv;
                    } else {
                        object2 = value$iv$iv;
                    }
                    List list$iv = (List)object2;
                    it3 = (PersistentFlow)element$iv3;
                    object = list$iv;
                    boolean bl9 = false;
                    object.add(it3.getTypeStatement(variable));
                }
                void byAssignment = destination$iv3;
                Integer n = (Integer)commonFlow.getAssignmentIndex$semantics().get(variable);
                byAssignment.remove(n != null ? n : -1);
                $this$groupByTo$iv = byAssignment.values();
                destination$iv3 = new LinkedHashSet();
                object = this;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv2) {
                    List it4 = (List)item$iv;
                    iterable2 = destination$iv3;
                    boolean bl10 = false;
                    TypeStatement typeStatement3 = this.and(CollectionsKt.filterNotNull(it4));
                    if (typeStatement3 == null) continue block1;
                    iterable2.add(typeStatement3);
                }
                typeStatement = ((LogicSystem)object).or(destination$iv3);
            }
            TypeStatement typeStatement4 = statement = typeStatement;
            boolean bl11 = typeStatement4 != null ? typeStatement4.isNotEmpty() : false;
            if (!bl11) continue;
            ((Map)$this$copyStatements.getApprovedTypeStatements$semantics()).put(variable, LogicSystemKt.access$toPersistent(statement));
        }
    }

    private final void copyImplications(MutableFlow $this$copyImplications, Collection<PersistentFlow> flows) {
        switch (flows.size()) {
            case 0: {
                break;
            }
            case 1: {
                ((Map)$this$copyImplications.getImplications$semantics()).putAll((Map)((PersistentFlow)CollectionsKt.first((Iterable)flows)).getImplications$semantics());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceVariable(MutableFlow $this$replaceVariable, RealVariable variable, RealVariable replacement) {
        RealVariable original = (RealVariable)$this$replaceVariable.getDirectAliasMap$semantics().remove(variable);
        if (original != null) {
            PersistentSet siblings2;
            if (AbstractTypeChecker.RUN_SLOW_ASSERTIONS) {
                boolean bl;
                boolean bl2 = bl = !((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                boolean bl3 = bl = !((Map)$this$replaceVariable.getImplications$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                boolean bl4 = bl = !((Map)$this$replaceVariable.getApprovedTypeStatements$semantics()).containsKey(variable);
                if (_Assertions.ENABLED && !bl) {
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
            }
            if ((siblings2 = (PersistentSet)MapsKt.getValue((Map)$this$replaceVariable.getBackwardsAliasMap$semantics(), original)).size() > 1) {
                ((Map)$this$replaceVariable.getBackwardsAliasMap$semantics()).put(original, siblings2.remove(variable));
            } else {
                $this$replaceVariable.getBackwardsAliasMap$semantics().remove(original);
            }
            if (replacement != null) {
                this.addLocalVariableAlias($this$replaceVariable, replacement, original);
            }
        } else {
            PersistentSet aliases = (PersistentSet)$this$replaceVariable.getBackwardsAliasMap$semantics().remove(variable);
            RealVariable realVariable = replacement;
            if (realVariable == null) {
                PersistentSet persistentSet = aliases;
                realVariable = persistentSet != null ? (RealVariable)CollectionsKt.first(persistentSet) : null;
            }
            RealVariable replacementOrNext = realVariable;
            this.getVariableStorage().replaceReceiverReferencesInMembers(variable, replacementOrNext, (arg_0, arg_1) -> LogicSystem.replaceVariable$lambda$13(this, $this$replaceVariable, arg_0, arg_1));
            LogicSystemKt.access$replaceVariableInImplications($this$replaceVariable.getImplications$semantics(), variable, replacementOrNext);
            LogicSystemKt.access$replaceVariableInStatements($this$replaceVariable.getApprovedTypeStatements$semantics(), variable, replacementOrNext);
            if (aliases != null && replacementOrNext != null) {
                ((Map)$this$replaceVariable.getDirectAliasMap$semantics()).remove(replacementOrNext);
                Iterable $this$minus$iv = aliases;
                boolean $i$f$minus = false;
                PersistentSet<RealVariable> withoutSelf = $this$minus$iv.remove(replacementOrNext);
                if (!((Collection)withoutSelf).isEmpty()) {
                    void $this$associateWithTo$iv;
                    $this$minus$iv = withoutSelf;
                    Map destination$iv = $this$replaceVariable.getDirectAliasMap$semantics();
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv : $this$associateWithTo$iv) {
                        RealVariable realVariable2 = (RealVariable)element$iv;
                        Object t = element$iv;
                        Map map2 = destination$iv;
                        boolean bl = false;
                        RealVariable realVariable3 = replacementOrNext;
                        map2.put(t, realVariable3);
                    }
                    Map map3 = $this$replaceVariable.getBackwardsAliasMap$semantics();
                    PersistentSet<RealVariable> persistentSet = (PersistentSet<RealVariable>)$this$replaceVariable.getBackwardsAliasMap$semantics().get(replacementOrNext);
                    if (persistentSet == null || (persistentSet = persistentSet.addAll((Collection<RealVariable>)withoutSelf)) == null) {
                        persistentSet = withoutSelf;
                    }
                    PersistentSet<RealVariable> persistentSet2 = persistentSet;
                    map3.put(replacementOrNext, persistentSet2);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<RealVariable, TypeStatement> approveOperationStatement(Map<DataFlowVariable, ? extends PersistentList<Implication>> logicStatements, OperationStatement approvedStatement, boolean removeApprovedOrImpossible) {
        LinkedList linkedList;
        Map result2 = new LinkedHashMap();
        LinkedList $this$approveOperationStatement_u24lambda_u2415 = linkedList = new LinkedList();
        boolean bl = false;
        ((Collection)$this$approveOperationStatement_u24lambda_u2415).add(approvedStatement);
        LinkedList queue = linkedList;
        Set approved = new LinkedHashSet();
        while (!((Collection)queue).isEmpty()) {
            PersistentList<Implication> statements;
            PersistentList<Implication> stillUnknown;
            Object e = queue.removeFirst();
            Intrinsics.checkNotNullExpressionValue(e, "removeFirst(...)");
            OperationStatement next = (OperationStatement)e;
            if (!removeApprovedOrImpossible && !approved.add(next)) continue;
            Operation operation = next.getOperation();
            DataFlowVariable variable = next.getVariable();
            if (ModelKt.isReal(variable)) {
                Object object;
                void $this$getOrPut$iv;
                ConeClassLikeType impliedType = operation == Operation.EqNull ? this.nullableNothingType : this.anyType;
                Map map2 = result2;
                DataFlowVariable key$iv = variable;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    MutableTypeStatement answer$iv = new MutableTypeStatement((RealVariable)variable, null, 2, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((MutableTypeStatement)object).getExactType().add(impliedType);
            }
            if (logicStatements.get(variable) == null || Intrinsics.areEqual(stillUnknown = statements.removeAll(arg_0 -> LogicSystem.approveOperationStatement$lambda$18(operation, queue, this, result2, removeApprovedOrImpossible, arg_0)), statements) || !TypeIntrinsics.isMutableMap(logicStatements)) continue;
            if (stillUnknown.isEmpty()) {
                logicStatements.remove(variable);
                continue;
            }
            logicStatements.put(variable, stillUnknown);
        }
        return result2;
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> orForTypeStatements(@NotNull Map<RealVariable, ? extends TypeStatement> left, @NotNull Map<RealVariable, ? extends TypeStatement> right) {
        Map<RealVariable, TypeStatement> map2;
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        if (left.isEmpty()) {
            map2 = left;
        } else if (right.isEmpty()) {
            map2 = right;
        } else {
            Map<RealVariable, TypeStatement> map3;
            Map<RealVariable, TypeStatement> $this$orForTypeStatements_u24lambda_u2419 = map3 = MapsKt.createMapBuilder();
            boolean bl = false;
            for (Map.Entry<RealVariable, TypeStatement> entry : left.entrySet()) {
                RealVariable variable = entry.getKey();
                TypeStatement leftStatement = entry.getValue();
                TypeStatement[] typeStatementArray = new TypeStatement[2];
                typeStatementArray[0] = leftStatement;
                if (right.get(variable) == null) continue;
                typeStatementArray[1] = typeStatementArray[1];
                TypeStatement typeStatement = this.or((Collection<? extends TypeStatement>)CollectionsKt.listOf(typeStatementArray));
                if (typeStatement == null) continue;
                $this$orForTypeStatements_u24lambda_u2419.put(variable, typeStatement);
            }
            map2 = MapsKt.build(map3);
        }
        return map2;
    }

    @NotNull
    public final Map<RealVariable, TypeStatement> andForTypeStatements(@NotNull Map<RealVariable, ? extends TypeStatement> left, @NotNull Map<RealVariable, ? extends TypeStatement> right) {
        Map<RealVariable, TypeStatement> map2;
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        if (left.isEmpty()) {
            map2 = right;
        } else if (right.isEmpty()) {
            map2 = left;
        } else {
            Map<RealVariable, ? extends TypeStatement> map3;
            Map<RealVariable, ? extends TypeStatement> $this$andForTypeStatements_u24lambda_u2420 = map3 = MapsKt.toMutableMap(left);
            boolean bl = false;
            for (Map.Entry<RealVariable, TypeStatement> entry : right.entrySet()) {
                RealVariable variable = entry.getKey();
                TypeStatement rightStatement = entry.getValue();
                $this$andForTypeStatements_u24lambda_u2420.put(variable, this.and($this$andForTypeStatements_u24lambda_u2420.get(variable), rightStatement));
            }
            map2 = map3;
        }
        return map2;
    }

    private final void plusAssign(MutableTypeStatement $this$plusAssign, TypeStatement other) {
        Intrinsics.checkNotNullParameter($this$plusAssign, "<this>");
        CollectionsKt.addAll((Collection)$this$plusAssign.getExactType(), (Iterable)other.getExactType());
    }

    @NotNull
    public final TypeStatement and(@Nullable TypeStatement a, @NotNull TypeStatement b) {
        TypeStatement typeStatement;
        Intrinsics.checkNotNullParameter(b, "b");
        TypeStatement typeStatement2 = a;
        if (typeStatement2 != null && (typeStatement2 = LogicSystemKt.access$toMutable(typeStatement2)) != null) {
            TypeStatement typeStatement3;
            TypeStatement $this$and_u24lambda_u2421 = typeStatement3 = typeStatement2;
            boolean bl = false;
            this.plusAssign((MutableTypeStatement)$this$and_u24lambda_u2421, b);
            typeStatement = typeStatement3;
        } else {
            typeStatement = b;
        }
        return typeStatement;
    }

    @Nullable
    public final TypeStatement and(@NotNull Collection<? extends TypeStatement> statements) {
        Intrinsics.checkNotNullParameter(statements, "statements");
        switch (statements.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (TypeStatement)CollectionsKt.first((Iterable)statements);
            }
        }
        Iterator<? extends TypeStatement> iterator2 = statements.iterator();
        MutableTypeStatement result2 = LogicSystemKt.access$toMutable(iterator2.next());
        while (iterator2.hasNext()) {
            this.plusAssign(result2, iterator2.next());
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TypeStatement or(@NotNull Collection<? extends TypeStatement> statements) {
        ConeKotlinType coneKotlinType;
        void $this$mapTo$iv$iv;
        boolean bl;
        Object element$iv2;
        RealVariable variable;
        block19: {
            boolean $this$all$iv2;
            TypeStatement it;
            block18: {
                boolean bl2;
                Intrinsics.checkNotNullParameter(statements, "statements");
                switch (statements.size()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return (TypeStatement)CollectionsKt.first((Iterable)statements);
                    }
                }
                variable = ((TypeStatement)CollectionsKt.first((Iterable)statements)).getVariable();
                Iterable $this$all$iv2 = statements;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        it = (TypeStatement)element$iv2;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual(it.getVariable(), variable)) continue;
                        bl2 = false;
                        break block18;
                    }
                    bl2 = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                boolean $i$a$-assert-LogicSystem$or$32 = false;
                String $i$a$-assert-LogicSystem$or$32 = "folding statements for different variables";
                throw new AssertionError((Object)$i$a$-assert-LogicSystem$or$32);
            }
            Iterable $this$any$iv = statements;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    it = (TypeStatement)element$iv2;
                    boolean bl4 = false;
                    if (!it.isEmpty()) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        Iterable $this$map$iv = statements;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeStatement typeStatement = (TypeStatement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(ConeTypeIntersector.INSTANCE.intersectTypes(this.context, CollectionsKt.toList((Iterable)it.getExactType())));
        }
        List intersected = (List)destination$iv$iv;
        ConeKotlinType coneKotlinType2 = TypeUtilsKt.commonSuperTypeOrNull(this.context, intersected);
        if (coneKotlinType2 == null) {
            return null;
        }
        ConeKotlinType unified = coneKotlinType2;
        if (ConeBuiltinTypeUtilsKt.isNullableAny(unified)) {
            return null;
        }
        if (this.isAcceptableForSmartcast(unified)) {
            coneKotlinType = unified;
        } else {
            if (TypeUtilsKt.canBeNull(unified, this.context.getSession())) {
                return null;
            }
            coneKotlinType = this.context.anyType();
        }
        ConeKotlinType result2 = coneKotlinType;
        ConeKotlinType[] coneKotlinTypeArray = new ConeKotlinType[]{result2};
        return new PersistentTypeStatement(variable, ExtensionsKt.persistentSetOf(coneKotlinTypeArray));
    }

    private static final Implication translateVariableFromConditionInStatements$lambda$3(Implication it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it;
    }

    private static final Unit replaceVariable$lambda$13(LogicSystem this$0, MutableFlow $this_replaceVariable, RealVariable old, RealVariable realVariable) {
        Intrinsics.checkNotNullParameter(old, "old");
        this$0.replaceVariable($this_replaceVariable, old, realVariable);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean approveOperationStatement$lambda$18(Operation $operation, LinkedList $queue, LogicSystem this$0, Map $result, boolean $removeApprovedOrImpossible, Implication it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Boolean knownValue = it.getCondition().getOperation().valueIfKnown($operation);
        if (Intrinsics.areEqual(knownValue, true)) {
            Statement effect = it.getEffect();
            if (effect instanceof OperationStatement) {
                ((Collection)$queue).add(effect);
            } else if (effect instanceof TypeStatement) {
                Object object;
                void $this$getOrPut$iv;
                LogicSystem logicSystem2 = this$0;
                Map map2 = $result;
                RealVariable key$iv = ((TypeStatement)effect).getVariable();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    LogicSystem logicSystem3 = logicSystem2;
                    boolean bl = false;
                    logicSystem2 = logicSystem3;
                    MutableTypeStatement answer$iv = new MutableTypeStatement(((TypeStatement)effect).getVariable(), null, 2, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                logicSystem2.plusAssign((MutableTypeStatement)object, (TypeStatement)effect);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return $removeApprovedOrImpossible && knownValue != null;
    }
}

