/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.GraphExitNodeMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ7\u0010\u0010\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r2\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R6\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00188\u0017@VX\u0096.\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ClassExitNode;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNodeWithSubgraphs;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/GraphExitNodeMarker;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "owner", "fir", "", "level", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;Lorg/jetbrains/kotlin/fir/declarations/FirClass;I)V", "R", "D", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "visitor", "data", "accept", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getFir", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "", "isUnion", "()Z", "", "value", "subGraphs", "Ljava/util/List;", "getSubGraphs", "()Ljava/util/List;", "setSubGraphs", "(Ljava/util/List;)V"})
public final class ClassExitNode
extends CFGNodeWithSubgraphs<FirClass>
implements GraphExitNodeMarker {
    @NotNull
    private final FirClass fir;
    public List<ControlFlowGraph> subGraphs;

    public ClassExitNode(@NotNull ControlFlowGraph owner, @NotNull FirClass fir, int level) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(fir, "fir");
        super(owner, level, null);
        this.fir = fir;
    }

    @Override
    @NotNull
    public FirClass getFir() {
        return this.fir;
    }

    @Override
    public boolean isUnion() {
        return this.getFir() instanceof FirAnonymousObject && ((FirAnonymousObject)this.getFir()).getClassKind() != ClassKind.ENUM_ENTRY;
    }

    @Override
    @NotNull
    public List<ControlFlowGraph> getSubGraphs() {
        List<ControlFlowGraph> list = this.subGraphs;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("subGraphs");
        return null;
    }

    public void setSubGraphs(@NotNull List<ControlFlowGraph> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.subGraphs = list;
    }

    @Override
    public <R, D> R accept(@NotNull ControlFlowGraphVisitor<? extends R, ? super D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitClassExitNode(this, data2);
    }
}

