/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00016B!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R*\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a8\u0006@FX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R8\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"8\u0007@BX\u0086.\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R2\u0010(\u001a\u0006\u0012\u0002\b\u00030#2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030#8\u0007@FX\u0087.\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R2\u0010.\u001a\u0006\u0012\u0002\b\u00030#2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030#8\u0007@FX\u0086.\u00a2\u0006\u0012\n\u0004\b.\u0010)\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u0011\u00102\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020\u00000\"8G\u00a2\u0006\u0006\u001a\u0004\b4\u0010'"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "", "name", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;", "kind", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/lang/String;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;)V", "", "complete", "()V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "visitor", "traverse", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;", "getKind", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;", "", "value", "nodeCount", "I", "getNodeCount", "()I", "setNodeCount", "(I)V", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "nodes", "Ljava/util/List;", "getNodes", "()Ljava/util/List;", "enterNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "getEnterNode", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "setEnterNode", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)V", "exitNode", "getExitNode", "setExitNode", "", "isSubGraph", "()Z", "getSubGraphs", "subGraphs", "Kind"})
public final class ControlFlowGraph {
    @Nullable
    private final FirDeclaration declaration;
    @NotNull
    private final String name;
    @NotNull
    private final Kind kind;
    private int nodeCount;
    private List<? extends CFGNode<?>> nodes;
    public CFGNode<?> enterNode;
    public CFGNode<?> exitNode;

    public ControlFlowGraph(@Nullable FirDeclaration declaration, @NotNull String name, @NotNull Kind kind) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        this.declaration = declaration;
        this.name = name;
        this.kind = kind;
    }

    @Nullable
    public final FirDeclaration getDeclaration() {
        return this.declaration;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    public final int getNodeCount() {
        return this.nodeCount;
    }

    public final void setNodeCount(int n) {
        this.nodeCount = n;
    }

    @NotNull
    public final List<CFGNode<?>> getNodes() {
        List<CFGNode<?>> list = this.nodes;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("nodes");
        return null;
    }

    @NotNull
    public final CFGNode<?> getEnterNode() {
        CFGNode<?> cFGNode = this.enterNode;
        if (cFGNode != null) {
            return cFGNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException("enterNode");
        return null;
    }

    public final void setEnterNode(@NotNull CFGNode<?> cFGNode) {
        Intrinsics.checkNotNullParameter(cFGNode, "<set-?>");
        this.enterNode = cFGNode;
    }

    @NotNull
    public final CFGNode<?> getExitNode() {
        CFGNode<?> cFGNode = this.exitNode;
        if (cFGNode != null) {
            return cFGNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException("exitNode");
        return null;
    }

    public final void setExitNode(@NotNull CFGNode<?> cFGNode) {
        Intrinsics.checkNotNullParameter(cFGNode, "<set-?>");
        this.exitNode = cFGNode;
    }

    public final boolean isSubGraph() {
        return !((Collection)this.getEnterNode().getPreviousNodes()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ControlFlowGraph> getSubGraphs() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getNodes();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CFGNode it = (CFGNode)element$iv$iv;
            boolean bl = false;
            Object object = it instanceof CFGNodeWithSubgraphs ? (CFGNodeWithSubgraphs)it : null;
            if (object == null || (object = ((CFGNodeWithSubgraphs)object).getSubGraphs()) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void complete() {
        this.nodes = ControlFlowGraphKt.access$orderNodes(this);
    }

    public final void traverse(@NotNull ControlFlowGraphVisitorVoid visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        for (CFGNode<?> node : this.getNodes()) {
            node.accept(visitor2);
            Object object = node instanceof CFGNodeWithSubgraphs ? (CFGNodeWithSubgraphs)node : null;
            if (object == null || (object = ((CFGNodeWithSubgraphs)object).getSubGraphs()) == null) continue;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ControlFlowGraph it = (ControlFlowGraph)element$iv;
                boolean bl = false;
                it.traverse(visitor2);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph$Kind;", "", "<init>", "(Ljava/lang/String;I)V", "File", "Class", "Constructor", "Function", "Script", "LocalFunction", "AnonymousFunction", "AnonymousFunctionCalledInPlace", "PropertyInitializer", "ClassInitializer", "FieldInitializer", "FakeCall", "DefaultArgument"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind File = new Kind();
        public static final /* enum */ Kind Class = new Kind();
        public static final /* enum */ Kind Constructor = new Kind();
        public static final /* enum */ Kind Function = new Kind();
        public static final /* enum */ Kind Script = new Kind();
        public static final /* enum */ Kind LocalFunction = new Kind();
        public static final /* enum */ Kind AnonymousFunction = new Kind();
        public static final /* enum */ Kind AnonymousFunctionCalledInPlace = new Kind();
        public static final /* enum */ Kind PropertyInitializer = new Kind();
        public static final /* enum */ Kind ClassInitializer = new Kind();
        public static final /* enum */ Kind FieldInitializer = new Kind();
        public static final /* enum */ Kind FakeCall = new Kind();
        public static final /* enum */ Kind DefaultArgument = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value2) {
            return Enum.valueOf(Kind.class, value2);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.File, Kind.Class, Kind.Constructor, Kind.Function, Kind.Script, Kind.LocalFunction, Kind.AnonymousFunction, Kind.AnonymousFunctionCalledInPlace, Kind.PropertyInitializer, Kind.ClassInitializer, Kind.FieldInitializer, Kind.FakeCall, Kind.DefaultArgument};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

