/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa.cfg;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.dfa.FlowPath;
import org.jetbrains.kotlin.fir.resolve.dfa.PersistentFlow;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FirStub;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J7\u0010\u0017\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u0012\"\u0004\b\u0001\u0010\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00142\u0006\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001f\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR$\u0010\u000e\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b8W@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0%8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/StubNode;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirStub;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "owner", "", "level", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;I)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/FlowPath;", "path", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "getAlternateFlow", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FlowPath;)Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "flow", "", "addAlternateFlow", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/FlowPath;Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;)V", "R", "D", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "visitor", "data", "accept", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getFir", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FirStub;", "fir", "", "getFlowInitialized", "()Z", "flowInitialized", "_", "getFlow", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;", "setFlow", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/PersistentFlow;)V", "", "getAlternateFlowPaths", "()Ljava/util/Set;", "alternateFlowPaths"})
public final class StubNode
extends CFGNode<FirStub> {
    public StubNode(@NotNull ControlFlowGraph owner, int level) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        super(owner, level, null);
        this.setDead(true);
    }

    @Override
    @NotNull
    public FirStub getFir() {
        return FirStub.INSTANCE;
    }

    @Override
    public boolean getFlowInitialized() {
        return CFGNodeKt.getFirstPreviousNode(this).getFlowInitialized();
    }

    @Override
    @NotNull
    public PersistentFlow getFlow() {
        return CFGNodeKt.getFirstPreviousNode(this).getFlow();
    }

    @Override
    public void setFlow(@NotNull PersistentFlow _) {
        Intrinsics.checkNotNullParameter(_, "_");
        throw new IllegalStateException("can't set flow for stub node");
    }

    @Override
    @NotNull
    public Set<FlowPath> getAlternateFlowPaths() {
        return CFGNodeKt.getFirstPreviousNode(this).getAlternateFlowPaths();
    }

    @Override
    @Nullable
    public PersistentFlow getAlternateFlow(@NotNull FlowPath path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return CFGNodeKt.getFirstPreviousNode(this).getAlternateFlow(path);
    }

    @Override
    public void addAlternateFlow(@NotNull FlowPath path, @NotNull PersistentFlow flow) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(flow, "flow");
        CFGNodeKt.getFirstPreviousNode(this).addAlternateFlow(path, flow);
    }

    @Override
    public <R, D> R accept(@NotNull ControlFlowGraphVisitor<? extends R, ? super D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitStubNode(this, data2);
    }
}

