/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.diagnostics;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCallCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeDiagnosticWithCandidates;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R$\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00068\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00148WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeFunctionCallExpectedError;", "Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeDiagnosticWithCandidates;", "Lorg/jetbrains/kotlin/name/Name;", "name", "", "hasValueParameters", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractCallCandidate;", "candidates", "<init>", "(Lorg/jetbrains/kotlin/name/Name;ZLjava/util/Collection;)V", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "Z", "getHasValueParameters", "()Z", "Ljava/util/Collection;", "getCandidates", "()Ljava/util/Collection;", "", "getReason", "()Ljava/lang/String;", "reason"})
public final class ConeFunctionCallExpectedError
implements ConeDiagnosticWithCandidates {
    @NotNull
    private final Name name;
    private final boolean hasValueParameters;
    @NotNull
    private final Collection<AbstractCallCandidate<?>> candidates;

    public ConeFunctionCallExpectedError(@NotNull Name name, boolean hasValueParameters, @NotNull Collection<? extends AbstractCallCandidate<?>> candidates) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(candidates, "candidates");
        this.name = name;
        this.hasValueParameters = hasValueParameters;
        this.candidates = candidates;
    }

    @NotNull
    public final Name getName() {
        return this.name;
    }

    public final boolean getHasValueParameters() {
        return this.hasValueParameters;
    }

    @NotNull
    public Collection<AbstractCallCandidate<?>> getCandidates() {
        return this.candidates;
    }

    @Override
    @NotNull
    public String getReason() {
        return "Function call expected: " + this.name + '(' + (this.hasValueParameters ? "..." : "") + ')';
    }
}

