/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.CopyUtilsKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTowerDataContext;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKind;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.diagnostics.ConeCannotInferReceiverParameterType;
import org.jetbrains.kotlin.fir.diagnostics.ConeCannotInferType;
import org.jetbrains.kotlin.fir.diagnostics.ConeCannotInferValueParameterType;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.FirRegularTowerDataContexts;
import org.jetbrains.kotlin.fir.resolve.FirTowerDataMode;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ConeAtomWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ConePostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeSimpleLeafResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FirAnonymousFunctionReturnExpressionInfo;
import org.jetbrains.kotlin.fir.resolve.inference.CompletionModeCalculatorKt;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeParameterBasedTypeVariable;
import org.jetbrains.kotlin.fir.resolve.inference.ConeTypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.fir.resolve.inference.FirCallCompleterKt;
import org.jetbrains.kotlin.fir.resolve.inference.FirInferenceSession;
import org.jetbrains.kotlin.fir.resolve.inference.FirPCLAInferenceSession;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.LambdaAnalyzer;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.fir.resolve.inference.ReturnArgumentsAnalysisResult;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeArgumentConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeExpectedTypeConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirCallCompletionResultsWriterTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.InvocationKindTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.BodyResolveContext;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformerDispatcher;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirDeclarationsResolveTransformer;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.SyntheticCallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001OB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J7\u0010\u0010\u001a\u00028\u0000\"\f\b\u0000\u0010\n*\u00020\b*\u00020\t2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u001f\u001a\u00020\u000e*\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030!H\u0002\u00a2\u0006\u0004\b\"\u0010#JG\u0010(\u001a\u00020\u0014\"\f\b\u0000\u0010\n*\u00020\t*\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010%\u001a\u00020$2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u00192\n\b\u0002\u0010'\u001a\u0004\u0018\u00010&\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010,\u001a\u00020\u00142\u0006\u0010+\u001a\u00020*2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b,\u0010-J!\u00103\u001a\u0002022\u0006\u0010/\u001a\u00020.2\b\b\u0002\u00101\u001a\u000200H\u0007\u00a2\u0006\u0004\b3\u00104J\u0017\u00107\u001a\u00020&2\u0006\u00106\u001a\u000205H\u0007\u00a2\u0006\u0004\b7\u00108J%\u0010<\u001a\u00020\u0019*\u00020\u00192\b\u0010:\u001a\u0004\u0018\u0001092\u0006\u0010;\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b<\u0010=J#\u0010?\u001a\u00020\u000e*\u00020\u00192\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b?\u0010@R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010AR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010BR\u0014\u0010D\u001a\u00020C8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0014\u0010I\u001a\u00020F8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u001a\u0010K\u001a\u00020J8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;", "transformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;", "components", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "T", "call", "Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;", "resolutionMode", "", "skipEvenPartialCompletion", "completeCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;Z)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "storage", "", "checkStorageConstraintsAfterFullCompletion", "(Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;)V", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "candidate", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "initialType", "addConstraintFromExpectedType", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/resolve/ResolutionMode;)V", "Lorg/jetbrains/kotlin/fir/types/ConeRigidType;", "expectedType", "isSyntheticFunctionCallThatShouldUseEqualityConstraint", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/types/ConeRigidType;)Z", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isSyntheticElvisFunction", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "completionMode", "Lorg/jetbrains/kotlin/fir/resolve/inference/PostponedArgumentsAnalyzer;", "analyzer", "runCompletionForCall", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/resolve/inference/PostponedArgumentsAnalyzer;)V", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolvedLambdaAtom;", "atom", "prepareLambdaAtomForFactoryPattern", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolvedLambdaAtom;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;)V", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompletionResultsWriterTransformer$Mode;", "mode", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompletionResultsWriterTransformer;", "createCompletionResultsWriter", "(Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompletionResultsWriterTransformer$Mode;)Lorg/jetbrains/kotlin/fir/resolve/transformers/FirCallCompletionResultsWriterTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "createPostponedArgumentsAnalyzer", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;)Lorg/jetbrains/kotlin/fir/resolve/inference/PostponedArgumentsAnalyzer;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "valueParameter", "isRootLambdaForPCLASession", "approximateLambdaInputType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;Z)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isReceiver", "useErrorTypeInsteadOfTypeVariableForParameterType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;ZZ)Z", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformerDispatcher;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceSession;", "getInferenceSession", "()Lorg/jetbrains/kotlin/fir/resolve/inference/FirInferenceSession;", "inferenceSession", "Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter;", "completer", "Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter;", "getCompleter", "()Lorg/jetbrains/kotlin/fir/resolve/inference/ConstraintSystemCompleter;", "LambdaAnalyzerImpl"})
public final class FirCallCompleter {
    @NotNull
    private final FirAbstractBodyResolveTransformerDispatcher transformer;
    @NotNull
    private final FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents components;
    @NotNull
    private final FirSession session;
    @NotNull
    private final ConstraintSystemCompleter completer;

    public FirCallCompleter(@NotNull FirAbstractBodyResolveTransformerDispatcher transformer2, @NotNull FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents components) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        Intrinsics.checkNotNullParameter(components, "components");
        this.transformer = transformer2;
        this.components = components;
        this.session = this.components.getSession();
        this.completer = new ConstraintSystemCompleter(this.components);
    }

    private final FirInferenceSession getInferenceSession() {
        return this.transformer.getContext().getInferenceSession();
    }

    @NotNull
    public final ConstraintSystemCompleter getCompleter() {
        return this.completer;
    }

    @NotNull
    public final <T extends FirExpression> T completeCall(@NotNull T call2, @NotNull ResolutionMode resolutionMode, boolean skipEvenPartialCompletion) {
        Object object;
        ConstraintSystemCompletionMode constraintSystemCompletionMode;
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(resolutionMode, "resolutionMode");
        FirResolvedTypeRef typeRef = ResolveUtilsKt.typeFromCallee(this.components, (FirResolvable)((Object)call2));
        FirReference firReference = ((FirResolvable)((Object)call2)).getCalleeReference();
        FirNamedReferenceWithCandidate firNamedReferenceWithCandidate = firReference instanceof FirNamedReferenceWithCandidate ? (FirNamedReferenceWithCandidate)firReference : null;
        if (firNamedReferenceWithCandidate == null) {
            return call2;
        }
        FirNamedReferenceWithCandidate reference = firNamedReferenceWithCandidate;
        Candidate candidate = reference.getCandidate();
        ConeKotlinType initialType = ResolveUtilsKt.initialTypeOfCandidate(typeRef, candidate);
        if (!(call2 instanceof FirAnnotationCall) && !(call2 instanceof FirDelegatedConstructorCall)) {
            T $this$resultType$iv = call2;
            boolean $i$f$setResultType = false;
            $this$resultType$iv.replaceConeTypeOrNull(initialType);
        }
        FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
        if (firLookupTrackerComponent != null) {
            FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent, initialType, ((FirResolvable)((Object)call2)).getSource(), this.components.getContext().getFile().getSource());
        }
        this.addConstraintFromExpectedType(candidate, initialType, resolutionMode);
        if (skipEvenPartialCompletion) {
            return call2;
        }
        ConstraintSystemCompletionMode it = CompletionModeCalculatorKt.computeCompletionMode(candidate, InferenceComponentsKt.getInferenceComponents(this.session), resolutionMode, initialType);
        boolean bl = false;
        if (it == ConstraintSystemCompletionMode.FULL) {
            constraintSystemCompletionMode = this.getInferenceSession().customCompletionModeInsteadOfFull((FirResolvable)((Object)call2));
            if (constraintSystemCompletionMode == null) {
                constraintSystemCompletionMode = ConstraintSystemCompletionMode.FULL;
            }
        } else {
            constraintSystemCompletionMode = it;
        }
        ConstraintSystemCompletionMode completionMode = constraintSystemCompletionMode;
        PostponedArgumentsAnalyzer analyzer = this.createPostponedArgumentsAnalyzer(this.transformer.getResolutionContext());
        if (call2 instanceof FirFunctionCall) {
            InvocationKindTransformerKt.replaceLambdaArgumentInvocationKinds((FirFunctionCall)call2, this.session);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[completionMode.ordinal()]) {
            case 1: {
                this.runCompletionForCall(candidate, completionMode, call2, initialType, analyzer);
                ConstraintStorage readOnlyConstraintStorage = candidate.getSystem().asReadOnlyStorage();
                this.checkStorageConstraintsAfterFullCompletion(readOnlyConstraintStorage);
                TypeSubstitutorMarker typeSubstitutorMarker = InferenceUtilsKt.buildAbstractResultingSubstitutor$default(readOnlyConstraintStorage, TypeComponentsKt.getTypeContext(this.session), false, 2, null);
                Intrinsics.checkNotNull(typeSubstitutorMarker, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor");
                ConeSubstitutor finalSubstitutor = (ConeSubstitutor)typeSubstitutorMarker;
                object = (FirExpression)FirTransformerUtilKt.transformSingle(call2, new FirCallCompletionResultsWriterTransformer(this.session, this.components.getScopeSession(), finalSubstitutor, this.components.getReturnTypeCalculator(), TypeComponentsKt.getTypeApproximator(this.session), this.components.getDataFlowAnalyzer(), this.components.getIntegerLiteralAndOperatorApproximationTransformer(), this.components.getSamResolver(), this.components.getContext(), null, 512, null), null);
                break;
            }
            case 2: 
            case 3: {
                this.runCompletionForCall(candidate, completionMode, call2, initialType, analyzer);
                this.getInferenceSession().processPartiallyResolvedCall(call2, resolutionMode, completionMode);
                object = call2;
                break;
            }
            case 4: {
                throw new IllegalStateException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    public static /* synthetic */ FirExpression completeCall$default(FirCallCompleter firCallCompleter, FirExpression firExpression, ResolutionMode resolutionMode, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return firCallCompleter.completeCall(firExpression, resolutionMode, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkStorageConstraintsAfterFullCompletion(ConstraintStorage storage2) {
        void $this$filterTo$iv$iv;
        if (storage2.getNotFixedTypeVariables().isEmpty()) {
            return;
        }
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.PCLAEnhancementsIn21)) {
            return;
        }
        Map<TypeConstructorMarker, VariableWithConstraints> $this$filter$iv = storage2.getNotFixedTypeVariables();
        boolean $i$f$filter = false;
        Map<TypeConstructorMarker, VariableWithConstraints> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((VariableWithConstraints)it.getValue()).getTypeVariable() instanceof ConeTypeParameterBasedTypeVariable)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map notFixedTypeVariablesBasedOnTypeParameters = destination$iv$iv;
        if (!notFixedTypeVariablesBasedOnTypeParameters.isEmpty()) {
            boolean bl = false;
            String string2 = "All variables should be fixed to something, but {" + CollectionsKt.joinToString$default(notFixedTypeVariablesBasedOnTypeParameters.keySet(), ", ", null, null, 0, null, null, 62, null) + "} are found";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    private final void addConstraintFromExpectedType(Candidate candidate, ConeKotlinType initialType, ResolutionMode resolutionMode) {
        if (!(resolutionMode instanceof ResolutionMode.WithExpectedType) || ((ResolutionMode.WithExpectedType)resolutionMode).getArrayLiteralPosition() == ResolutionMode.ArrayLiteralPosition.AnnotationArgument) {
            return;
        }
        ConeKotlinType expectedType = TypeExpansionUtilsKt.fullyExpandedType$default(((ResolutionMode.WithExpectedType)resolutionMode).getExpectedType(), this.session, null, 2, null);
        NewConstraintSystemImpl system = candidate.getSystem();
        if (resolutionMode.getForceFullCompletion() && this.isSyntheticFunctionCallThatShouldUseEqualityConstraint(candidate, ConeTypeUtilsKt.upperBoundIfFlexible(expectedType))) {
            ConstraintSystemBuilderKt.addEqualityConstraintIfCompatible(system, initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
        } else if (!((ResolutionMode.WithExpectedType)resolutionMode).getShouldBeStrictlyEnforced() || ((ResolutionMode.WithExpectedType)resolutionMode).getExpectedTypeMismatchIsReportedInChecker()) {
            ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(system, initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
        } else if (((ResolutionMode.WithExpectedType)resolutionMode).getFromCast()) {
            if (FirCallCompleterKt.access$isFunctionForExpectTypeFromCastFeature(candidate)) {
                system.addSubtypeConstraint(initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
            }
        } else if (TypeUtilsKt.isUnitOrFlexibleUnit(expectedType) && ((ResolutionMode.WithExpectedType)resolutionMode).getMayBeCoercionToUnitApplied()) {
            if (system.getNotFixedTypeVariables().isEmpty()) {
                return;
            }
            boolean bl = ConeBuiltinTypeUtilsKt.isUnit(expectedType) ? ConstraintSystemBuilderKt.addEqualityConstraintIfCompatible(system, initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE) : ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(system, initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
        } else {
            system.addSubtypeConstraint(initialType, expectedType, ConeExpectedTypeConstraintPosition.INSTANCE);
        }
    }

    private final boolean isSyntheticFunctionCallThatShouldUseEqualityConstraint(Candidate $this$isSyntheticFunctionCallThatShouldUseEqualityConstraint, ConeRigidType expectedType) {
        boolean bl;
        block6: {
            if (this.components.getContext().isInsideAssignmentRhs()) {
                return false;
            }
            FirBasedSymbol<?> firBasedSymbol = $this$isSyntheticFunctionCallThatShouldUseEqualityConstraint.getSymbol();
            FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
            if (firCallableSymbol == null) {
                return false;
            }
            FirCallableSymbol symbol = firCallableSymbol;
            if (!Intrinsics.areEqual(symbol.getOrigin(), FirDeclarationOrigin.Synthetic.FakeFunction.INSTANCE) || ConeBuiltinTypeUtilsKt.isUnitOrNullableUnit(expectedType) || ConeBuiltinTypeUtilsKt.isAnyOrNullableAny(expectedType) || Intrinsics.areEqual(symbol.getCallableId(), SyntheticCallableId.INSTANCE.getCHECK_NOT_NULL()) && TypeUtilsKt.canBeNull(expectedType, this.session)) {
                return false;
            }
            Iterable $this$any$iv = $this$isSyntheticFunctionCallThatShouldUseEqualityConstraint.getSystem().getAllTypeVariables().values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeVariableMarker it = (TypeVariableMarker)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof ConeTypeParameterBasedTypeVariable && this.isSyntheticElvisFunction(((ConeTypeParameterBasedTypeVariable)it).getTypeParameterSymbol().getContainingDeclarationSymbol()))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSyntheticElvisFunction(FirBasedSymbol<?> $this$isSyntheticElvisFunction) {
        if (!Intrinsics.areEqual($this$isSyntheticElvisFunction.getOrigin(), FirDeclarationOrigin.Synthetic.FakeFunction.INSTANCE)) return false;
        FirCallableSymbol firCallableSymbol = $this$isSyntheticElvisFunction instanceof FirCallableSymbol ? (FirCallableSymbol)$this$isSyntheticElvisFunction : null;
        if (!Intrinsics.areEqual(firCallableSymbol != null ? firCallableSymbol.getCallableId() : null, SyntheticCallableId.INSTANCE.getELVIS_NOT_NULL())) return false;
        return true;
    }

    public final <T extends FirExpression> void runCompletionForCall(@NotNull Candidate candidate, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull T call2, @NotNull ConeKotlinType initialType, @Nullable PostponedArgumentsAnalyzer analyzer) {
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter((Object)completionMode, "completionMode");
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(initialType, "initialType");
        PostponedArgumentsAnalyzer postponedArgumentsAnalyzer = analyzer;
        if (postponedArgumentsAnalyzer == null) {
            postponedArgumentsAnalyzer = this.createPostponedArgumentsAnalyzer(this.transformer.getResolutionContext());
        }
        PostponedArgumentsAnalyzer analyzer2 = postponedArgumentsAnalyzer;
        this.completer.complete(candidate.getSystem().asConstraintSystemCompleterContext(), completionMode, CollectionsKt.listOf(new ConeAtomWithCandidate(call2, candidate)), initialType, this.transformer.getResolutionContext(), (arg_0, arg_1) -> FirCallCompleter.runCompletionForCall$lambda$4(analyzer2, candidate, arg_0, arg_1));
    }

    public static /* synthetic */ void runCompletionForCall$default(FirCallCompleter firCallCompleter, Candidate candidate, ConstraintSystemCompletionMode constraintSystemCompletionMode, FirExpression firExpression, ConeKotlinType coneKotlinType, PostponedArgumentsAnalyzer postponedArgumentsAnalyzer, int n, Object object) {
        if ((n & 0x10) != 0) {
            postponedArgumentsAnalyzer = null;
        }
        firCallCompleter.runCompletionForCall(candidate, constraintSystemCompletionMode, firExpression, coneKotlinType, postponedArgumentsAnalyzer);
    }

    public final void prepareLambdaAtomForFactoryPattern(@NotNull ConeResolvedLambdaAtom atom, @NotNull Candidate candidate) {
        Intrinsics.checkNotNullParameter(atom, "atom");
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        ConeTypeVariableForLambdaReturnType returnVariable = new ConeTypeVariableForLambdaReturnType(atom.getAnonymousFunction(), "_R");
        NewConstraintSystemImpl csBuilder = candidate.getSystem().getBuilder();
        csBuilder.registerVariable(returnVariable);
        TypeSubstitutorMarker typeSubstitutorMarker = csBuilder.buildCurrentSubstitutor();
        TypeSystemInferenceExtensionContext typeSystemInferenceExtensionContext = csBuilder;
        ConeKotlinType coneKotlinType = atom.getExpectedType();
        Intrinsics.checkNotNull(coneKotlinType);
        KotlinTypeMarker kotlinTypeMarker = MarkerExtensionsKt.safeSubstitute(typeSubstitutorMarker, typeSystemInferenceExtensionContext, coneKotlinType);
        Intrinsics.checkNotNull(kotlinTypeMarker, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeClassLikeType");
        ConeClassLikeType functionalType = (ConeClassLikeType)kotlinTypeMarker;
        int size = functionalType.getTypeArguments().length;
        ConeTypeProjection[] coneTypeProjectionArray = new ConeTypeProjection[size];
        ConeClassLikeLookupTag coneClassLikeLookupTag = functionalType.getLookupTag();
        for (int i = 0; i < size; ++i) {
            int n = i;
            coneTypeProjectionArray[n] = n != size - 1 ? functionalType.getTypeArguments()[n] : (ConeTypeProjection)returnVariable.getDefaultType();
        }
        ConeAttributes coneAttributes = functionalType.getAttributes();
        boolean bl = functionalType.isMarkedNullable();
        ConeTypeProjection[] coneTypeProjectionArray2 = coneTypeProjectionArray;
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
        ConeClassLikeTypeImpl expectedType = new ConeClassLikeTypeImpl(coneClassLikeLookupTag2, coneTypeProjectionArray2, bl, coneAttributes);
        csBuilder.addSubtypeConstraint(expectedType, functionalType, new ConeArgumentConstraintPosition(atom.getAnonymousFunction()));
        atom.replaceExpectedType(expectedType, returnVariable.getDefaultType());
        atom.replaceTypeVariableForLambdaReturnType(returnVariable);
    }

    @NotNull
    public final FirCallCompletionResultsWriterTransformer createCompletionResultsWriter(@NotNull ConeSubstitutor substitutor2, @NotNull FirCallCompletionResultsWriterTransformer.Mode mode) {
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        return new FirCallCompletionResultsWriterTransformer(this.session, this.components.getScopeSession(), substitutor2, this.components.getReturnTypeCalculator(), TypeComponentsKt.getTypeApproximator(this.session), this.components.getDataFlowAnalyzer(), this.components.getIntegerLiteralAndOperatorApproximationTransformer(), this.components.getSamResolver(), this.components.getContext(), mode);
    }

    public static /* synthetic */ FirCallCompletionResultsWriterTransformer createCompletionResultsWriter$default(FirCallCompleter firCallCompleter, ConeSubstitutor coneSubstitutor, FirCallCompletionResultsWriterTransformer.Mode mode, int n, Object object) {
        if ((n & 2) != 0) {
            mode = FirCallCompletionResultsWriterTransformer.Mode.Normal;
        }
        return firCallCompleter.createCompletionResultsWriter(coneSubstitutor, mode);
    }

    @NotNull
    public final PostponedArgumentsAnalyzer createPostponedArgumentsAnalyzer(@NotNull ResolutionContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        LambdaAnalyzerImpl lambdaAnalyzer = new LambdaAnalyzerImpl();
        return new PostponedArgumentsAnalyzer(context, lambdaAnalyzer, InferenceComponentsKt.getInferenceComponents(this.session), this.transformer.getComponents().getCallResolver());
    }

    private final ConeKotlinType approximateLambdaInputType(ConeKotlinType $this$approximateLambdaInputType, FirValueParameterSymbol valueParameter2, boolean isRootLambdaForPCLASession) {
        if (this.useErrorTypeInsteadOfTypeVariableForParameterType($this$approximateLambdaInputType, valueParameter2 == null, isRootLambdaForPCLASession)) {
            ConeCannotInferType coneCannotInferType;
            FirValueParameterSymbol firValueParameterSymbol = valueParameter2;
            if (firValueParameterSymbol != null) {
                FirValueParameterSymbol p0 = firValueParameterSymbol;
                boolean bl = false;
                coneCannotInferType = new ConeCannotInferValueParameterType(p0, null, 2, null);
            } else {
                coneCannotInferType = new ConeCannotInferReceiverParameterType(null, 1, null);
            }
            ConeCannotInferType diagnostic = coneCannotInferType;
            return new ConeErrorType(diagnostic, false, null, null, null, 30, null);
        }
        ConeKotlinType coneKotlinType = TypeComponentsKt.getTypeApproximator(this.session).approximateToSuperType($this$approximateLambdaInputType, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.IntermediateApproximationToSupertypeAfterCompletionInK2.INSTANCE);
        if (coneKotlinType == null) {
            coneKotlinType = $this$approximateLambdaInputType;
        }
        return coneKotlinType;
    }

    private final boolean useErrorTypeInsteadOfTypeVariableForParameterType(ConeKotlinType $this$useErrorTypeInsteadOfTypeVariableForParameterType, boolean isReceiver, boolean isRootLambdaForPCLASession) {
        if (!($this$useErrorTypeInsteadOfTypeVariableForParameterType instanceof ConeTypeVariableType)) {
            return false;
        }
        if (isReceiver) {
            return true;
        }
        if (isRootLambdaForPCLASession || this.getInferenceSession() instanceof FirPCLAInferenceSession) {
            return ((ConeTypeVariableType)$this$useErrorTypeInsteadOfTypeVariableForParameterType).getTypeConstructor().getOriginalTypeParameter() == null;
        }
        return true;
    }

    private static final void runCompletionForCall$lambda$4(PostponedArgumentsAnalyzer $analyzer, Candidate $candidate, ConePostponedResolvedAtom atom, boolean withPCLASession) {
        Intrinsics.checkNotNullParameter(atom, "atom");
        $analyzer.analyze($candidate.getSystem(), atom, $candidate, withPCLASession);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J_\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter$LambdaAnalyzerImpl;", "Lorg/jetbrains/kotlin/fir/resolve/inference/LambdaAnalyzer;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/inference/FirCallCompleter;)V", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolvedLambdaAtom;", "lambdaAtom", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "receiverType", "", "contextParameters", "parameters", "expectedReturnType", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "candidate", "", "withPCLASession", "forOverloadByLambdaReturnType", "Lorg/jetbrains/kotlin/fir/resolve/inference/ReturnArgumentsAnalysisResult;", "analyzeAndGetLambdaReturnArguments", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolvedLambdaAtom;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;ZZ)Lorg/jetbrains/kotlin/fir/resolve/inference/ReturnArgumentsAnalysisResult;"})
    private final class LambdaAnalyzerImpl
    implements LambdaAnalyzer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ReturnArgumentsAnalysisResult analyzeAndGetLambdaReturnArguments(@NotNull ConeResolvedLambdaAtom lambdaAtom, @Nullable ConeKotlinType receiverType, @NotNull List<? extends ConeKotlinType> contextParameters, @NotNull List<? extends ConeKotlinType> parameters2, @Nullable ConeKotlinType expectedReturnType, @NotNull Candidate candidate, boolean withPCLASession, boolean forOverloadByLambdaReturnType) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void this_$iv$iv;
            Unit unit;
            Unit unit2;
            FirPCLAInferenceSession $this$analyzeAndGetLambdaReturnArguments_u24lambda_u2412_u24lambda_u2410;
            BodyResolveContext this_$iv;
            Object declarationsTransformer;
            FirAnonymousFunctionExpression lambdaExpression;
            FirPCLAInferenceSession pclaInferenceSession;
            Iterable symbol$iv;
            void this_$iv2;
            FirTypeRef firTypeRef;
            Object item$iv22;
            void $this$forEachIndexed$iv;
            List<ConeKotlinType> list;
            int n;
            Iterable $this$mapTo$iv$iv2;
            Object object;
            Object $this$analyzeAndGetLambdaReturnArguments_u24lambda_u243;
            Object object2;
            FirResolvedTypeRef firResolvedTypeRef;
            FirValueParameter firValueParameter;
            FirValueParameter matchedParameter;
            FirPureAbstractElement firPureAbstractElement;
            Object object3;
            Object currentValueParameter;
            boolean needItParam;
            FirAnonymousFunction lambda;
            block62: {
                Intrinsics.checkNotNullParameter(lambdaAtom, "lambdaAtom");
                Intrinsics.checkNotNullParameter(contextParameters, "contextParameters");
                Intrinsics.checkNotNullParameter(parameters2, "parameters");
                Intrinsics.checkNotNullParameter(candidate, "candidate");
                lambda = lambdaAtom.getAnonymousFunction();
                needItParam = lambda.getValueParameters().isEmpty() && parameters2.size() == 1;
                for (Map.Entry entry : ((Map)candidate.getArgumentMapping()).entrySet()) {
                    FirAnonymousFunction currentLambdaArgument;
                    boolean bl3 = false;
                    ConeResolutionAtom currentAtom = (ConeResolutionAtom)entry.getKey();
                    currentValueParameter = (FirValueParameter)entry.getValue();
                    FirExpression currentArgument = currentAtom.getExpression();
                    FirAnonymousFunctionExpression firAnonymousFunctionExpression = currentArgument instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)currentArgument : null;
                    FirAnonymousFunction firAnonymousFunction = currentLambdaArgument = firAnonymousFunctionExpression != null ? firAnonymousFunctionExpression.getAnonymousFunction() : null;
                    Object object4 = currentLambdaArgument == lambda ? currentValueParameter : null;
                    if (object4 == null) continue;
                    object3 = object4;
                    break block62;
                }
                object3 = null;
            }
            ClassMembersKt.setMatchingParameterFunctionType(lambda, (firPureAbstractElement = (matchedParameter = object3)) != null && (firPureAbstractElement = firPureAbstractElement.getReturnTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null);
            if (needItParam) {
                Name name = StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME;
                ConeKotlinType coneKotlinType = CollectionsKt.single(parameters2);
                FirCallCompleter bl3 = FirCallCompleter.this;
                boolean $i$f$buildValueParameter = false;
                Object $this$analyzeAndGetLambdaReturnArguments_u24lambda_u241 = currentValueParameter = new FirValueParameterBuilder();
                boolean bl4 = false;
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setResolvePhase(FirResolvePhase.BODY_RESOLVE);
                KtSourceElement ktSourceElement = lambdaAtom.getAnonymousFunction().getSource();
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ItLambdaParameter.INSTANCE, 0, 0, 6, null) : null);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setContainingDeclarationSymbol(lambda.getSymbol());
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setModuleData(FirModuleDataKt.getModuleData(bl3.session));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setName(name);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setSymbol(new FirValueParameterSymbol(name));
                KtSourceElement ktSourceElement2 = lambdaAtom.getAnonymousFunction().getSource();
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setReturnTypeRef(UtilsKt.toFirResolvedTypeRef$default(bl3.approximateLambdaInputType(coneKotlinType, ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).getSymbol(), withPCLASession), ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement2, KtFakeSourceElementKind.ItLambdaParameter.INSTANCE, 0, 0, 6, null) : null, null, 2, null));
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setDefaultValue(null);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setCrossinline(false);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setNoinline(false);
                ((FirValueParameterBuilder)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u241).setVararg(false);
                firValueParameter = ((FirValueParameterBuilder)currentValueParameter).build();
            } else {
                firValueParameter = null;
            }
            FirValueParameter itParam = firValueParameter;
            ConeKotlinType coneKotlinType = expectedReturnType;
            if (coneKotlinType != null) {
                ConeKotlinType it = coneKotlinType;
                boolean bl5 = false;
                KtSourceElement ktSourceElement = lambda.getSource();
                firResolvedTypeRef = CopyUtilsKt.resolvedTypeFromPrototype(lambda.getReturnTypeRef(), it, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ImplicitTypeRef.INSTANCE, 0, 0, 6, null) : null);
            } else {
                firResolvedTypeRef = null;
            }
            FirResolvedTypeRef expectedReturnTypeRef = firResolvedTypeRef;
            if (receiverType == null) {
                lambda.replaceReceiverParameter(null);
                object2 = Unit.INSTANCE;
            } else if (!lambdaAtom.getCoerceFirstParameterToExtensionReceiver()) {
                FirReceiverParameter firReceiverParameter = lambda.getReceiverParameter();
                if (firReceiverParameter != null) {
                    FirReceiverParameter it = firReceiverParameter;
                    FirCallCompleter bl5 = FirCallCompleter.this;
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u243 = it;
                    boolean bl6 = false;
                    ConeKotlinType type2 = bl5.approximateLambdaInputType(receiverType, null, withPCLASession);
                    KtSourceElement ktSourceElement = ((FirReceiverParameter)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u243).getSource();
                    if (ktSourceElement == null || (ktSourceElement = KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.LambdaReceiver.INSTANCE, 0, 0, 6, null)) == null) {
                        KtSourceElement ktSourceElement3 = lambda.getSource();
                        ktSourceElement = ktSourceElement3 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement3, KtFakeSourceElementKind.LambdaReceiver.INSTANCE, 0, 0, 6, null) : null;
                    }
                    KtSourceElement source = ktSourceElement;
                    ((FirReceiverParameter)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u243).replaceTypeRef(CopyUtilsKt.resolvedTypeFromPrototype(((FirReceiverParameter)$this$analyzeAndGetLambdaReturnArguments_u24lambda_u243).getTypeRef(), type2, source));
                    object2 = it;
                } else {
                    object2 = null;
                }
            } else {
                lambda.replaceReceiverParameter(null);
                object2 = Unit.INSTANCE;
            }
            if (!((Collection)contextParameters).isEmpty()) {
                Iterable iterable = contextParameters;
                FirCallCompleter it = FirCallCompleter.this;
                object = lambda;
                boolean $i$f$map = false;
                $this$analyzeAndGetLambdaReturnArguments_u24lambda_u243 = iterable;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void contextParameterType;
                    FirValueParameterBuilder firValueParameterBuilder;
                    ConeKotlinType coneKotlinType2 = (ConeKotlinType)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    n = 0;
                    boolean $i$f$buildValueParameter = false;
                    FirValueParameterBuilder $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244 = firValueParameterBuilder = new FirValueParameterBuilder();
                    boolean bl7 = false;
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
                    KtSourceElement ktSourceElement = lambdaAtom.getAnonymousFunction().getSource();
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.LambdaContextParameter.INSTANCE, 0, 0, 6, null) : null);
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.setContainingDeclarationSymbol(lambda.getSymbol());
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.setModuleData(FirModuleDataKt.getModuleData(it.session));
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.setName(SpecialNames.UNDERSCORE_FOR_UNUSED_VAR);
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.setSymbol(new FirValueParameterSymbol($this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.getName()));
                    KtSourceElement ktSourceElement4 = lambdaAtom.getAnonymousFunction().getSource();
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.setReturnTypeRef(UtilsKt.toFirResolvedTypeRef$default(it.approximateLambdaInputType((ConeKotlinType)contextParameterType, $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.getSymbol(), withPCLASession), ktSourceElement4 != null ? KtSourceElementKt.fakeElement$default(ktSourceElement4, KtFakeSourceElementKind.LambdaContextParameter.INSTANCE, 0, 0, 6, null) : null, null, 2, null));
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u245_u24lambda_u244.setValueParameterKind(FirLanguageSettingsComponentKt.getLanguageVersionSettings(it.session).supportsFeature(LanguageFeature.ContextParameters) ? FirValueParameterKind.ContextParameter : FirValueParameterKind.LegacyContextReceiver);
                    collection.add(firValueParameterBuilder.build());
                }
                ((FirAnonymousFunction)object).replaceContextParameters((List)destination$iv$iv);
            }
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(FirCallCompleter.this.session);
            KtSourceElement fileSource = FirCallCompleter.this.components.getFile().getSource();
            if (lambdaAtom.getCoerceFirstParameterToExtensionReceiver()) {
                if (receiverType == null) {
                    throw new IllegalStateException("Coercion to extension receiver while no receiver present".toString());
                }
                list = CollectionsKt.plus((Collection)CollectionsKt.listOf(receiverType), (Iterable)parameters2);
            } else {
                list = parameters2;
            }
            List<? extends ConeKotlinType> theParameters = list;
            $this$mapTo$iv$iv2 = lambda.getValueParameters();
            Object destination$iv$iv = FirCallCompleter.this;
            boolean $i$f$forEachIndexed22 = false;
            int index$iv = 0;
            for (Object item$iv22 : $this$forEachIndexed$iv) {
                Unit unit3;
                FirResolvedTypeRef firResolvedTypeRef2;
                void parameter;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FirValueParameter $i$f$buildValueParameter = (FirValueParameter)item$iv22;
                int index2 = n;
                boolean bl8 = false;
                if (index2 >= theParameters.size()) {
                    void $this$analyzeAndGetLambdaReturnArguments_u24lambda_u247_u24lambda_u246;
                    FirErrorTypeRefBuilder firErrorTypeRefBuilder;
                    boolean $i$f$buildErrorTypeRef = false;
                    FirErrorTypeRefBuilder firErrorTypeRefBuilder2 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                    void var30_79 = parameter;
                    boolean bl9 = false;
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u247_u24lambda_u246.setDiagnostic(new ConeCannotInferValueParameterType(parameter.getSymbol(), "Lambda or anonymous function has more parameters than expected"));
                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u247_u24lambda_u246.setSource(parameter.getSource());
                    var30_79.replaceReturnTypeRef(firErrorTypeRefBuilder.build());
                    continue;
                }
                ConeKotlinType newReturnType = ((FirCallCompleter)destination$iv$iv).approximateLambdaInputType(theParameters.get(index2), parameter.getSymbol(), withPCLASession);
                if (parameter.getReturnTypeRef() instanceof FirImplicitTypeRef) {
                    KtSourceElement ktSourceElement = parameter.getSource();
                    firResolvedTypeRef2 = UtilsKt.toFirResolvedTypeRef$default(newReturnType, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ImplicitReturnTypeOfLambdaValueParameter.INSTANCE, 0, 0, 6, null) : null, null, 2, null);
                } else {
                    firResolvedTypeRef2 = CopyUtilsKt.resolvedTypeFromPrototype$default(parameter.getReturnTypeRef(), newReturnType, null, 2, null);
                }
                FirResolvedTypeRef newReturnTypeRef = firResolvedTypeRef2;
                parameter.replaceReturnTypeRef(newReturnTypeRef);
                FirLookupTrackerComponent firLookupTrackerComponent2 = firLookupTrackerComponent;
                if (firLookupTrackerComponent2 != null) {
                    FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent2, newReturnTypeRef, parameter.getSource(), fileSource);
                    unit3 = Unit.INSTANCE;
                    continue;
                }
                unit3 = null;
            }
            lambda.replaceValueParameters(CollectionsKt.plus((Collection)lambda.getValueParameters(), (Iterable)CollectionsKt.listOfNotNull(itParam)));
            FirAnonymousFunction firAnonymousFunction = lambda;
            FirResolvedTypeRef firResolvedTypeRef3 = expectedReturnTypeRef;
            if (firResolvedTypeRef3 != null) {
                Unit unit4;
                Object $i$f$forEachIndexed22 = destination$iv$iv = firResolvedTypeRef3;
                object = firAnonymousFunction;
                boolean bl10 = false;
                FirLookupTrackerComponent firLookupTrackerComponent3 = firLookupTrackerComponent;
                if (firLookupTrackerComponent3 != null) {
                    void it;
                    FirLookupTrackerComponentKt.recordTypeResolveAsLookup(firLookupTrackerComponent3, (FirTypeRef)it, lambda.getSource(), fileSource);
                    unit4 = Unit.INSTANCE;
                } else {
                    unit4 = null;
                }
                firAnonymousFunction = object;
                firTypeRef = (FirTypeRef)destination$iv$iv;
            } else {
                firTypeRef = FirCallCompleter.this.components.getNoExpectedType();
            }
            firAnonymousFunction.replaceReturnTypeRef(firTypeRef);
            ConstraintStorage additionalConstraints = null;
            destination$iv$iv = FirCallCompleter.this.transformer.getContext();
            FirAnonymousFunctionSymbol it = lambda.getSymbol();
            FirCallCompleter firCallCompleter = FirCallCompleter.this;
            boolean $i$f$withAnonymousFunctionTowerDataContext = false;
            item$iv22 = this_$iv2;
            Pair<FirTowerDataContext, FirInferenceSession> newContext$iv$iv = this_$iv2.getSpecialTowerDataContexts().getAnonymousFunctionContext((FirAnonymousFunctionSymbol)((Object)symbol$iv));
            boolean $i$f$withTemporaryRegularContext = false;
            Pair<FirTowerDataContext, FirInferenceSession> pair = newContext$iv$iv;
            if (pair == null) {
                FirPCLAInferenceSession firPCLAInferenceSession;
                boolean bl2 = false;
                boolean $i$f$runIf = false;
                if (withPCLASession) {
                    boolean bl11 = false;
                    ((Collection)candidate.getLambdasAnalyzedWithPCLA()).add(lambda);
                    firPCLAInferenceSession = new FirPCLAInferenceSession(candidate, InferenceComponentsKt.getInferenceComponents(firCallCompleter.session));
                } else {
                    firPCLAInferenceSession = null;
                }
                pclaInferenceSession = firPCLAInferenceSession;
                lambdaExpression = lambdaAtom.getExpression();
                FirDeclarationsResolveTransformer firDeclarationsResolveTransformer = firCallCompleter.transformer.getDeclarationsTransformer();
                Intrinsics.checkNotNull(firDeclarationsResolveTransformer);
                declarationsTransformer = firDeclarationsResolveTransformer;
                if (pclaInferenceSession != null) {
                    this_$iv = firCallCompleter.transformer.getContext();
                    boolean $i$f$withInferenceSession = false;
                    FirInferenceSession oldSession$iv = this_$iv.getInferenceSession();
                    this_$iv.setInferenceSession(pclaInferenceSession);
                    try {
                        $this$analyzeAndGetLambdaReturnArguments_u24lambda_u2412_u24lambda_u2410 = (FirPCLAInferenceSession)((FirInferenceSession)pclaInferenceSession);
                        boolean bl = false;
                        ((FirDeclarationsResolveTransformer)declarationsTransformer).doTransformAnonymousFunction$resolve(lambdaExpression, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                        $this$analyzeAndGetLambdaReturnArguments_u24lambda_u2412_u24lambda_u2410.applyResultsToMainCandidate();
                        unit2 = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv.setInferenceSession(oldSession$iv);
                    }
                } else {
                    additionalConstraints = firCallCompleter.transformer.getContext().getInferenceSession().runLambdaCompletion(candidate, forOverloadByLambdaReturnType, () -> LambdaAnalyzerImpl.analyzeAndGetLambdaReturnArguments$lambda$12$lambda$11((FirDeclarationsResolveTransformer)declarationsTransformer, lambdaExpression, expectedReturnTypeRef));
                }
                unit = Unit.INSTANCE;
            } else {
                Unit unit5;
                Pair<FirTowerDataContext, FirInferenceSession> pair2 = pair;
                FirTowerDataContext towerDataContext$iv$iv = pair2.component1();
                FirInferenceSession newInferenceSession$iv$iv = pair2.component2();
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$withTowerDataModeCleanup = false;
                FirTowerDataMode initialMode$iv$iv$iv = this_$iv$iv$iv.getTowerDataMode();
                try {
                    Unit unit6;
                    void this_$iv$iv$iv2;
                    boolean bl12 = false;
                    void var43_100 = this_$iv$iv;
                    FirRegularTowerDataContexts newContexts$iv$iv$iv = this_$iv$iv.getRegularTowerDataContexts().replaceAndSetActiveRegularContext(towerDataContext$iv$iv);
                    boolean $i$f$withTowerDataContexts = false;
                    FirRegularTowerDataContexts old$iv$iv$iv = this_$iv$iv$iv2.getRegularTowerDataContexts();
                    this_$iv$iv$iv2.setRegularTowerDataContexts(newContexts$iv$iv$iv);
                    try {
                        Unit unit7;
                        boolean bl;
                        boolean bl2;
                        boolean bl13 = false;
                        if (newInferenceSession$iv$iv != this_$iv$iv.getInferenceSession()) {
                            Unit unit8;
                            void this_$iv$iv$iv3 = this_$iv$iv;
                            boolean $i$f$withInferenceSession = false;
                            FirInferenceSession oldSession$iv$iv$iv = this_$iv$iv$iv3.getInferenceSession();
                            this_$iv$iv$iv3.setInferenceSession(newInferenceSession$iv$iv);
                            try {
                                FirPCLAInferenceSession firPCLAInferenceSession;
                                FirInferenceSession $this$withTemporaryRegularContext_u24lambda_u2411_u24lambda_u2410_u24lambda_u249$iv$iv = newInferenceSession$iv$iv;
                                boolean bl14 = false;
                                bl2 = false;
                                boolean $i$f$runIf = false;
                                if (withPCLASession) {
                                    boolean bl15 = false;
                                    ((Collection)candidate.getLambdasAnalyzedWithPCLA()).add(lambda);
                                    firPCLAInferenceSession = new FirPCLAInferenceSession(candidate, InferenceComponentsKt.getInferenceComponents(firCallCompleter.session));
                                } else {
                                    firPCLAInferenceSession = null;
                                }
                                pclaInferenceSession = firPCLAInferenceSession;
                                lambdaExpression = lambdaAtom.getExpression();
                                FirDeclarationsResolveTransformer firDeclarationsResolveTransformer = firCallCompleter.transformer.getDeclarationsTransformer();
                                Intrinsics.checkNotNull(firDeclarationsResolveTransformer);
                                declarationsTransformer = firDeclarationsResolveTransformer;
                                if (pclaInferenceSession != null) {
                                    this_$iv = firCallCompleter.transformer.getContext();
                                    boolean $i$f$withInferenceSession2 = false;
                                    FirInferenceSession oldSession$iv = this_$iv.getInferenceSession();
                                    this_$iv.setInferenceSession(pclaInferenceSession);
                                    try {
                                        $this$analyzeAndGetLambdaReturnArguments_u24lambda_u2412_u24lambda_u2410 = (FirPCLAInferenceSession)((FirInferenceSession)pclaInferenceSession);
                                        bl = false;
                                        ((FirDeclarationsResolveTransformer)declarationsTransformer).doTransformAnonymousFunction$resolve(lambdaExpression, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                                        $this$analyzeAndGetLambdaReturnArguments_u24lambda_u2412_u24lambda_u2410.applyResultsToMainCandidate();
                                        unit2 = Unit.INSTANCE;
                                    }
                                    finally {
                                        this_$iv.setInferenceSession(oldSession$iv);
                                    }
                                } else {
                                    additionalConstraints = firCallCompleter.transformer.getContext().getInferenceSession().runLambdaCompletion(candidate, forOverloadByLambdaReturnType, () -> LambdaAnalyzerImpl.analyzeAndGetLambdaReturnArguments$lambda$12$lambda$11((FirDeclarationsResolveTransformer)declarationsTransformer, lambdaExpression, expectedReturnTypeRef));
                                }
                                unit8 = Unit.INSTANCE;
                            }
                            finally {
                                this_$iv$iv$iv3.setInferenceSession(oldSession$iv$iv$iv);
                            }
                            unit7 = unit8;
                        } else {
                            FirPCLAInferenceSession firPCLAInferenceSession;
                            bl2 = false;
                            boolean $i$f$runIf = false;
                            if (withPCLASession) {
                                boolean bl16 = false;
                                ((Collection)candidate.getLambdasAnalyzedWithPCLA()).add(lambda);
                                firPCLAInferenceSession = new FirPCLAInferenceSession(candidate, InferenceComponentsKt.getInferenceComponents(firCallCompleter.session));
                            } else {
                                firPCLAInferenceSession = null;
                            }
                            pclaInferenceSession = firPCLAInferenceSession;
                            lambdaExpression = lambdaAtom.getExpression();
                            FirDeclarationsResolveTransformer firDeclarationsResolveTransformer = firCallCompleter.transformer.getDeclarationsTransformer();
                            Intrinsics.checkNotNull(firDeclarationsResolveTransformer);
                            declarationsTransformer = firDeclarationsResolveTransformer;
                            if (pclaInferenceSession != null) {
                                this_$iv = firCallCompleter.transformer.getContext();
                                boolean $i$f$withInferenceSession = false;
                                FirInferenceSession oldSession$iv = this_$iv.getInferenceSession();
                                this_$iv.setInferenceSession(pclaInferenceSession);
                                try {
                                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u2412_u24lambda_u2410 = (FirPCLAInferenceSession)((FirInferenceSession)pclaInferenceSession);
                                    bl = false;
                                    ((FirDeclarationsResolveTransformer)declarationsTransformer).doTransformAnonymousFunction$resolve(lambdaExpression, new ResolutionMode.LambdaResolution(expectedReturnTypeRef));
                                    $this$analyzeAndGetLambdaReturnArguments_u24lambda_u2412_u24lambda_u2410.applyResultsToMainCandidate();
                                    unit2 = Unit.INSTANCE;
                                }
                                finally {
                                    this_$iv.setInferenceSession(oldSession$iv);
                                }
                            } else {
                                additionalConstraints = firCallCompleter.transformer.getContext().getInferenceSession().runLambdaCompletion(candidate, forOverloadByLambdaReturnType, () -> LambdaAnalyzerImpl.analyzeAndGetLambdaReturnArguments$lambda$12$lambda$11((FirDeclarationsResolveTransformer)declarationsTransformer, lambdaExpression, expectedReturnTypeRef));
                            }
                            unit7 = Unit.INSTANCE;
                        }
                        unit6 = unit7;
                    }
                    finally {
                        this_$iv$iv$iv2.setRegularTowerDataContexts(old$iv$iv$iv);
                    }
                    unit5 = unit6;
                }
                finally {
                    this_$iv$iv$iv.setTowerDataMode(initialMode$iv$iv$iv);
                }
                unit = unit5;
            }
            FirCallCompleter.this.transformer.getContext().dropContextForAnonymousFunction(lambda);
            symbol$iv = FirCallCompleter.this.components.getDataFlowAnalyzer().returnExpressionsOfAnonymousFunction(lambda);
            firCallCompleter = FirCallCompleter.this;
            boolean $i$f$map = false;
            this_$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                declarationsTransformer = (FirAnonymousFunctionReturnExpressionInfo)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl17 = false;
                ConeResolutionAtom rawAtom = ConeResolutionAtom.Companion.createRawAtom(it2.getExpression());
                object.add(expectedReturnType == null ? rawAtom : (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(firCallCompleter.session).supportsFeature(LanguageFeature.PCLAEnhancementsIn21) ? rawAtom : (rawAtom instanceof ConeAtomWithCandidate ? rawAtom : (ConeResolutionAtom)new ConeSimpleLeafResolutionAtom(it2.getExpression(), false))));
            }
            List returnArguments = (List)destination$iv$iv2;
            return new ReturnArgumentsAnalysisResult(returnArguments, additionalConstraints);
        }

        private static final Unit analyzeAndGetLambdaReturnArguments$lambda$12$lambda$11(FirDeclarationsResolveTransformer $declarationsTransformer, FirAnonymousFunctionExpression $lambdaExpression, FirResolvedTypeRef $expectedReturnTypeRef) {
            $declarationsTransformer.doTransformAnonymousFunction$resolve($lambdaExpression, new ResolutionMode.LambdaResolution($expectedReturnTypeRef));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstraintSystemCompletionMode.values().length];
            try {
                nArray[ConstraintSystemCompletionMode.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemCompletionMode.PARTIAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemCompletionMode.PCLA_POSTPONED_CALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemCompletionMode.UNTIL_FIRST_LAMBDA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

