/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirCachedSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0017\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001f\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u000bJ\u001f\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010 \u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/FirDelegatingCachedSymbolNamesProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirCachedSymbolNamesProvider;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "delegate", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;)V", "", "", "computePackageNames", "()Ljava/util/Set;", "computePackageNamesWithTopLevelClassifiers", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/name/Name;", "computeTopLevelClassifierNames", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/util/Set;", "computePackageNamesWithTopLevelCallables", "computeTopLevelCallableNames", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "", "mayHaveSyntheticFunctionType", "(Lorg/jetbrains/kotlin/name/ClassId;)Z", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getHasSpecificClassifierPackageNamesComputation", "()Z", "hasSpecificClassifierPackageNamesComputation", "getHasSpecificCallablePackageNamesComputation", "hasSpecificCallablePackageNamesComputation", "getMayHaveSyntheticFunctionTypes", "mayHaveSyntheticFunctionTypes"})
public final class FirDelegatingCachedSymbolNamesProvider
extends FirCachedSymbolNamesProvider {
    @NotNull
    private final FirSymbolNamesProvider delegate;

    public FirDelegatingCachedSymbolNamesProvider(@NotNull FirSession session, @NotNull FirSymbolNamesProvider delegate) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        super(session);
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public Set<String> computePackageNames() {
        return this.delegate.getPackageNames();
    }

    @Override
    public boolean getHasSpecificClassifierPackageNamesComputation() {
        return this.delegate.getHasSpecificClassifierPackageNamesComputation();
    }

    @Override
    @Nullable
    public Set<String> computePackageNamesWithTopLevelClassifiers() {
        return this.delegate.getPackageNamesWithTopLevelClassifiers();
    }

    @Override
    @Nullable
    public Set<Name> computeTopLevelClassifierNames(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return this.delegate.getTopLevelClassifierNamesInPackage(packageFqName);
    }

    @Override
    public boolean getHasSpecificCallablePackageNamesComputation() {
        return this.delegate.getHasSpecificCallablePackageNamesComputation();
    }

    @Override
    @Nullable
    public Set<String> computePackageNamesWithTopLevelCallables() {
        return this.delegate.getPackageNamesWithTopLevelCallables();
    }

    @Override
    @Nullable
    public Set<Name> computeTopLevelCallableNames(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return this.delegate.getTopLevelCallableNamesInPackage(packageFqName);
    }

    @Override
    public boolean getMayHaveSyntheticFunctionTypes() {
        return this.delegate.getMayHaveSyntheticFunctionTypes();
    }

    @Override
    public boolean mayHaveSyntheticFunctionType(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.delegate.mayHaveSyntheticFunctionType(classId);
    }
}

