/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousInitializerSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDanglingModifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirScriptSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H'\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0004H'\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\u0004H'\u00a2\u0006\u0004\b\r\u0010\fJ\u001b\u0010\u000b\u001a\u00020\n2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0017\u00a2\u0006\u0004\b\u000b\u0010\u0010J\u001d\u0010\r\u001a\u0004\u0018\u00010\n2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0017\u00a2\u0006\u0004\b\r\u0010\u0010J\u001d\u0010\u0012\u001a\u0004\u0018\u00010\n2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0011H'\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0014H'\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0017H'\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\t\u001a\u00020\u001bH'\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\t\u001a\u00020\u001bH'\u00a2\u0006\u0004\b!\u0010\"J!\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030#H\u0017\u00a2\u0006\u0004\b$\u0010%R\u0014\u0010)\u001a\u00020&8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010+\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "<init>", "()V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getFirClassifierByFqName", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "fqName", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFirClassifierContainerFile", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFirClassifierContainerFileIfAny", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "symbol", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirCallableContainerFile", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirScriptSymbol;", "getFirScriptContainerFile", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirScriptSymbol;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "", "path", "getFirScriptByFilePath", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirScriptSymbol;", "Lorg/jetbrains/kotlin/name/FqName;", "", "getFirFilesByPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/util/List;", "", "Lorg/jetbrains/kotlin/name/Name;", "getClassNamesInPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getContainingClass", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "symbolProvider", "", "isPhasedFirAllowed", "()Z"})
public abstract class FirProvider
implements FirSessionComponent {
    @NotNull
    public abstract FirSymbolProvider getSymbolProvider();

    public boolean isPhasedFirAllowed() {
        return false;
    }

    @Nullable
    public abstract FirClassLikeDeclaration getFirClassifierByFqName(@NotNull ClassId var1);

    @NotNull
    public abstract FirFile getFirClassifierContainerFile(@NotNull ClassId var1);

    @Nullable
    public abstract FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId var1);

    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull FirClassLikeSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return this.getFirClassifierContainerFile(symbol.getClassId());
    }

    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull FirClassLikeSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return this.getFirClassifierContainerFileIfAny(symbol.getClassId());
    }

    @Nullable
    public abstract FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> var1);

    @Nullable
    public abstract FirFile getFirScriptContainerFile(@NotNull FirScriptSymbol var1);

    @Nullable
    public abstract FirScriptSymbol getFirScriptByFilePath(@NotNull String var1);

    @NotNull
    public abstract List<FirFile> getFirFilesByPackage(@NotNull FqName var1);

    @NotNull
    public abstract Set<Name> getClassNamesInPackage(@NotNull FqName var1);

    @Nullable
    public FirClassLikeSymbol<?> getContainingClass(@NotNull FirBasedSymbol<?> symbol) {
        FirClassLikeSymbol<Object> firClassLikeSymbol;
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        FirBasedSymbol<?> firBasedSymbol = symbol;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableSymbol)symbol);
            firClassLikeSymbol = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toSymbol(coneClassLikeLookupTag, ((FirCallableSymbol)symbol).getModuleData().getSession()) : null;
        } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.getContainingClassLookupTag((FirClassLikeSymbol)symbol);
            firClassLikeSymbol = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toSymbol(coneClassLikeLookupTag, ((FirClassLikeSymbol)symbol).getModuleData().getSession()) : null;
        } else if (firBasedSymbol instanceof FirAnonymousInitializerSymbol) {
            FirBasedSymbol<?> firBasedSymbol2 = ((FirAnonymousInitializerSymbol)symbol).getContainingDeclarationSymbol();
            firClassLikeSymbol = firBasedSymbol2 instanceof FirClassLikeSymbol ? (FirClassLikeSymbol<?>)firBasedSymbol2 : null;
        } else if (firBasedSymbol instanceof FirDanglingModifierSymbol) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirDanglingModifierSymbol)symbol);
            firClassLikeSymbol = coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toSymbol(coneClassLikeLookupTag, ((FirDanglingModifierSymbol)symbol).getModuleData().getSession()) : null;
        } else {
            firClassLikeSymbol = null;
        }
        return firClassLikeSymbol;
    }
}

