/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProviderKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0017\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0017\u00a2\u0006\u0004\b\b\u0010\u0007J\u001f\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\tH'\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u0007J\u001f\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\tH'\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u00128&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00128&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001f\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "", "<init>", "()V", "", "", "getPackageNames", "()Ljava/util/Set;", "getPackageNamesWithTopLevelClassifiers", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelClassifierNamesInPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/util/Set;", "getPackageNamesWithTopLevelCallables", "getTopLevelCallableNamesInPackage", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "", "mayHaveSyntheticFunctionType", "(Lorg/jetbrains/kotlin/name/ClassId;)Z", "mayHaveTopLevelClassifier", "name", "mayHaveTopLevelCallable", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)Z", "getHasSpecificClassifierPackageNamesComputation", "()Z", "hasSpecificClassifierPackageNamesComputation", "getHasSpecificCallablePackageNamesComputation", "hasSpecificCallablePackageNamesComputation", "getMayHaveSyntheticFunctionTypes", "mayHaveSyntheticFunctionTypes"})
public abstract class FirSymbolNamesProvider {
    @Nullable
    public Set<String> getPackageNames() {
        return null;
    }

    public abstract boolean getHasSpecificClassifierPackageNamesComputation();

    @Nullable
    public Set<String> getPackageNamesWithTopLevelClassifiers() {
        return this.getPackageNames();
    }

    @Nullable
    public abstract Set<Name> getTopLevelClassifierNamesInPackage(@NotNull FqName var1);

    public abstract boolean getHasSpecificCallablePackageNamesComputation();

    @Nullable
    public Set<String> getPackageNamesWithTopLevelCallables() {
        return this.getPackageNames();
    }

    @Nullable
    public abstract Set<Name> getTopLevelCallableNamesInPackage(@NotNull FqName var1);

    public boolean getMayHaveSyntheticFunctionTypes() {
        return false;
    }

    public boolean mayHaveSyntheticFunctionType(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.getMayHaveSyntheticFunctionTypes();
    }

    public boolean mayHaveTopLevelClassifier(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        if (this.getMayHaveSyntheticFunctionTypes() && this.mayHaveSyntheticFunctionType(classId)) {
            return true;
        }
        Set<Name> set = this.getTopLevelClassifierNamesInPackage(classId.getPackageFqName());
        if (set == null) {
            return true;
        }
        Set<Name> names = set;
        return !(classId.getOuterClassId() == null ? !FirSymbolNamesProviderKt.access$mayContainTopLevelClassifier(names, classId.getShortClassName()) : !FirSymbolNamesProviderKt.access$mayContainTopLevelClassifier(names, classId.getOutermostClassId().getShortClassName()));
    }

    public boolean mayHaveTopLevelCallable(@NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        if (name.isSpecial()) {
            return true;
        }
        Set<Name> set = this.getTopLevelCallableNamesInPackage(packageFqName);
        if (set == null) {
            return true;
        }
        Set<Name> names = set;
        return names.contains(name);
    }
}

