/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.caches.FirLazyValue;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.deserialization.ClassDeserializationKt;
import org.jetbrains.kotlin.fir.deserialization.FirBuiltinAnnotationDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.deserialization.FirMemberDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirTypeDeserializer;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.impl.BinaryVersionAndPackageFragment;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirBuiltinSymbolProvidersKt;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoBasedClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002<=B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J1\u0010\u001f\u001a\u00020\u001e2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001a2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J-\u0010\"\u001a\u00020\u001e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020!0\u001a2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\"\u0010 J-\u0010#\u001a\u00020\u001e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020!0\u001a2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b#\u0010 J-\u0010%\u001a\u00020\u001e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020$0\u001a2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b%\u0010 R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010&\u001a\u0004\b'\u0010(R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010)\u001a\u0004\b*\u0010+R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010,R \u00101\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020.0-8%X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R'\u00106\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002020-8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00100R\u001a\u00108\u001a\u0002078\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/AbstractFirBuiltinSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "moduleData", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "kotlinScopeProvider", "", "isFallback", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;Z)V", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelClassifierNamesInPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Ljava/util/Set;", "fqName", "hasPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getClassLikeSymbolByClassId", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "destination", "name", "", "getTopLevelCallableSymbolsTo", "(Ljava/util/List;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelFunctionSymbolsTo", "getTopLevelFunctionSymbolsToByPackageFragments", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "Z", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/AbstractFirBuiltinSymbolProvider$BuiltInsPackageFragment;", "getBuiltInsPackageFragments", "()Ljava/util/Map;", "builtInsPackageFragments", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/AbstractFirBuiltinSymbolProvider$BuiltInsPackageFragmentWrapper;", "allPackageFragments$delegate", "Lkotlin/Lazy;", "getAllPackageFragments", "allPackageFragments", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "BuiltInsPackageFragment", "BuiltInsPackageFragmentWrapper"})
public abstract class AbstractFirBuiltinSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final FirModuleData moduleData;
    @NotNull
    private final FirKotlinScopeProvider kotlinScopeProvider;
    private final boolean isFallback;
    @NotNull
    private final Lazy allPackageFragments$delegate;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    public AbstractFirBuiltinSymbolProvider(@NotNull FirSession session, @NotNull FirModuleData moduleData2, @NotNull FirKotlinScopeProvider kotlinScopeProvider2, boolean isFallback) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(moduleData2, "moduleData");
        Intrinsics.checkNotNullParameter(kotlinScopeProvider2, "kotlinScopeProvider");
        super(session);
        this.moduleData = moduleData2;
        this.kotlinScopeProvider = kotlinScopeProvider2;
        this.isFallback = isFallback;
        this.allPackageFragments$delegate = LazyKt.lazy(() -> AbstractFirBuiltinSymbolProvider.allPackageFragments_delegate$lambda$1(this));
        this.symbolNamesProvider = new FirSymbolNamesProvider(this){
            final /* synthetic */ AbstractFirBuiltinSymbolProvider this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public Set<String> getPackageNames() {
                Set set;
                Collection $this$mapToSetOrEmpty$iv = AbstractFirBuiltinSymbolProvider.access$getAllPackageFragments(this.this$0).keySet();
                boolean $i$f$mapToSetOrEmpty = false;
                if (!$this$mapToSetOrEmpty$iv.isEmpty()) {
                    void destination$iv$iv;
                    void $this$mapTo$iv$iv;
                    Iterable iterable = $this$mapToSetOrEmpty$iv;
                    Collection collection = new LinkedHashSet<E>();
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        FqName fqName2 = (FqName)item$iv$iv;
                        void var10_10 = destination$iv$iv;
                        boolean bl = false;
                        var10_10.add(p0.asString());
                    }
                    set = (Set)destination$iv$iv;
                } else {
                    set = SetsKt.emptySet();
                }
                return set;
            }

            public boolean getHasSpecificClassifierPackageNamesComputation() {
                return false;
            }

            public boolean getHasSpecificCallablePackageNamesComputation() {
                return false;
            }

            public Set<Name> getTopLevelClassifierNamesInPackage(FqName packageFqName) {
                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                return FirBuiltinSymbolProvidersKt.getTopLevelClassifierNamesInPackage(this.this$0.getBuiltInsPackageFragments(), packageFqName);
            }

            public Set<Name> getTopLevelCallableNamesInPackage(FqName packageFqName) {
                Set<Name> set;
                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                Object object = (BuiltInsPackageFragmentWrapper)AbstractFirBuiltinSymbolProvider.access$getAllPackageFragments(this.this$0).get(packageFqName);
                if ((object != null && (object = ((BuiltInsPackageFragmentWrapper)object).getTopLevelCallableNames()) != null ? CollectionsKt.toSet((Iterable)object) : (set = null)) == null) {
                    set = SetsKt.emptySet();
                }
                return set;
            }

            public boolean getMayHaveSyntheticFunctionTypes() {
                return true;
            }
        };
    }

    @NotNull
    public final FirModuleData getModuleData() {
        return this.moduleData;
    }

    @NotNull
    public final FirKotlinScopeProvider getKotlinScopeProvider() {
        return this.kotlinScopeProvider;
    }

    @NotNull
    protected abstract Map<FqName, BuiltInsPackageFragment> getBuiltInsPackageFragments();

    @NotNull
    public final Set<Name> getTopLevelClassifierNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return FirBuiltinSymbolProvidersKt.getTopLevelClassifierNamesInPackage(this.getBuiltInsPackageFragments(), packageFqName);
    }

    private final Map<FqName, BuiltInsPackageFragmentWrapper> getAllPackageFragments() {
        Lazy lazy = this.allPackageFragments$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    public boolean hasPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return this.getAllPackageFragments().containsKey(fqName2);
    }

    @Nullable
    public FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        BuiltInsPackageFragmentWrapper builtInsPackageFragmentWrapper = this.getAllPackageFragments().get(classId.getPackageFqName());
        return builtInsPackageFragmentWrapper != null ? builtInsPackageFragmentWrapper.getClassLikeSymbolByClassId(classId) : null;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    @Override
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        block0: {
            Intrinsics.checkNotNullParameter(destination, "destination");
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(name, "name");
            Object object = this.getAllPackageFragments().get(packageFqName);
            if (object == null || (object = ((BuiltInsPackageFragmentWrapper)object).getTopLevelCallableSymbols(name)) == null) break block0;
            Object it = object;
            boolean bl = false;
            CollectionsKt.addAll((Collection)destination, (Iterable)it);
        }
    }

    @Override
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        this.getTopLevelFunctionSymbolsToByPackageFragments(destination, packageFqName, name);
    }

    private final void getTopLevelFunctionSymbolsToByPackageFragments(List<FirNamedFunctionSymbol> destination, FqName packageFqName, Name name) {
        block0: {
            Object object = this.getAllPackageFragments().get(packageFqName);
            if (object == null || (object = ((BuiltInsPackageFragmentWrapper)object).getTopLevelFunctionSymbols(name)) == null) break block0;
            Object it = object;
            boolean bl = false;
            CollectionsKt.addAll((Collection)destination, (Iterable)it);
        }
    }

    @Override
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
    }

    /*
     * WARNING - void declaration
     */
    private static final Map allPackageFragments_delegate$lambda$1(AbstractFirBuiltinSymbolProvider this$0) {
        void $this$mapValuesTo$iv$iv;
        Map<FqName, BuiltInsPackageFragment> $this$mapValues$iv = this$0.getBuiltInsPackageFragments();
        boolean $i$f$mapValues = false;
        Map<FqName, BuiltInsPackageFragment> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            FqName fqName2 = (FqName)entry2.getKey();
            BuiltInsPackageFragment foo = (BuiltInsPackageFragment)entry2.getValue();
            BuiltInsPackageFragmentWrapper builtInsPackageFragmentWrapper = new BuiltInsPackageFragmentWrapper(foo, fqName2, this$0.moduleData, this$0.kotlinScopeProvider, this$0.isFallback);
            map4.put(k, builtInsPackageFragmentWrapper);
        }
        return destination$iv$iv;
    }

    public static final /* synthetic */ Map access$getAllPackageFragments(AbstractFirBuiltinSymbolProvider $this) {
        return $this.getAllPackageFragments();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR\u0011\u0010\f\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u00118\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u00168\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/AbstractFirBuiltinSymbolProvider$BuiltInsPackageFragment;", "", "Ljava/io/InputStream;", "stream", "<init>", "(Ljava/io/InputStream;)V", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/BinaryVersionAndPackageFragment;", "binaryVersionAndPackageFragment", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/BinaryVersionAndPackageFragment;", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "version", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "getPackageProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "packageProto", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder;", "classDataFinder", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder;", "getClassDataFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder;"})
    public static final class BuiltInsPackageFragment {
        @NotNull
        private final BinaryVersionAndPackageFragment binaryVersionAndPackageFragment;
        @NotNull
        private final NameResolver nameResolver;
        @NotNull
        private final ProtoBasedClassDataFinder classDataFinder;

        public BuiltInsPackageFragment(@NotNull InputStream stream) {
            Intrinsics.checkNotNullParameter(stream, "stream");
            this.binaryVersionAndPackageFragment = BinaryVersionAndPackageFragment.Companion.createFromStream(stream);
            ProtoBuf.StringTable stringTable = this.getPackageProto().getStrings();
            Intrinsics.checkNotNullExpressionValue(stringTable, "getStrings(...)");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = this.getPackageProto().getQualifiedNames();
            Intrinsics.checkNotNullExpressionValue(qualifiedNameTable, "getQualifiedNames(...)");
            this.nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
            this.classDataFinder = new ProtoBasedClassDataFinder(this.getPackageProto(), this.nameResolver, this.getVersion(), BuiltInsPackageFragment::classDataFinder$lambda$0);
        }

        @NotNull
        public final BuiltInsBinaryVersion getVersion() {
            return this.binaryVersionAndPackageFragment.getVersion();
        }

        @NotNull
        public final ProtoBuf.PackageFragment getPackageProto() {
            return this.binaryVersionAndPackageFragment.getPackageFragment();
        }

        @NotNull
        public final NameResolver getNameResolver() {
            return this.nameResolver;
        }

        @NotNull
        public final ProtoBasedClassDataFinder getClassDataFinder() {
            return this.classDataFinder;
        }

        private static final SourceElement classDataFinder$lambda$0(ClassId it) {
            Intrinsics.checkNotNullParameter(it, "it");
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue(sourceElement, "NO_SOURCE");
            return sourceElement;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u00192\u0006\u0010\u0018\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00192\u0006\u0010\u0018\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b!\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\"R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010%R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010&\u001a\u0004\b'\u0010(R\u001a\u0010\t\u001a\u00020\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010)\u001a\u0004\b*\u0010+R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010,R\u0014\u00100\u001a\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0014\u00104\u001a\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u00108\u001a\u0002058G\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u001b\u0010>\u001a\u0002098BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R(\u0010@\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00130?8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010AR.\u0010C\u001a\u001c\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u0019\u0012\u0006\u0012\u0004\u0018\u00010B0?8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010AR \u0010E\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00190D8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010F"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/AbstractFirBuiltinSymbolProvider$BuiltInsPackageFragmentWrapper;", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/AbstractFirBuiltinSymbolProvider$BuiltInsPackageFragment;", "builtInsPackageFragment", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "moduleData", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "kotlinScopeProvider", "", "originateFromFallbackBuiltIns", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/AbstractFirBuiltinSymbolProvider$BuiltInsPackageFragment;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;Z)V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getClassLikeSymbolByClassId", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "parentContext", "findAndDeserializeClass", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/name/Name;", "name", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getTopLevelCallableSymbols", "(Lorg/jetbrains/kotlin/name/Name;)Ljava/util/List;", "", "getTopLevelCallableNames", "()Ljava/util/Collection;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelFunctionSymbols", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/AbstractFirBuiltinSymbolProvider$BuiltInsPackageFragment;", "Lorg/jetbrains/kotlin/name/FqName;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "getModuleData", "()Lorg/jetbrains/kotlin/fir/FirModuleData;", "Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/FirKotlinScopeProvider;", "Z", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "getPackageProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "packageProto", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder;", "getClassDataFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder;", "classDataFinder", "Lorg/jetbrains/kotlin/fir/deserialization/FirMemberDeserializer;", "memberDeserializer$delegate", "Lkotlin/Lazy;", "getMemberDeserializer", "()Lorg/jetbrains/kotlin/fir/deserialization/FirMemberDeserializer;", "memberDeserializer", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "classCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "", "functionCache", "Lorg/jetbrains/kotlin/fir/caches/FirLazyValue;", "functionsNameCache", "Lorg/jetbrains/kotlin/fir/caches/FirLazyValue;"})
    private static final class BuiltInsPackageFragmentWrapper {
        @NotNull
        private final BuiltInsPackageFragment builtInsPackageFragment;
        @NotNull
        private final FqName fqName;
        @NotNull
        private final FirModuleData moduleData;
        @NotNull
        private final FirKotlinScopeProvider kotlinScopeProvider;
        private final boolean originateFromFallbackBuiltIns;
        @NotNull
        private final Lazy memberDeserializer$delegate;
        @NotNull
        private final FirCache<ClassId, FirRegularClassSymbol, FirDeserializationContext> classCache;
        @NotNull
        private final FirCache functionCache;
        @NotNull
        private final FirLazyValue<List<Name>> functionsNameCache;

        public BuiltInsPackageFragmentWrapper(@NotNull BuiltInsPackageFragment builtInsPackageFragment, @NotNull FqName fqName2, @NotNull FirModuleData moduleData2, @NotNull FirKotlinScopeProvider kotlinScopeProvider2, boolean originateFromFallbackBuiltIns) {
            Intrinsics.checkNotNullParameter(builtInsPackageFragment, "builtInsPackageFragment");
            Intrinsics.checkNotNullParameter(fqName2, "fqName");
            Intrinsics.checkNotNullParameter(moduleData2, "moduleData");
            Intrinsics.checkNotNullParameter(kotlinScopeProvider2, "kotlinScopeProvider");
            this.builtInsPackageFragment = builtInsPackageFragment;
            this.fqName = fqName2;
            this.moduleData = moduleData2;
            this.kotlinScopeProvider = kotlinScopeProvider2;
            this.originateFromFallbackBuiltIns = originateFromFallbackBuiltIns;
            this.memberDeserializer$delegate = LazyKt.lazy(() -> BuiltInsPackageFragmentWrapper.memberDeserializer_delegate$lambda$0(this));
            this.classCache = FirCachesFactoryKt.getFirCachesFactory(this.moduleData.getSession()).createCacheWithPostCompute(BuiltInsPackageFragmentWrapper::classCache$lambda$1, (arg_0, arg_1, arg_2) -> BuiltInsPackageFragmentWrapper.classCache$lambda$2(this, arg_0, arg_1, arg_2));
            FirCachesFactory $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(this.moduleData.getSession());
            boolean $i$f$createCache = false;
            this.functionCache = $this$createCache$iv.createCache(new Function2(this){
                final /* synthetic */ BuiltInsPackageFragmentWrapper this$0;
                {
                    this.this$0 = builtInsPackageFragmentWrapper;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final Object invoke(Object key, Void void_) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    ProtoBuf.Function it;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter(key, "key");
                    Name name = (Name)key;
                    boolean bl = false;
                    List<ProtoBuf.Function> list = BuiltInsPackageFragmentWrapper.access$getPackageProto(this.this$0).getPackage().getFunctionList();
                    Intrinsics.checkNotNullExpressionValue(list, "getFunctionList(...)");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (ProtoBuf.Function)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(NameResolverUtilKt.getName(BuiltInsPackageFragmentWrapper.access$getNameResolver(this.this$0), it.getName()), name)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (ProtoBuf.Function)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        FirMemberDeserializer firMemberDeserializer = BuiltInsPackageFragmentWrapper.access$getMemberDeserializer(this.this$0);
                        Intrinsics.checkNotNull(it);
                        collection.add(FirMemberDeserializer.loadFunction$default(firMemberDeserializer, it, null, null, null, 14, null).getSymbol());
                    }
                    return (List)destination$iv$iv;
                }
            });
            this.functionsNameCache = FirCachesFactoryKt.getFirCachesFactory(this.moduleData.getSession()).createLazyValue(() -> BuiltInsPackageFragmentWrapper.functionsNameCache$lambda$7(this));
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public final FirModuleData getModuleData() {
            return this.moduleData;
        }

        @NotNull
        public final FirKotlinScopeProvider getKotlinScopeProvider() {
            return this.kotlinScopeProvider;
        }

        private final ProtoBuf.PackageFragment getPackageProto() {
            return this.builtInsPackageFragment.getPackageProto();
        }

        private final NameResolver getNameResolver() {
            return this.builtInsPackageFragment.getNameResolver();
        }

        @NotNull
        public final ProtoBasedClassDataFinder getClassDataFinder() {
            return this.builtInsPackageFragment.getClassDataFinder();
        }

        private final FirMemberDeserializer getMemberDeserializer() {
            Lazy lazy = this.memberDeserializer$delegate;
            return (FirMemberDeserializer)lazy.getValue();
        }

        @Nullable
        public final FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            return BuiltInsPackageFragmentWrapper.findAndDeserializeClass$default(this, classId, null, 2, null);
        }

        private final FirRegularClassSymbol findAndDeserializeClass(ClassId classId, FirDeserializationContext parentContext) {
            boolean classIdExists = this.getClassDataFinder().getAllClassIds().contains(classId);
            if (!classIdExists) {
                return null;
            }
            return this.classCache.getValue(classId, parentContext);
        }

        static /* synthetic */ FirRegularClassSymbol findAndDeserializeClass$default(BuiltInsPackageFragmentWrapper builtInsPackageFragmentWrapper, ClassId classId, FirDeserializationContext firDeserializationContext, int n, Object object) {
            if ((n & 2) != 0) {
                firDeserializationContext = null;
            }
            return builtInsPackageFragmentWrapper.findAndDeserializeClass(classId, firDeserializationContext);
        }

        @NotNull
        public final List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull Name name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return this.getTopLevelFunctionSymbols(name);
        }

        @NotNull
        public final Collection<Name> getTopLevelCallableNames() {
            return this.functionsNameCache.getValue();
        }

        @NotNull
        public final List<FirNamedFunctionSymbol> getTopLevelFunctionSymbols(@NotNull Name name) {
            Intrinsics.checkNotNullParameter(name, "name");
            FirCache $this$getValue$iv = this.functionCache;
            boolean $i$f$getValue = false;
            return (List)$this$getValue$iv.getValue(name, null);
        }

        private static final FirMemberDeserializer memberDeserializer_delegate$lambda$0(BuiltInsPackageFragmentWrapper this$0) {
            FqName fqName2 = this$0.fqName;
            ProtoBuf.Package package_ = this$0.getPackageProto().getPackage();
            Intrinsics.checkNotNullExpressionValue(package_, "getPackage(...)");
            return FirDeserializationContext.Companion.createForPackage(fqName2, package_, this$0.getNameResolver(), this$0.moduleData, new FirBuiltinAnnotationDeserializer(this$0.moduleData.getSession()), FirTypeDeserializer.FlexibleTypeFactory.Default.INSTANCE, new FirConstDeserializer(BuiltInSerializerProtocol.INSTANCE), null).getMemberDeserializer();
        }

        private static final Pair classCache$lambda$1(ClassId classId, FirDeserializationContext context) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            return TuplesKt.to(new FirRegularClassSymbol(classId), context);
        }

        private static final Unit classCache$lambda$2(BuiltInsPackageFragmentWrapper this$0, ClassId classId, FirRegularClassSymbol symbol, FirDeserializationContext parentContext) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            ClassData classData = this$0.getClassDataFinder().findClassData(classId);
            Intrinsics.checkNotNull(classData);
            ClassData classData2 = classData;
            ProtoBuf.Class classProto2 = classData2.getClassProto();
            ClassDeserializationKt.deserializeClassToSymbol(classId, classProto2, symbol, this$0.getNameResolver(), this$0.moduleData.getSession(), this$0.moduleData, null, FirTypeDeserializer.FlexibleTypeFactory.Default.INSTANCE, this$0.kotlinScopeProvider, BuiltInSerializerProtocol.INSTANCE, parentContext, null, this$0.originateFromFallbackBuiltIns ? (FirDeclarationOrigin)FirDeclarationOrigin.BuiltInsFallback.INSTANCE : (FirDeclarationOrigin)FirDeclarationOrigin.BuiltIns.INSTANCE, (Function2<? super ClassId, ? super FirDeserializationContext, FirRegularClassSymbol>)new Function2<ClassId, FirDeserializationContext, FirRegularClassSymbol>((Object)this$0){

                public final FirRegularClassSymbol invoke(ClassId p0, FirDeserializationContext p1) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return BuiltInsPackageFragmentWrapper.access$findAndDeserializeClass((BuiltInsPackageFragmentWrapper)this.receiver, p0, p1);
                }
            });
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final List functionsNameCache$lambda$7(BuiltInsPackageFragmentWrapper this$0) {
            void $this$mapTo$iv$iv;
            List<ProtoBuf.Function> list = this$0.getPackageProto().getPackage().getFunctionList();
            Intrinsics.checkNotNullExpressionValue(list, "getFunctionList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Function function2 = (ProtoBuf.Function)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(NameResolverUtilKt.getName(this$0.getNameResolver(), it.getName()));
            }
            return (List)destination$iv$iv;
        }

        public static final /* synthetic */ FirRegularClassSymbol access$findAndDeserializeClass(BuiltInsPackageFragmentWrapper $this, ClassId classId, FirDeserializationContext parentContext) {
            return $this.findAndDeserializeClass(classId, parentContext);
        }

        public static final /* synthetic */ NameResolver access$getNameResolver(BuiltInsPackageFragmentWrapper $this) {
            return $this.getNameResolver();
        }

        public static final /* synthetic */ FirMemberDeserializer access$getMemberDeserializer(BuiltInsPackageFragmentWrapper $this) {
            return $this.getMemberDeserializer();
        }

        public static final /* synthetic */ ProtoBuf.PackageFragment access$getPackageProto(BuiltInsPackageFragmentWrapper $this) {
            return $this.getPackageProto();
        }
    }
}

