/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirCompositeSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ1\u0010\u0012\u001a\u00020\u00112\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0015\u001a\u00020\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0013J-\u0010\u0017\u001a\u00020\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0013J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001e2\u0006\u0010\u001d\u001a\u00020\u001cH\u0017\u00a2\u0006\u0004\b\u001f\u0010 R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010#R\u001a\u0010%\u001a\u00020$8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010("}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirCompositeSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "providers", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/List;)V", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/name/Name;", "name", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getTopLevelCallableSymbols", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)Ljava/util/List;", "", "destination", "", "getTopLevelCallableSymbolsTo", "(Ljava/util/List;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getTopLevelPropertySymbolsTo", "fqName", "", "hasPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getClassLikeSymbolByClassId", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Ljava/util/List;", "getProviders", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;"})
public final class FirCompositeSymbolProvider
extends FirSymbolProvider {
    @NotNull
    private final List<FirSymbolProvider> providers;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    public FirCompositeSymbolProvider(@NotNull FirSession session, @NotNull List<? extends FirSymbolProvider> providers) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(providers, "providers");
        super(session);
        this.providers = providers;
        this.symbolNamesProvider = FirCompositeSymbolNamesProvider.Companion.fromSymbolProviders(this.providers);
    }

    @NotNull
    public final List<FirSymbolProvider> getProviders() {
        return this.providers;
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        Iterable $this$flatMap$iv = this.providers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirSymbolProvider it = (FirSymbolProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTopLevelCallableSymbols(packageFqName, name);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        CollectionsKt.addAll((Collection)destination, (Iterable)this.getTopLevelCallableSymbols(packageFqName, name));
    }

    @Override
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        Iterable $this$forEach$iv = this.providers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirSymbolProvider it = (FirSymbolProvider)element$iv;
            boolean bl = false;
            it.getTopLevelFunctionSymbolsTo(destination, packageFqName, name);
        }
    }

    @Override
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name, "name");
        Iterable $this$forEach$iv = this.providers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirSymbolProvider it = (FirSymbolProvider)element$iv;
            boolean bl = false;
            it.getTopLevelPropertySymbolsTo(destination, packageFqName, name);
        }
    }

    @Override
    public boolean hasPackage(@NotNull FqName fqName2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(fqName2, "fqName");
            Iterable $this$any$iv = this.providers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirSymbolProvider it = (FirSymbolProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.hasPackage(fqName2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public FirClassLikeSymbol<?> getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        block1: {
            Intrinsics.checkNotNullParameter(classId, "classId");
            for (FirSymbolProvider it : (Iterable)this.providers) {
                boolean bl = false;
                FirClassLikeSymbol<?> firClassLikeSymbol2 = it.getClassLikeSymbolByClassId(classId);
                if (firClassLikeSymbol2 == null) continue;
                firClassLikeSymbol = firClassLikeSymbol2;
                break block1;
            }
            firClassLikeSymbol = null;
        }
        return firClassLikeSymbol;
    }
}

